/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.business.template.DynamicRowBizBusiness;
import kd.taxc.bdtaxr.common.enums.DynamicRowCheckTypeEnum;

public class DynamicRowCheckListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object[] objects;
        IDataModel model = this.getModel();
        String checkEntryStr = (String)this.getView().getFormShowParameter().getCustomParam("checkEntry");
        if (StringUtils.isNotBlank((CharSequence)checkEntryStr) && (objects = DynamicObjectSerializeUtil.deserialize((String)checkEntryStr, (DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType())) != null && objects.length > 0) {
            List checkEntry = Arrays.stream(objects).map(v -> (DynamicObject)v).collect(Collectors.toList());
            for (DynamicObject entry : checkEntry) {
                int rowIndex = model.createNewEntryRow(ENTRYENTITY);
                model.setValue("enable", (Object)entry.getBoolean("entryenable"), rowIndex);
                model.setValue("description", entry.get("description"), rowIndex);
                model.setValue("rule", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{entry}, (DynamicObjectType)entry.getDynamicObjectType()), rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.returnData();
        }
    }

    private void returnData() {
        DynamicObjectCollection checkEntry = new DynamicObjectCollection();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject entry = null;
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entryEntity.get(i);
            Object[] ruleObjs = DynamicObjectSerializeUtil.deserialize((String)((String)entry.get("rule")), (DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType());
            if (ruleObjs == null || ruleObjs.length <= 0) continue;
            DynamicObject rule = (DynamicObject)ruleObjs[0];
            rule.set("entryenable", entry.get("enable"));
            rule.set("seq", (Object)(i + 1));
            checkEntry.add((Object)rule);
        }
        this.getView().returnDataToParent((Object)checkEntry);
        this.getView().close();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("btnnew")) {
            this.selectCheckType();
        } else if (key.equals("btnedit")) {
            this.editCheckRule();
        } else if (key.equals("btndel")) {
            this.deleteCheckRule();
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.editCheckRule();
    }

    private void selectCheckType() {
        if (DynamicRowCheckTypeEnum.values().length == 1) {
            this.addCheckRule(DynamicRowCheckTypeEnum.values()[0]);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("bdtaxr_dynrow_checktype");
            showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectCheckType"));
            this.getView().showForm(showParameter);
        }
    }

    private void addCheckRule(DynamicRowCheckTypeEnum checkType) {
        if (checkType == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(checkType.getSettingFormId());
        showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addCheckRule"));
        this.getView().showForm(showParameter);
    }

    private void editCheckRule() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (rowIndex == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DynamicRowCheckListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (rowIndex <= -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DynamicRowCheckListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            } else {
                String checkType;
                DynamicRowCheckTypeEnum checkTypeEnum;
                String ruleStr = (String)this.getModel().getValue("rule", rowIndex);
                DynamicObject rule = this.getRuleObject(ruleStr);
                if (rule != null && (checkTypeEnum = DynamicRowCheckTypeEnum.getEnum((String)(checkType = rule.getString("checktype")))) != null) {
                    showParameter.setFormId(checkTypeEnum.getSettingFormId());
                    showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                    showParameter.setCustomParam("rule", (Object)ruleStr);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editCheckRule"));
                    this.getView().showForm(showParameter);
                }
            }
        }
    }

    private DynamicObject getRuleObject(String ruleStr) {
        Object[] ruleObjs = DynamicObjectSerializeUtil.deserialize((String)ruleStr, (DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType());
        if (ruleObjs != null && ruleObjs.length > 0) {
            return (DynamicObject)ruleObjs[0];
        }
        return null;
    }

    private void deleteCheckRule() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int rowKey = grid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (rowKey >= 0 && count > 0) {
            this.getModel().deleteEntryRow(ENTRYENTITY, rowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DynamicRowCheckListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnObj;
        if ("selectCheckType".equals(event.getActionId())) {
            Object returnObj2 = event.getReturnData();
            if (returnObj2 != null) {
                Map map = (Map)returnObj2;
                String ruleType = (String)map.get("ruletype");
                DynamicRowCheckTypeEnum checkType = DynamicRowCheckTypeEnum.getEnum((String)ruleType);
                this.addCheckRule(checkType);
            }
        } else if ("addCheckRule".equals(event.getActionId())) {
            Object returnObj3 = event.getReturnData();
            if (returnObj3 != null) {
                DynamicObject entry = (DynamicObject)returnObj3;
                IDataModel model = this.getModel();
                int rowIndex = model.createNewEntryRow(ENTRYENTITY);
                this.setEntryValue(entry, rowIndex);
            }
        } else if ("editCheckRule".equals(event.getActionId()) && (returnObj = event.getReturnData()) != null) {
            DynamicObject entry = (DynamicObject)returnObj;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
            int rowIndex = grid.getEntryState().getFocusRow();
            this.setEntryValue(entry, rowIndex);
        }
    }

    private void setEntryValue(DynamicObject entry, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("description", entry.get("description"), rowIndex);
        model.setValue("rule", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{entry}, (DynamicObjectType)entry.getDynamicObjectType()), rowIndex);
    }
}

