/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;

public class DynamicRowSelectedFieldsHelper {
    static final String CACHEKEY_CHECKNODES = "checkNodes";
    private static final String VALUE = "value";
    IFormView formView;
    TreeView treeView;
    F7SelectedList selectedList;
    TreeNode root = null;

    public DynamicRowSelectedFieldsHelper(IFormView formView, TreeView treeView, F7SelectedList selectedList, TreeNode root) {
        this.formView = formView;
        this.treeView = treeView;
        this.selectedList = selectedList;
        this.root = root;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public F7SelectedList getSelectedList() {
        return this.selectedList;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    protected IPageCache getPageCache() {
        return (IPageCache)this.formView.getService(IPageCache.class);
    }

    public List<String> getSelectedFields() {
        String str = this.getPageCache().get(CACHEKEY_CHECKNODES);
        return StringUtils.isBlank((CharSequence)str) ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)str, List.class);
    }

    public void initSelectedFields(List<String> fieldIds) {
        List<String> selectedIds = this.addSelectedFields(fieldIds);
        ArrayList<String> deletedNodesIds = new ArrayList<String>(fieldIds);
        deletedNodesIds.removeAll(selectedIds);
        if (!deletedNodesIds.isEmpty()) {
            this.getFormView().showTipNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5b57\u6bb5\uff1a%s\uff0c\u8bf7\u5220\u9664\u3002", (String)"DynamicRowSelectedFieldsHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), String.join((CharSequence)", ", deletedNodesIds)));
        }
        ArrayList<TreeNode> currNodes = new ArrayList<TreeNode>(10);
        for (String id : selectedIds) {
            currNodes.add(this.root.getTreeNode(id, 16));
        }
        if (!currNodes.isEmpty()) {
            this.getTreeView().checkNodes(currNodes);
        }
        this.getPageCache().put(CACHEKEY_CHECKNODES, SerializationUtils.toJsonString(selectedIds));
    }

    public void onTreeNodeCheck(boolean check) {
        List currNodes = this.getTreeView().getTreeState().getCheckedNodeIds();
        List<String> selectedIds = check ? this.addSelectedFields(currNodes) : this.removeSelectedFields(currNodes);
        this.getPageCache().put(CACHEKEY_CHECKNODES, SerializationUtils.toJsonString(selectedIds));
    }

    public void onSelectedListRemoveClick(F7SelectedListRemoveEvent e) {
        List<String> selectedIds = this.getSelectedFields();
        if (e.getParam() != null) {
            this.getTreeView().uncheckNode(e.getParam().toString());
            selectedIds.remove(e.getParam().toString());
        } else {
            this.getTreeView().uncheckNodes(this.getTreeView().getTreeState().getCheckedNodeIds());
            selectedIds.clear();
        }
        this.getPageCache().put(CACHEKEY_CHECKNODES, SerializationUtils.toJsonString(selectedIds));
    }

    private List<String> addSelectedFields(List<String> currNodeIds) {
        ArrayList<String> selectedIds = new ArrayList<String>(10);
        List<String> histNodeIds = this.getSelectedFields();
        ArrayList<String> addList = new ArrayList<String>(10);
        addList.addAll(currNodeIds);
        selectedIds.addAll(histNodeIds);
        if (histNodeIds.isEmpty() || addList.removeAll(histNodeIds)) {
            selectedIds = new ArrayList(10);
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
            for (String id : currNodeIds) {
                HashMap<String, String> map;
                TreeNode node = this.root.getTreeNode(id, 16);
                if (node != null && (node.getChildren() == null || node.getChildren().isEmpty()) && !node.getId().equals(this.root.getId())) {
                    map = new HashMap(4);
                    map.put(VALUE, node.getId());
                    TreeNode parentNode = this.root.getTreeNode(node.getParentid(), 16);
                    if (parentNode != null) {
                        String parentText = parentNode.getText();
                        if ("_headNode_".equalsIgnoreCase(parentNode.getId()) && ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"DynamicRowSelectedFieldsHelper_1", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(parentNode.getText())) {
                            map.put("text", node.getText());
                        } else if (parentText.indexOf("(") == -1) {
                            map.put("text", parentText + "\u00b7" + node.getText());
                        } else {
                            map.put("text", parentText.substring(0, parentText.indexOf("(")) + "\u00b7" + node.getText());
                        }
                    } else {
                        map.put("text", node.getText());
                    }
                    list.add(map);
                    selectedIds.add(node.getId());
                    continue;
                }
                if (node != null) continue;
                map = new HashMap<String, String>(4);
                map.put(VALUE, id);
                map.put("text", id);
                list.add(map);
            }
            if (!list.isEmpty()) {
                this.addSelectedListItems(list);
            }
        }
        return selectedIds;
    }

    private List<String> removeSelectedFields(List<String> currNodeIds) {
        List<String> histNodeIds = this.getSelectedFields();
        ArrayList<String> delList = new ArrayList<String>(10);
        delList.addAll(histNodeIds);
        if (currNodeIds.isEmpty() || delList.removeAll(currNodeIds)) {
            for (int i = 0; i < delList.size(); ++i) {
                TreeNode node = this.root.getTreeNode((String)delList.get(i), 16);
                if (node == null) continue;
                histNodeIds.remove(node.getId());
                this.getSelectedList().removeItem((Object)node.getId());
            }
        }
        return histNodeIds;
    }

    private void addSelectedListItems(List<Map<String, String>> list) {
        ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>(10);
        for (Map<String, String> map : list) {
            listValue.add(new ValueTextItem(map.get(VALUE), map.get("text")));
        }
        this.getSelectedList().addItems(listValue);
    }
}

