/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.business.template.DynamicRowBizBusiness;
import kd.taxc.bdtaxr.common.enums.DynamicRowCheckTypeEnum;
import kd.taxc.bdtaxr.formplugin.template.DynamicRowSelectedFieldsHelper;

public class DynamicRowUniqueCheckPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
F7SelectedListRemoveListener {
    private static final String FIELDTREE = "fieldtree";
    private static final String SELECTEDFIELDS = "selectedfields";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    protected void init() {
        Long templateId = (Long)this.getView().getFormShowParameter().getCustomParam("templateId");
        String dynrowno = (String)this.getView().getFormShowParameter().getCustomParam("dynrowno");
        Map<String, List<DynamicObject>> reportItemMap = DynamicRowBizBusiness.getDynRowReportItems(templateId);
        this.initTree(reportItemMap.get(dynrowno));
        this.initDynrowRange(reportItemMap);
        this.showCheck();
    }

    protected void showCheck() {
        String dynrowrangeStr;
        DynamicObject check = this.loadCheck();
        String checkFields = check.getString("colrange");
        if (StringUtils.isNotEmpty((CharSequence)checkFields)) {
            List<String> fields = Arrays.stream(checkFields.split(",")).collect(Collectors.toList());
            this.getSelectedHelper().initSelectedFields(fields);
        }
        if (StringUtils.isNotEmpty((CharSequence)(dynrowrangeStr = check.getString("dynrowrange")))) {
            this.getModel().setValue("dynrowrange", (Object)dynrowrangeStr);
        }
        this.getModel().setValue("description", (Object)check.getString("description"));
        this.getModel().setValue("checklevel", (Object)check.getString("checklevel"));
        this.getModel().setValue("content", (Object)check.getString("content"));
        this.getModel().setValue("title", (Object)check.getString("title"));
        this.getModel().setValue("condition", (Object)check.getString("condition"));
    }

    protected DynamicObject loadCheck() {
        String ruleStr = (String)this.getView().getFormShowParameter().getCustomParam("rule");
        if (StringUtils.isNotEmpty((CharSequence)ruleStr)) {
            Object[] objects = DynamicObjectSerializeUtil.deserialize((String)ruleStr, (DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType());
            if (objects != null && objects.length > 0) {
                return (DynamicObject)objects[0];
            }
        } else {
            return this.getNewCheck();
        }
        return null;
    }

    protected DynamicObject getNewCheck() {
        DynamicObject check = new DynamicObject((DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType());
        check.set("description", (Object)ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c", (String)"DynamicRowUniqueCheckPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        check.set("checklevel", (Object)"A");
        check.set("checktype", (Object)DynamicRowCheckTypeEnum.UNIQUE.getId());
        check.set("entryenable", (Object)"1");
        return check;
    }

    protected DynamicObject getCheck() {
        DynamicObject check = this.loadCheck();
        List<String> selectedFields = this.getSelectedHelper().getSelectedFields();
        check.set("colrange", (Object)selectedFields.stream().collect(Collectors.joining(",")));
        check.set("dynrowrange", this.getModel().getValue("dynrowrange"));
        check.set("description", this.getModel().getValue("description"));
        check.set("checklevel", this.getModel().getValue("checklevel"));
        check.set("content", this.getModel().getValue("content"));
        check.set("title", this.getModel().getValue("title"));
        check.set("condition", this.getModel().getValue("condition"));
        return check;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        F7SelectedList selectedList = (F7SelectedList)this.getView().getControl(SELECTEDFIELDS);
        selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        TreeView treeView = (TreeView)this.getControl(FIELDTREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btnok", "condition"});
    }

    public void click(EventObject evt) {
        IDataModel model = this.getModel();
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "condition": {
                this.showConditionForm();
                break;
            }
        }
    }

    protected void returnData() {
        if (this.verify()) {
            DynamicObject check = this.getCheck();
            this.getView().returnDataToParent((Object)check);
            this.getView().close();
        }
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bdtaxr_dynrow_condition");
        showParameter.setCustomParam("condition", this.getModel().getValue("condition"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editCondition"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnObj;
        super.closedCallBack(event);
        if ("editCondition".equals(event.getActionId()) && (returnObj = event.getReturnData()) != null) {
            this.getModel().setValue("condition", (Object)returnObj.toString());
            this.getView().updateView("condition");
        }
    }

    protected boolean verify() {
        List<String> selectedFields = this.getSelectedHelper().getSelectedFields();
        if (selectedFields == null || selectedFields.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u7ef4\u3002", (String)"DynamicRowUniqueCheckPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        this.getSelectedHelper().onTreeNodeCheck(e.getChecked());
    }

    public void RemoveClick(F7SelectedListRemoveEvent e) {
        this.getSelectedHelper().onSelectedListRemoveClick(e);
    }

    private DynamicRowSelectedFieldsHelper getSelectedHelper() {
        TreeView treeView = (TreeView)this.getControl(FIELDTREE);
        F7SelectedList selectedList = (F7SelectedList)this.getControl(SELECTEDFIELDS);
        TreeNode node = this.loadCacheTreeNode();
        for (TreeNode n : node.getChildren()) {
            n.setParentid(node.getId());
        }
        return new DynamicRowSelectedFieldsHelper(this.getView(), treeView, selectedList, node);
    }

    protected void cacheTreeNode(TreeNode root) {
        this.getPageCache().put(FIELDTREE, SerializationUtils.toJsonString((Object)root));
    }

    protected TreeNode loadCacheTreeNode() {
        String json = this.getPageCache().get(FIELDTREE);
        return StringUtils.isBlank((CharSequence)json) ? null : (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
    }

    private void initTree(List<DynamicObject> dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        DynamicObject rowObj = dynamicObjects.get(0).getDynamicObject("row");
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(rowObj.getString("name"));
        root.setChildren(new ArrayList(10));
        for (DynamicObject reportItem : dynamicObjects) {
            DynamicObject columnObj = reportItem.getDynamicObject("col");
            if (columnObj == null) continue;
            TreeNode node = new TreeNode();
            node.setId(columnObj.getString("number"));
            node.setText(columnObj.getString("name"));
            root.getChildren().add(node);
        }
        TreeView tree = (TreeView)this.getControl(FIELDTREE);
        tree.addNode(root);
        tree.expand(root.getId());
        this.cacheTreeNode(root);
    }

    private void initDynrowRange(Map<String, List<DynamicObject>> reportItemMap) {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        for (String key : reportItemMap.keySet()) {
            data.add(new ComboItem(new LocaleString(key), String.valueOf(key)));
        }
        MulComboEdit mulComboEdit = (MulComboEdit)this.getView().getControl("dynrowrange");
        mulComboEdit.setComboItems(data);
    }
}

