/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.template.DynamicRowBizBusiness;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TemplateDynRowPlugin
extends AbstractFormPlugin {
    public static final String IDENTITYCOLUMN = "identitycolumn";
    private static final String RULE_ID = "rule_id";
    private static final String RULE_NAME = "rule_name";
    private static final String BDTAXR_RULE_SET = "bdtaxr_batch_rule_set";
    private static final String DYNROW_NO = "dynrow_no";
    private static final String GROUP_NO = "group_no";
    private static final String SEQ_NO = "seq_no";
    private static final String START_ROW = "start_row";
    private static final String DISABLE_FRONTOP = "disablefrontop";
    private static final String FILTER = "filter";
    private static final String DYNHEADER = "dynheader";
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    private static final String TYPE = "type";
    private static final String PLUGIN_PATH = "pluginpath";
    private static final String MODELTYPE = "modeltype";
    private static final String CHECKRULES = "checkrules";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", RULE_NAME, CHECKRULES});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String selectedKey = (String)customParams.get("selectCellKey");
        String modeltype = (String)customParams.get(MODELTYPE);
        if (StringUtil.isNotEmpty((CharSequence)selectedKey) && selectedKey.contains("#")) {
            selectedKey = selectedKey.substring(0, selectedKey.lastIndexOf(35));
            this.getModel().setValue(DYNROW_NO, (Object)selectedKey);
            Long templateId = (Long)customParams.get("templateId");
            DynamicObject dObj = DynamicRowBizBusiness.getDynRowData(templateId, selectedKey, modeltype);
            if (dObj != null) {
                this.getModel().setValue(RULE_ID, (Object)dObj.getLong(RULE_ID));
                this.getModel().setValue(RULE_NAME, (Object)dObj.getString(RULE_NAME));
                this.getModel().setValue(TYPE, (Object)dObj.getString(TYPE));
                this.getModel().setValue(PLUGIN_PATH, (Object)dObj.getString(PLUGIN_PATH));
                this.getModel().setValue(SEQ_NO, dObj.get(SEQ_NO));
                this.getModel().setValue(GROUP_NO, (Object)dObj.getString(GROUP_NO));
                this.getModel().setValue(START_ROW, dObj.get(START_ROW));
                this.getModel().setValue(DISABLE_FRONTOP, dObj.get(DISABLE_FRONTOP));
                this.getModel().setValue(MODELTYPE, dObj.get(MODELTYPE));
                this.getModel().setValue(FILTER, (Object)dObj.getBoolean(FILTER));
                this.getModel().setValue(DYNHEADER, dObj.get(DYNHEADER));
                this.getModel().setValue(IDENTITYCOLUMN, dObj.get(IDENTITYCOLUMN));
                if (Objects.equals(customParams.get("jumpFrom"), "muldi")) {
                    this.initIdentityColumnControl();
                    DynamicObjectCollection checkEntry = dObj.getDynamicObjectCollection("checkentry");
                    this.loadCheckEntry(checkEntry);
                }
            } else {
                this.getModel().setValue(MODELTYPE, (Object)modeltype);
            }
        }
        if (Objects.equals(customParams.get("jumpFrom"), "muldi")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{START_ROW});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTER});
            this.getView().setVisible(Boolean.FALSE, new String[]{DYNHEADER});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHECKRULES});
            this.getView().setVisible(Boolean.FALSE, new String[]{IDENTITYCOLUMN});
        }
    }

    protected void initIdentityColumnControl() {
        Long templateId = (Long)this.getView().getFormShowParameter().getCustomParam("templateId");
        String dynrowno = (String)this.getModel().getValue(DYNROW_NO);
        Map<String, List<DynamicObject>> reportItemMap = DynamicRowBizBusiness.getDynRowReportItems(templateId);
        MulComboEdit mulComboEdit = (MulComboEdit)this.getView().getControl(IDENTITYCOLUMN);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        List<DynamicObject> dynamicObjects = reportItemMap.get(dynrowno);
        for (DynamicObject reportItem : dynamicObjects) {
            DynamicObject columnObj = reportItem.getDynamicObject("col");
            if (columnObj == null) continue;
            data.add(new ComboItem(new LocaleString(columnObj.getString("name")), String.valueOf(columnObj.getString("number"))));
        }
        mulComboEdit.setComboItems(data);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("btnok")) {
            Object type = this.getModel().getValue(TYPE);
            if (StringUtil.isBlank((CharSequence)((String)this.getModel().getValue(DYNROW_NO)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a8\u6001\u884c\u6807\u8bc6\u4e3a\u7a7a", (String)"TemplateDynRowPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (Objects.equals(type, "plugin_fetch")) {
                if (StringUtil.isBlank((CharSequence)((String)this.getModel().getValue(PLUGIN_PATH)))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u8def\u5f84\u4e3a\u7a7a", (String)"TemplateDynRowPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
            } else if (StringUtil.isBlank((CharSequence)((String)this.getModel().getValue(RULE_NAME)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u4e3a\u7a7a", (String)"TemplateDynRowPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            if (((Boolean)this.getModel().getValue(FILTER)).booleanValue() && this.getModel().getValue(DYNHEADER) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u82e5\u542f\u7528\u52a8\u6001\u884c\u7b5b\u9009\uff0c\u9700\u8981\u586b\u5199\u52a8\u6001\u884c\u6807\u9898\u6240\u5728\u884c\u53f7\u3002", (String)"TemplateDynRowPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.saveDynamicRow(type);
        } else if (key.equals(RULE_NAME)) {
            this.showQushuForm(this.getView().getParentView().getFormShowParameter().getCustomParams());
        } else if (key.equals(CHECKRULES)) {
            this.showCheckRuleForm();
        }
    }

    private void showCheckRuleForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_dynrow_checklist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long templateId = (Long)customParams.get("templateId");
        String dynrowno = (String)this.getModel().getValue(DYNROW_NO);
        showParameter.setCustomParam("templateId", (Object)templateId);
        showParameter.setCustomParam("dynrowno", (Object)dynrowno);
        DynamicObjectCollection checkEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("checkentry");
        String checkEntryStr = DynamicObjectSerializeUtil.serialize((Object[])checkEntry.toArray(new Object[checkEntry.size()]), (DynamicObjectType)DynamicRowBizBusiness.getCheckEntryEntityType());
        showParameter.setCustomParam("checkEntry", (Object)checkEntryStr);
        showParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectCheckRules");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showQushuForm(Map<String, Object> customParams) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BDTAXR_RULE_SET, (boolean)false, (int)0);
        parameter.setStatus(OperationStatus.EDIT);
        if (EmptyCheckUtils.isNotEmpty(customParams)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(customParams.size());
            qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            parameter.getListFilterParameter().setQFilters(qFilterList);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectQushu");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        DynamicObjectCollection checkEntry;
        if ("selectQushu".equals(event.getActionId())) {
            ListSelectedRowCollection list = (ListSelectedRowCollection)event.getReturnData();
            if (list != null && list.size() > 0) {
                ListSelectedRow row = list.get(0);
                String id = row.getPrimaryKeyValue().toString();
                this.getModel().setValue(RULE_ID, (Object)id);
                QFilter q1 = new QFilter("id", "=", (Object)Long.parseLong(id));
                QFilter[] filters = new QFilter[]{q1};
                DynamicObject d = QueryServiceHelper.queryOne((String)BDTAXR_RULE_SET, (String)"id,name", (QFilter[])filters);
                if (null != d) {
                    String name = d.get("name").toString();
                    this.getModel().setValue(RULE_NAME, (Object)name);
                }
            }
        } else if ("selectCheckRules".equals(event.getActionId()) && (checkEntry = (DynamicObjectCollection)event.getReturnData()) != null) {
            this.loadCheckEntry(checkEntry);
        }
    }

    private void loadCheckEntry(DynamicObjectCollection checkEntry) {
        if (checkEntry == null) {
            return;
        }
        this.getModel().deleteEntryData("checkentry");
        DynamicObject entry = null;
        int size = checkEntry.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)checkEntry.get(i);
            int rowIndex = this.getModel().createNewEntryRow("checkentry");
            DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if ("seq".equals(property.getName())) continue;
                this.getModel().setValue(property.getName(), entry.get(property.getName()), rowIndex);
            }
        }
        if (checkEntry != null && checkEntry.size() > 0) {
            String checkRulesDescription = checkEntry.stream().map(v -> v.getString("description")).collect(Collectors.joining(";"));
            this.getModel().setValue(CHECKRULES, (Object)checkRulesDescription);
        } else {
            this.getModel().setValue(CHECKRULES, null);
        }
        this.getView().updateView();
    }

    private void saveDynamicRow(Object type) {
        String dynRowNo;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modeltype = (String)customParams.get(MODELTYPE);
        Long templateId = (Long)customParams.get("templateId");
        DynamicObject dObj = DynamicRowBizBusiness.getDynRowData(templateId, dynRowNo = (String)this.getModel().getValue(DYNROW_NO), modeltype);
        if (dObj == null) {
            dObj = BusinessDataServiceHelper.newDynamicObject((String)DYNROWSET_ENTITY_NAME);
            dObj.set("template_id", (Object)templateId);
            dObj.set(DYNROW_NO, (Object)dynRowNo);
            dObj.set("createtime", (Object)new Date());
            dObj.set("creator", (Object)RequestContext.get().getUserId());
        } else {
            dObj = BusinessDataServiceHelper.loadSingle((Object)dObj.get("id"), (String)DYNROWSET_ENTITY_NAME);
        }
        dObj.set(RULE_ID, this.getModel().getValue(RULE_ID));
        dObj.set(RULE_NAME, this.getModel().getValue(RULE_NAME));
        dObj.set(TYPE, this.getModel().getValue(TYPE));
        dObj.set(PLUGIN_PATH, this.getModel().getValue(PLUGIN_PATH));
        dObj.set(START_ROW, this.getModel().getValue(START_ROW));
        dObj.set("modifytime", (Object)new Date());
        dObj.set("modifier", (Object)RequestContext.get().getUserId());
        dObj.set("enable", (Object)"1");
        dObj.set(SEQ_NO, this.getModel().getValue(SEQ_NO));
        dObj.set(GROUP_NO, this.getModel().getValue(GROUP_NO));
        dObj.set(DISABLE_FRONTOP, this.getModel().getValue(DISABLE_FRONTOP));
        dObj.set(MODELTYPE, this.getModel().getValue(MODELTYPE));
        dObj.set(FILTER, this.getModel().getValue(FILTER));
        dObj.set(DYNHEADER, this.getModel().getValue(DYNHEADER));
        dObj.set(IDENTITYCOLUMN, this.getModel().getValue(IDENTITYCOLUMN));
        dObj.set("checkentry", (Object)this.getModel().getDataEntity(true).getDynamicObjectCollection("checkentry"));
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TemplateDynRowPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        this.getView().close();
    }
}

