/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.SpreadDataModel;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class TemplatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORMULA_CACHE = "formulaCache";
    private static final String FORMULA_CACHE_CAL = "formulaCacheCal";
    private static final String FORMULA_CACHE_VAL = "formulaCacheVal";
    private static final String FORMULA_CACHE_CELL = "formulaCacheCell";
    private static final String DYNAMIC_ROW_CACHE = "dynamicRowCache";
    private static final String BDTAXR_FORMULAPICKER = "bdtaxr_formulapicker";
    private static final String BDTAXR_FORMULA_CELLTYPE = "bdtaxr_formula_celltype";
    private static final String BDTAXR_FORMULA_EDIT = "bdtaxr_formula_edit";
    private static final String BTN_CELLTYPE_FORMULA = "celltype_formula";
    private static final String CALLBACK_SELECT_FORMULA = "selectFormula";
    private static final String CALLBACK_DYN_ROW = "dynamicRow";
    private static Log LOGGER = LogFactory.getLog(TemplatePlugin.class);
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    private static final String SPREAD_NAME = "spreadap";
    private static final String TEMPLATE_ENTITY_NAME = "bdtaxr_template";
    private static final String TEMPLATE_MAIN_ENTITY_NAME = "bdtaxr_template_main";
    private static final String BUTTON_SETTING = "btn_setting";
    private static final String BUTTON_SAVE = "btn_save";
    private static final String BUTTON_VIEW = "btn_view";
    private static final String ACTIONID_SETTIING = "ACTIONID_SETTIING";
    private static final String SETTIING_FORM_ID = "bdtaxr_entity_select";
    private static final String BUTTON_SETFORMULA = "btn_setformula";
    private static final String BUTTON_FORMULA = "btn_formula";
    private static final String BUTTON_TMP_RELATION = "btn_tmp_relation";
    private static final String BUTTON_DELETE_FORMULA = "btn_delete_formula";
    private static final String DELETE_CALCULATE_FORMULA = "del_calculate_formula";
    private static final String DELETE_VALIDATE_FORMULA = "del_validate_formula";
    private static final String DELETE_CELLTYPE_FORMULA = "del_celltype_formula";
    private static final String BUTTON_FLOAT_SETTING = "btn_floatsetting";
    private static final String BUTTON_DYNROW = "btn_dynrow";
    private static final String BTN_TYPE = "btn_type";
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_DEBUG = "btn_debug";
    private static final String DOWN_JSON = "down_json";
    private static final String ORIGINAL_NUMBER = "originalNumber";
    private static final String ORIGINAL_ID = "originalId";
    private static final String FORMULA_ENTITY_NAME = "tpo_formula_temp_edit";
    private static final String TAXTYPE = "taxtype";
    private static final String TEMPLATENUM = "templatenum";
    private static final String TEMPLATEID = "templateid";
    private static final String FORMULAKEY = "formulakey";
    private static final String TABLE = "table";
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final String FORMULA = "formula";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CELLTYPE = "celltype";
    private static final String FORMULANAME = "formulaname";
    private static final String FORMULATYPE = "formulatype";
    private static final String DESCRIBE = "describe";
    private static final String BDTAXR_TEMPLATE_TYPE = "bdtaxr_template_type";
    private static final String ACTION_VIEW = "actionView";
    private static final String TCTB_TEMPLATE_FORMULA = "bdtaxr_template_formula";
    private static final String ACTION_DOWN_JSON = "actionDownJson";
    private static final String SELECT_CELL_KEY = "selectCellKey";
    private static final String ACTION_SAVE = "actionSave";
    private static final long DEFAULT_ID_VALUE = 0L;
    private static final boolean INTERNATIONAL_TAX_POC_FLAG = true;

    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new SpreadDataModel((AbstractFormPlugin)this, SPREAD_NAME, TEMPLATE_ENTITY_NAME));
        BasedataEdit comboEdit = (BasedataEdit)this.getControl(TAXTYPE);
        comboEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeF7Select(beforeF7SelectEvent));
    }

    private SpreadDataModel getSpreadDataModel() {
        return (SpreadDataModel)this.getView().getService(ISpreadAction.class);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getSpreadDataModel().init();
    }

    public void afterBindData(EventObject e) {
        String json = (String)this.getModel().getValue("content_tag");
        json = TemplateShowUtils.replaceJson((String)this.getTemplateType(), (String)json, (IPageCache)this.getPageCache(), (boolean)true);
        this.getSpreadDataModel().setSpreadJson(json);
    }

    public void afterCopyData(EventObject e) {
        String json = (String)this.getModel().getValue("content_tag");
        json = TemplateShowUtils.replaceJson((String)this.getTemplateType(), (String)json, (IPageCache)this.getPageCache(), (boolean)true);
        this.getSpreadDataModel().setSpreadJson(json);
    }

    public void itemClick(ItemClickEvent evt) {
        this.invokeOperationByKey(evt.getItemKey());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void invokeOperationByKey(String key) {
        block52: {
            paramMap /* !! */  = new HashMap<K, V>(16);
            id = this.getModel().getValue("id");
            showParameter = new FormShowParameter();
            formId = "";
            if (!StringUtils.isNotBlank((CharSequence)key)) break block52;
            var6_6 = key;
            var7_7 = -1;
            switch (var6_6.hashCode()) {
                case 2108396928: {
                    if (!var6_6.equals("btn_save")) break;
                    var7_7 = 0;
                    break;
                }
                case 1764366189: {
                    if (!var6_6.equals("btn_setting")) break;
                    var7_7 = 1;
                    break;
                }
                case 2108493480: {
                    if (!var6_6.equals("btn_view")) break;
                    var7_7 = 2;
                    break;
                }
                case -898999677: {
                    if (!var6_6.equals("btn_formula")) break;
                    var7_7 = 3;
                    break;
                }
                case 1058982023: {
                    if (!var6_6.equals("btn_setformula")) break;
                    var7_7 = 4;
                    break;
                }
                case 1200149799: {
                    if (!var6_6.equals("btn_tmp_relation")) break;
                    var7_7 = 5;
                    break;
                }
                case 934884291: {
                    if (!var6_6.equals("celltype_formula")) break;
                    var7_7 = 6;
                    break;
                }
                case 2108449597: {
                    if (!var6_6.equals("btn_type")) break;
                    var7_7 = 7;
                    break;
                }
                case 2107963557: {
                    if (!var6_6.equals("btn_down")) break;
                    var7_7 = 8;
                    break;
                }
                case 1300567653: {
                    if (!var6_6.equals("down_json")) break;
                    var7_7 = 9;
                    break;
                }
                case 802870873: {
                    if (!var6_6.equals("del_calculate_formula")) break;
                    var7_7 = 10;
                    break;
                }
                case -1623871247: {
                    if (!var6_6.equals("del_validate_formula")) break;
                    var7_7 = 11;
                    break;
                }
                case -1279374985: {
                    if (!var6_6.equals("del_celltype_formula")) break;
                    var7_7 = 12;
                    break;
                }
                case 614460791: {
                    if (!var6_6.equals("btn_floatsetting")) break;
                    var7_7 = 13;
                    break;
                }
                case -1462610940: {
                    if (!var6_6.equals("btn_dynrow")) break;
                    var7_7 = 14;
                    break;
                }
                case 922043056: {
                    if (!var6_6.equals("btn_debug")) break;
                    var7_7 = 15;
                }
            }
            switch (var7_7) {
                case 0: {
                    this.save();
                    break;
                }
                case 1: {
                    this.checkCellFormulaIsSelected();
                    this.settingClick();
                    break;
                }
                case 2: {
                    this.spreadOption("actionView");
                    break;
                }
                case 3: {
                    showParameter.setFormId("bdtaxr_template_formula");
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 4: {
                    if (this.checkTemplate(this.getModel(), this.getView())) {
                        return;
                    }
                    formId = "bdtaxr_formula_edit";
                    paramMap /* !! */  = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                    param = new HashMap<String, Object>();
                    param.putAll(paramMap /* !! */ );
                    param.put("country", ((DynamicObject)this.getModel().getValue("country")).getLong("id"));
                    param.put("orgId", ((DynamicObject)this.getModel().getValue("org")).getLong("id"));
                    this.showFormulaList(param, formId);
                    break;
                }
                case 5: {
                    showParameter.setFormId("bdtaxr_tmp_relation");
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    templateNum = (String)this.getModel().getValue("number");
                    templateId = String.valueOf(this.getModel().getValue("id"));
                    map = new HashMap<String, String>();
                    map.put("templateid", templateId);
                    map.put("templatenum", templateNum);
                    showParameter.setCustomParams(map);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 6: {
                    formId = "bdtaxr_formula_celltype";
                    paramMap /* !! */  = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                    para = new HashMap<String, Object>();
                    para.putAll(paramMap /* !! */ );
                    this.showFormulaList(para, formId);
                    break;
                }
                case 7: {
                    showParameter = new ListShowParameter();
                    ((ListShowParameter)showParameter).setBillFormId("bdtaxr_template_type");
                    showParameter.setFormId("bos_list");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_template_type");
                    showParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 8: {
                    if (this.checkTemplateIsSave(id, this.getView())) {
                        return;
                    }
                    try {
                        in = TemplateShowUtils.getbuildExcel((String)"origin", (Long)((Long)id));
                        var15_17 = null;
                        name = (String)this.getModel().getValue("name");
                        urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", in, 5000);
                        this.getView().openUrl(urls);
                        if (in == null) break;
                        if (var15_17 == null) ** GOTO lbl150
                        try {
                            in.close();
                        }
                        catch (Throwable var18_21) {
                            var15_17.addSuppressed(var18_21);
                        }
                        break;
lbl150:
                        // 1 sources

                        in.close();
                        ** break;
                        catch (Throwable var16_19) {
                            try {
                                var15_17 = var16_19;
                                throw var16_19;
                            }
                            catch (Throwable var19_22) {
                                if (in != null) {
                                    if (var15_17 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var20_23) {
                                            var15_17.addSuppressed(var20_23);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var19_22;
lbl167:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                    }
                }
                case 9: {
                    if (this.checkTemplateIsSave(id, this.getView())) {
                        return;
                    }
                    this.spreadOption("actionDownJson");
                    break;
                }
                case 10: {
                    this.deleteFormulaByKeyAndType("1", String.valueOf(id), key);
                    break;
                }
                case 11: {
                    this.deleteFormulaByKeyAndType("2", String.valueOf(id), key);
                    break;
                }
                case 12: {
                    this.deleteFormulaByKeyAndType("3", String.valueOf(id), key);
                    break;
                }
                case 13: {
                    customParams = new HashMap<String, Object>(16);
                    customParams.put("basetemplateid", id);
                    customParams.put("templateType", ((DynamicObject)this.getModel().getValue("type")).getString("id"));
                    PageShowCommon.showBillList((ShowType)ShowType.Modal, (String)"tpo_template_floatset", (IFormView)this.getView(), customParams);
                    break;
                }
                case 14: {
                    this.checkCellFormulaIsSelected();
                    this.dynamicRowSetting();
                    break;
                }
                case 15: {
                    break;
                }
            }
        }
    }

    private String convertLocalName(OrmLocaleValue ormLocaleValue) {
        if (null != ormLocaleValue) {
            return ormLocaleValue.getLocaleValue();
        }
        return "";
    }

    private boolean checkTemplateIsSave(Object id, IFormView view) {
        if (id == null || (Long)id == 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"TemplatePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkParamMap(Map<String, String> paramMap, IFormView view, String operationKey) {
        if (StringUtils.isEmpty((CharSequence)paramMap.get(SELECT_CELL_KEY)) || paramMap.isEmpty()) {
            if (BUTTON_DELETE_FORMULA.equals(operationKey) || operationKey.startsWith("del")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u516c\u5f0f\u6807\u8bc6\uff0c\u4e0d\u80fd\u5220\u9664,\u8bf7\u5230\u7533\u62a5\u516c\u5f0f\u5217\u8868\u754c\u9762\u8fdb\u884c\u5220\u9664", (String)"TemplatePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            if (BUTTON_SETFORMULA.equals(operationKey)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u516c\u5f0f\u6807\u8bc6\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"TemplatePlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    private void deleteFormulaByKeyAndType(String formulaType, String templateId, String key) {
        this.checkCellFormulaIsSelected();
        try {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
            if (this.checkParamMap(paramMap, this.getView(), key)) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("serialization error:" + ThrowableHelper.toString((Exception)e));
        }
    }

    private void save() {
        if (this.checkTemplate(this.getModel(), this.getView())) {
            return;
        }
        this.spreadOption(ACTION_SAVE);
    }

    private boolean checkTemplate(IDataModel dataModel, IFormView view) {
        QFilter qfilter2;
        DynamicObject countryObject = (DynamicObject)dataModel.getValue("country");
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        DynamicObject taxtype = (DynamicObject)dataModel.getValue(TAXTYPE);
        DynamicObject group = (DynamicObject)dataModel.getValue("group");
        String name = this.convertLocalName((OrmLocaleValue)dataModel.getValue("name"));
        String number = (String)dataModel.getValue("number");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)dataModel.getValue("startdate")));
        Date enddate = DateUtils.getLastDateOfMonth((Date)((Date)dataModel.getValue("enddate")));
        if (countryObject == null || StringUtils.isEmpty((CharSequence)countryObject.getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6\u6216\u5730\u533a", (String)"TemplatePlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (org == null || StringUtils.isEmpty((CharSequence)org.getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"TemplatePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (taxtype == null || StringUtils.isEmpty((CharSequence)taxtype.getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7a0e\u79cd", (String)"TemplatePlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7f16\u7801", (String)"TemplatePlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0", (String)"TemplatePlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (startdate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u751f\u6548\u65e5\u671f", (String)"TemplatePlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (enddate != null && startdate.compareTo(enddate) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6a21\u677f\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f", (String)"TemplatePlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        if (group == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u7248\u5206\u7c7b", (String)"TemplatePlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return true;
        }
        Object idObj = this.getModel().getValue("id");
        QFilter qfilter = new QFilter("country", "=", (Object)countryObject.getLong("id"));
        QFilter qfilterOrg = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter qfilterTaxType = new QFilter(TAXTYPE, "=", (Object)taxtype.getLong("id"));
        qfilter = qfilter.and(qfilterOrg).and(qfilterTaxType);
        if (idObj != null) {
            qfilter = qfilter.and(new QFilter("id", "!=", idObj));
        }
        if (enddate == null) {
            qfilter2 = QFilter.isNull((String)"enddate");
            qfilter2 = qfilter2.or(new QFilter("startdate", ">=", (Object)startdate));
            qfilter = qfilter.and(qfilter2);
        } else {
            qfilter2 = new QFilter("startdate", "<=", (Object)enddate);
            qfilter2.and(new QFilter("enddate", ">=", (Object)enddate));
            qfilter2 = qfilter2.and(QFilter.isNotNull((String)"enddate"));
            QFilter qfilter3 = new QFilter("startdate", "<=", (Object)startdate);
            qfilter3.and(new QFilter("enddate", ">=", (Object)startdate));
            qfilter3 = qfilter3.and(QFilter.isNotNull((String)"enddate"));
            QFilter qfilter4 = new QFilter("startdate", "<=", (Object)enddate);
            qfilter4 = qfilter4.and(QFilter.isNull((String)"enddate"));
            QFilter q = qfilter2.or(qfilter3).or(qfilter4);
            qfilter.and(q);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TEMPLATE_ENTITY_NAME, (String)"id,name,number", (QFilter[])new QFilter[]{qfilter});
        if (collection != null && !collection.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(0);
            String tmpName = dynamicObject.getString("number") + dynamicObject.getString("name");
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u56fd\u5bb6\u548c\u7a0e\u79cd\u4e0b\u5df2\u5b58\u5728\u751f\u6548\u7684\u6a21\u677f\uff1a%s", (String)"TemplatePlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), tmpName));
            return true;
        }
        return false;
    }

    private void spreadOption(String method) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("callback", "invokeAction");
        params.put("invokemethod", method);
        this.getPageCache().put("starttime", System.currentTimeMillis() + "");
        this.getSpreadDataModel().getSpreadJson(params);
    }

    public void doubleClickLockedCell(int r, int c) {
    }

    private void settingClick() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SETTIING_FORM_ID);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityid = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"entityid", String.class);
        String entityName = (String)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"entityname", String.class);
        showParameter.setCustomParam("entityid", (Object)entityid);
        showParameter.setCustomParam("entityname", (Object)entityName);
        String type = this.getTemplateType();
        showParameter.setCustomParam("templateType", (Object)type);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTIONID_SETTIING);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data != null && ACTIONID_SETTIING.equals(event.getActionId())) {
            if (Map.class.isAssignableFrom(data.getClass())) {
                Map returnData = (Map)data;
                List selCols = this.getSpreadDataModel().getSelCols();
                List selRows = this.getSpreadDataModel().getSelRows();
                if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                Boolean rowfill = (Boolean)returnData.get("rowfill");
                Boolean columnfill = (Boolean)returnData.get("columnfill");
                List column = (List)returnData.get(COLUMN);
                List row = (List)returnData.get(ROW);
                String entityid = (String)returnData.get("entityid");
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"entityid", (Object)entityid);
                String entityname = (String)returnData.get("entityname");
                TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"entityname", (Object)entityname);
                ArrayList updateCells = new ArrayList();
                int rowId = (Integer)selRows.get(0);
                for (Map rowMap : row) {
                    int colId = (Integer)selCols.get(0);
                    String rowValueId = (String)rowMap.get("id");
                    if ("ROOT".equals(rowValueId)) continue;
                    for (Map colMap : column) {
                        String colValueId = (String)rowMap.get("id");
                        if ("ROOT".equals(colValueId)) continue;
                        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                        valMap.put("r", rowId);
                        valMap.put("c", colId);
                        String valText = entityname + "#" + (String)colMap.get("text") + "#" + (String)rowMap.get("text");
                        if (rowValueId.startsWith(entityid)) {
                            valText = (String)rowMap.get("id") + "#" + (String)colMap.get("id");
                        }
                        valMap.put("v", "${" + valText + "}");
                        valMap.put("rc", 1);
                        valMap.put("cc", 1);
                        updateCells.add(valMap);
                        if (!columnfill.booleanValue()) break;
                        ++colId;
                    }
                    if (!rowfill.booleanValue()) break;
                    ++rowId;
                }
                HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(4);
                HashMap<String, String> styleMap = new HashMap<String, String>(4);
                styleMap.put("bkc", "#d4ffaa");
                features.put("range", updateCells);
                features.put("style", styleMap);
                this.getSpreadDataModel().updataValue(updateCells);
                this.getSpreadDataModel().setCellStyle((List)Lists.newArrayList((Object[])new Map[]{features}));
            }
        } else if (BDTAXR_TEMPLATE_TYPE.equals(event.getActionId())) {
            this.getView().updateView();
        } else if (CALLBACK_SELECT_FORMULA.equals(event.getActionId()) && data != null) {
            Map returnData = (Map)data;
            this.handleCallBackFormula(returnData);
        }
    }

    private void dynamicRowSetting() {
        String cellJson = this.getSpreadDataModel().getSelectedCellKey();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(DYNROWSET_ENTITY_NAME);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        Map param = (Map)JsonUtil.fromJson((String)cellJson, Map.class);
        parameter.setCustomParams(param);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_DYN_ROW);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void actionView(String spreadJson) {
        String json = SpreadUtils.getJson((String)spreadJson);
        String pageId = MD5.md5crypt((String)this.getView().getPageId());
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("operation", "edit");
        String templateHtml = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"extractTemplateJson", (Object[])new Object[]{json, null, null, pageId, customParams});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tpo_templat_view");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("json", (Object)templateHtml);
        this.getView().showForm(showParameter);
    }

    public void actionSave(String spreadJson) {
        List formulaCache;
        String json = SpreadUtils.getJson((String)spreadJson);
        IDataModel model = this.getModel();
        Long idObj = (Long)model.getValue("id");
        DynamicObject dObj = null;
        Map allCache = this.getPageCache().getAll();
        HashMap map = new HashMap();
        HashMap<String, FormulaVo> calMap = new HashMap<String, FormulaVo>();
        HashMap<String, FormulaVo> validateMap = new HashMap<String, FormulaVo>();
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        if (idObj != null && idObj > 0L) {
            dObj = BusinessDataServiceHelper.loadSingle((Object)idObj, (String)TEMPLATE_ENTITY_NAME);
            String formula = dObj.getString("formula_tag");
            if (StringUtils.isNotBlank((CharSequence)formula)) {
                Map remainMap = JsonUtils.strToMapFormula((String)formula);
                calMap = EmptyCheckUtils.isEmpty(remainMap.get("calculate")) ? new HashMap() : (Map)remainMap.get("calculate");
                validateMap = EmptyCheckUtils.isEmpty(remainMap.get("validate")) ? new HashMap() : (Map)remainMap.get("validate");
                cellTypeMap = EmptyCheckUtils.isEmpty(remainMap.get("cellType")) ? new HashMap() : (Map)remainMap.get("cellType");
            }
        } else {
            dObj = BusinessDataServiceHelper.newDynamicObject((String)TEMPLATE_ENTITY_NAME);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)allCache) && EmptyCheckUtils.isNotEmpty(formulaCache = allCache.entrySet().stream().filter(v -> ((String)v.getKey()).startsWith(FORMULA_CACHE)).map(k -> (FormulaVo)JsonUtil.fromJson((String)((String)k.getValue()), FormulaVo.class)).collect(Collectors.toList()))) {
            for (FormulaVo v2 : formulaCache) {
                if ("1".equals(v2.getFormulaType())) {
                    calMap.put(v2.getFormulaKey(), v2);
                }
                if ("2".equals(v2.getFormulaType())) {
                    validateMap.put(v2.getFormulaKey(), v2);
                }
                if (!"3".equals(v2.getFormulaType())) continue;
                cellTypeMap.put(v2.getFormulaKey(), v2);
            }
        }
        map.put("validate", validateMap);
        map.put("calculate", calMap);
        map.put("cellType", cellTypeMap);
        String name = this.convertLocalName((OrmLocaleValue)model.getValue("name"));
        String number = (String)model.getValue("number");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)model.getValue("startdate")));
        LOGGER.info(DateUtils.format((Date)((Date)model.getValue("enddate")), (String)"yyyy-MM-dd HH:mm:ss"));
        Date enddate = DateUtils.getLastDateOfMonth((Date)((Date)model.getValue("enddate")));
        String enable = (String)model.getValue("enable");
        String status = (String)model.getValue("status");
        if (EmptyCheckUtils.isEmpty((Object)enable)) {
            enable = "1";
        }
        if (EmptyCheckUtils.isEmpty((Object)status)) {
            status = "A";
        }
        if (enddate != null) {
            enddate = DateUtils.trunc((Date)enddate);
        }
        LOGGER.info(DateUtils.format((Date)enddate, (String)"yyyy-MM-dd HH:mm:ss"));
        dObj.set("country", this.getModel().getValue("country"));
        dObj.set("org", this.getModel().getValue("org"));
        long orgid = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)orgid).getData();
        dObj.set("taxno", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
        dObj.set(TAXTYPE, this.getModel().getValue(TAXTYPE));
        dObj.set("number", (Object)number);
        dObj.set("name", (Object)name);
        dObj.set("startdate", (Object)startdate);
        dObj.set("enddate", (Object)enddate);
        dObj.set("modifytime", (Object)new Date());
        dObj.set("group", this.getModel().getValue("group"));
        dObj.set("html_tag", (Object)"{}");
        dObj.set("createtime", (Object)new Date());
        dObj.set("creator", (Object)RequestContext.get().getUserId());
        dObj.set("modifier", (Object)RequestContext.get().getUserId());
        dObj.set("enable", (Object)enable);
        dObj.set("status", (Object)status);
        dObj.set("issystem", (Object)"0");
        json = TemplateShowUtils.replaceJson((String)((DynamicObject)this.getModel().getValue("country")).getString("id"), (String)json, (IPageCache)this.getPageCache(), (boolean)false);
        dObj.set("content_tag", (Object)json);
        dObj.set("formula_tag", (Object)JsonUtil.toJson(map));
        Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
        if (EmptyCheckUtils.isNotEmpty((Object)ids)) {
            allCache.entrySet().removeIf(v -> ((String)v.getKey()).startsWith(FORMULA_CACHE));
            for (Object obj : ids) {
                DynamicObject idObj1 = (DynamicObject)obj;
                model.setValue("id", idObj1.getPkValue());
                model.setValue("formula_tag", (Object)JsonUtil.toJson(map));
            }
        }
        Object pkValue = ((DynamicObject)ids[0]).getPkValue();
        DeleteServiceHelper.delete((String)TEMPLATE_MAIN_ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        DynamicObject templateMainObject = BusinessDataServiceHelper.newDynamicObject((String)TEMPLATE_MAIN_ENTITY_NAME);
        templateMainObject.set("id", pkValue);
        templateMainObject.set("type", (Object)"");
        templateMainObject.set("number", dObj.get("number"));
        templateMainObject.set("name", ((ILocaleString)dObj.get("name")).getDefaultItem());
        templateMainObject.set("startdate", dObj.get("startdate"));
        templateMainObject.set("enddate", dObj.get("enddate"));
        templateMainObject.set("html_tag", dObj.get("html_tag"));
        templateMainObject.set("updatetime", dObj.get("modifytime"));
        templateMainObject.set("content_tag", dObj.get("content_tag"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{templateMainObject});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TemplatePlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getModel().setDataChanged(false);
        this.getView().sendFormAction(this.getView());
    }

    public void actionDownJson(String spreadJson) {
        String json = SpreadUtils.getJson((String)spreadJson);
        json = TemplateShowUtils.replaceJson((String)this.getTemplateType(), (String)json, (IPageCache)this.getPageCache(), (boolean)false);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        String name = this.getModel().getValue("number") + this.convertLocalName((OrmLocaleValue)this.getModel().getValue("name"));
        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".json", (InputStream)in, 5000);
        this.getView().openUrl(urls);
    }

    public String getTemplateType() {
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("country");
        if (typeObject != null) {
            return typeObject.getString("id");
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        Control base = (Control)event.getSource();
        if (TAXTYPE.equals(base.getKey())) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("country");
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().getQFilters().add(statusFilter);
            if (null != dynamicObject) {
                QFilter countryFliter = new QFilter("taxationsysid.countryid", "=", (Object)dynamicObject.getLong("id"));
                formShowParameter.getListFilterParameter().getQFilters().add(countryFliter);
            }
        }
    }

    private void checkCellFormulaIsSelected() {
        List selCols = this.getSpreadDataModel().getSelCols();
        List selRows = this.getSpreadDataModel().getSelRows();
        Object type = this.getModel().getValue("type");
        if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
    }

    private String getSpreadSelectedCellKey() {
        return this.getSpreadDataModel().getSelectedCellKey();
    }

    private Map<String, Object> getCopyTemplateNumAndId() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object originalId = null;
        FormShowParameter object = this.getView().getFormShowParameter();
        if (object instanceof BillShowParameter) {
            BillShowParameter showParameter = (BillShowParameter)object;
            OperationStatus status = showParameter.getStatus();
            Object pkId = showParameter.getPkId();
            if (OperationStatus.ADDNEW == status && StringUtils.isNotBlank((Object)pkId)) {
                originalId = pkId;
            }
        }
        paramMap.put(ORIGINAL_ID, originalId);
        return paramMap;
    }

    private DynamicObject[] copyFormula(DynamicObject[] dynamicObjects, IDataModel model) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)FORMULA_ENTITY_NAME);
                object.set(TAXTYPE, (Object)((DynamicObject)model.getValue("type")).getString("id"));
                object.set(TEMPLATENUM, model.getValue("number"));
                object.set(TEMPLATEID, model.getValue("id"));
                object.set(FORMULAKEY, (Object)dyo.getString(FORMULAKEY));
                object.set(TABLE, (Object)dyo.getString(TABLE));
                object.set(ROW, (Object)dyo.getString(ROW));
                object.set(COLUMN, (Object)dyo.getString(COLUMN));
                object.set(FORMULA, (Object)dyo.getString(FORMULA));
                object.set(TITLE, (Object)dyo.getString(TITLE));
                object.set(CONTENT, (Object)dyo.getString(CONTENT));
                object.set(CELLTYPE, (Object)dyo.getString(CELLTYPE));
                object.set("name", (Object)dyo.getString("name"));
                object.set(FORMULANAME, (Object)dyo.getString(FORMULANAME));
                object.set(FORMULATYPE, (Object)dyo.getString(FORMULATYPE));
                object.set(DESCRIBE, (Object)dyo.getString(DESCRIBE));
                object.set("updatetime", (Object)new Date());
                list.add(object);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    public void showFormulaPanel(int row, int col) {
    }

    private void showFormulaList(Map<String, Object> param, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setStatus(OperationStatus.EDIT);
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("group");
        String taxType = "";
        if (typeObject != null) {
            taxType = typeObject.getString("id");
        }
        String templateNumber = (String)this.getModel().getValue("number");
        String formulaKey = (String)param.get(SELECT_CELL_KEY);
        String templateId = String.valueOf(this.getModel().getValue("id"));
        List formulaVoList = QueryFormulaService.queryDBFormulaByFormulaKey((String)"1", (String)formulaKey, (String)templateId);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        if (null != formulaVoList && !formulaVoList.isEmpty()) {
            FormulaVo vo = (FormulaVo)formulaVoList.get(0);
            customParams.put(FORMULAKEY, formulaKey);
            customParams.put(FORMULATYPE, vo.getFormulaType());
            customParams.put(FORMULANAME, vo.getFormulaName());
            customParams.put(FORMULA, vo.getFormula());
            customParams.put(CONTENT, vo.getContent());
            customParams.put(CELLTYPE, vo.getCellType());
            customParams.put(TITLE, vo.getTitle());
            customParams.put("name", vo.getName());
            customParams.put(DESCRIBE, vo.getDescribe());
        } else {
            customParams.put(FORMULAKEY, formulaKey);
            customParams.put(FORMULATYPE, "1");
            customParams.put("name", param.get("selectCellName"));
        }
        customParams.put(TAXTYPE, taxType);
        customParams.put(TEMPLATENUM, templateNumber);
        customParams.put(TEMPLATEID, templateId);
        customParams.put("from", "templateForm");
        customParams.put("orgId", param.get("orgId"));
        customParams.put("country", param.get("country"));
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_FORMULA);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void handleCallBackFormula(Map<String, Object> returndata) {
        List selCols = this.getSpreadDataModel().getSelCols();
        List selRows = this.getSpreadDataModel().getSelRows();
        if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> data = returndata;
        if (EmptyCheckUtils.isNotEmpty(data)) {
            data.entrySet().forEach(v -> {
                FormulaVo vo;
                Object value = v.getValue();
                String key = (String)v.getKey();
                if (null != value && StringUtils.isNotBlank((CharSequence)(vo = (FormulaVo)value).getFormulaKey())) {
                    if (!vo.getFormulaKey().contains("#")) {
                        int rowId = (Integer)selRows.get(0);
                        int colId = (Integer)selCols.get(0);
                        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                        valMap.put("r", rowId);
                        valMap.put("c", colId);
                        valMap.put("f", vo.getFormula());
                        ArrayList<HashMap<String, Object>> updateCells = new ArrayList<HashMap<String, Object>>();
                        updateCells.add(valMap);
                        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                        paramMap.put("cell", updateCells);
                        paramMap.put("si", "");
                        this.getSpreadDataModel().setFormula(paramMap);
                    } else {
                        if ("calculate".equals(key)) {
                            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)(FORMULA_CACHE_CAL + vo.getFormulaKey()), (Object)vo);
                        }
                        if ("validate".equals(key)) {
                            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)(FORMULA_CACHE_VAL + vo.getFormulaKey()), (Object)vo);
                        }
                        if ("cellType".equals(key)) {
                            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)(FORMULA_CACHE_CELL + vo.getFormulaKey()), (Object)vo);
                        }
                    }
                }
            });
        }
    }
}

