/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PayRecordDeferUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_UPDATE_DATA = "select fid,fhjsqid,foperatetime,foperator from t_bdtaxr_pay_record where fhjsqid != 0 and foperatetime is null;";
    private static final String UPDATE_PAY_RECORD = "update t_bdtaxr_pay_record set foperatetime = ?,foperator = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(PayRecordDeferUpgradePlugin.class);
    private static final String PAY_RECOORD_ENTITY = "bdtaxr_pay_record";
    private static final String DEFERPAY_APPLY_ENTITY = "bdtaxr_deferpay_apply";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "PayRecordDeferUpgradePlugin UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("PayRecordDeferUpgradePlugin UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List updatePayList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)updatePayList)) {
            return;
        }
        List hjsqids = updatePayList.stream().map(u -> Long.parseLong(u.get("FHJSQID").toString())).collect(Collectors.toList());
        DynamicObject[] hjList = BusinessDataServiceHelper.load((Object[])hjsqids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DEFERPAY_APPLY_ENTITY));
        Map<Long, Object> hjmap = Arrays.asList(hjList).stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.reducing(null, (m, n) -> n)));
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updatePayList.size());
        for (Map payMap : updatePayList) {
            DynamicObject operator;
            DynamicObject hjObj = hjmap.get(payMap.get("FHJSQID"));
            if (hjObj == null || (operator = hjObj.getDynamicObject("operator")) == null) continue;
            paramsList.add(new Object[]{hjObj.getDate("operatetime"), operator.get("id"), payMap.get("FID")});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }
}

