/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class PayRecordDetailUpgradeService
extends AbstractUpgradeFormPlugin {
    private static List<String> singleItem = Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "fjsf", "qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb", "yhs", "fcs", "cztdsys", "fcscztdsys", "fcsprice", "fcshire", "tvpt", "tcvvt", "tcept", "yys", "tcrt", "zzsyjskb");
    private static final String QUERY_UPDATE_DATA = "select fid,fssbbid,fnsrtype,ftaxtype,fyjje,fpaystatus,fskssqq,fskssqz from t_bdtaxr_pay_record where fid not in (select fid from t_bdtaxr_pay_detail)";
    private static final String UPDATE_PAY_RECORD = "insert into t_bdtaxr_pay_detail (fid,fentryid,fseq,ftaxitem,fyjjemx,fsjjemx,fsyqjjemx,fdelaypay) values(?,?,?,?,?,?,?,?);";
    private static final Log LOGGER = LogFactory.getLog(PayRecordDetailUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7f34\u6b3e\u660e\u7ec6\u5386\u53f2\u6570\u636e\u5f00\u59cb\u5347\u7ea7", (String)"PayRecordDetailUpgradeService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        List payList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)payList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(payList.size());
        for (Map payMap : payList) {
            QFilter taxtypeFilter;
            boolean exists;
            MultiLangEnumBridge multiLangEnumBridge;
            BigDecimal yjjemx;
            String taxitem;
            Long detailEntryId;
            long id = Long.parseLong(String.valueOf(payMap.get("FID")));
            Object fssbbid = payMap.get("FSSBBID");
            Object fnsrtype = payMap.get("FNSRTYPE");
            Object ftaxtype = payMap.get("FTAXTYPE");
            Object fpaystatus = payMap.get("FPAYSTATUS");
            if (StringUtils.isEmpty(fssbbid) || StringUtils.isEmpty(fnsrtype) || StringUtils.isEmpty(ftaxtype) || StringUtils.isEmpty(fpaystatus)) continue;
            Long sbbid = Long.parseLong(String.valueOf(fssbbid));
            String nsrtype = String.valueOf(fnsrtype);
            String taxtype = String.valueOf(ftaxtype);
            String paystatus = String.valueOf(fpaystatus);
            BigDecimal yjje = BigDecimalUtil.toBigDecimal(payMap.get("FYJJE"));
            Long detailId = id;
            BigDecimal sjjemx = BigDecimal.ZERO;
            BigDecimal syqjjemx = BigDecimal.ZERO;
            BigDecimal delaypay = BigDecimal.ZERO;
            if (singleItem.contains(nsrtype)) {
                detailEntryId = DBServiceHelper.genGlobalLongId();
                int seq = 0;
                taxitem = taxtype;
                yjjemx = yjje;
                if (paystatus.equals("1")) {
                    sjjemx = yjjemx;
                } else {
                    syqjjemx = yjjemx;
                }
                paramsList.add(new Object[]{detailId, detailEntryId, seq, taxitem, yjjemx, sjjemx, syqjjemx, delaypay});
                continue;
            }
            if ("szys_a".equals(nsrtype)) {
                detailEntryId = DBServiceHelper.genGlobalLongId();
                int seq = 0;
                taxitem = nsrtype;
                yjjemx = yjje;
                if (paystatus.equals("1")) {
                    sjjemx = yjjemx;
                } else {
                    syqjjemx = yjjemx;
                }
                paramsList.add(new Object[]{detailId, detailEntryId, seq, taxitem, yjjemx, sjjemx, syqjjemx, delaypay});
                continue;
            }
            if (!"ccxws".equals(nsrtype)) continue;
            Object fskssqq = payMap.get("FSKSSQQ");
            Object fskssqz = payMap.get("FSKSSQZ");
            if (StringUtils.isEmpty(fskssqq) || StringUtils.isEmpty(fskssqz)) continue;
            String taxname = null;
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid));
            QFilter skssqqFilter = new QFilter("startdate", "=", fskssqq);
            QFilter skssqzFilter = new QFilter("enddate", "=", fskssqz);
            if ("zys".equals(taxtype)) {
                taxtype = "tcrt";
            }
            if ("ccs".equals(taxtype)) {
                taxtype = "tcvvt";
            }
            if ("hbs".equals(taxtype)) {
                taxtype = "tcept";
            }
            if ("szys".equals(taxtype)) {
                taxtype = "tcwat";
            }
            if (null != (multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxtype))) {
                taxname = multiLangEnumBridge.loadKDString();
            }
            if (!(exists = QueryServiceHelper.exists((String)"tcret_ccxws_zb_hb", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter = new QFilter("taxtype", "=", (Object)taxname), skssqqFilter, skssqzFilter}))) continue;
            DynamicObject[] sbb = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"sm,ybse", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter, skssqqFilter, skssqzFilter});
            for (int i = 0; i < sbb.length; ++i) {
                Long detailEntryId2 = DBServiceHelper.genGlobalLongId();
                int seq = i;
                String taxitem2 = sbb[i].getString("sm");
                BigDecimal yjjemx2 = sbb[i].getBigDecimal("ybse");
                if (paystatus.equals("1")) {
                    sjjemx = yjjemx2;
                } else {
                    syqjjemx = yjjemx2;
                }
                paramsList.add(new Object[]{detailId, detailEntryId2, seq, taxitem2, yjjemx2, sjjemx, syqjjemx, delaypay});
            }
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

