/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PayRecordFjsfSplitUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PayRecordFjsfSplitUpgradePlugin.class);
    private static final String PAY_RECOORD_ENTITY = "bdtaxr_pay_record";
    private static final String DEFERPAY_APPLY_ENTITY = "bdtaxr_deferpay_apply";
    private static final String NSRXX_ENTITY = "tcvat_nsrxx";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        DynamicObjectCollection idCollection = QueryServiceHelper.query((String)PAY_RECOORD_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("taxtype", "=", (Object)"fjsf")});
        DynamicObject[] fjsfDatas = BusinessDataServiceHelper.load((Object[])idCollection.stream().map(e -> e.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PAY_RECOORD_ENTITY));
        ArrayList<DynamicObject> payRecordList = new ArrayList<DynamicObject>(fjsfDatas.length * 3);
        ArrayList<DynamicObject> hjsqList = new ArrayList<DynamicObject>(fjsfDatas.length * 3);
        ArrayList<Long> delPayRecordIds = new ArrayList<Long>(fjsfDatas.length);
        ArrayList<Long> delHjsqIds = new ArrayList<Long>(fjsfDatas.length);
        HashMap<String, BigDecimal> tailDiffMap = new HashMap<String, BigDecimal>();
        for (DynamicObject fjsfData : fjsfDatas) {
            String sbbid = fjsfData.getString("sbbid");
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)NSRXX_ENTITY, (String)"org.id as orgId,type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
            if (nsrxx == null) continue;
            delPayRecordIds.add(fjsfData.getLong("id"));
            BigDecimal jkbl = fjsfData.getBigDecimal("jkbl");
            String paystatus = fjsfData.getString("paystatus");
            long hjsqid = fjsfData.getLong("hjsqid");
            DynamicObject hjsqData = null;
            if (hjsqid > 0L) {
                delHjsqIds.add(hjsqid);
                hjsqData = BusinessDataServiceHelper.loadSingle((Object)hjsqid, (String)DEFERPAY_APPLY_ENTITY);
            }
            for (String taxType : TaxTypeUtils.FJSF_SPLIT) {
                BigDecimal yjje;
                DynamicObject data = new DynamicObject(fjsfData.getDynamicObjectType());
                BigDecimal amt = DeclarePayHelper.queryFjsfSubAmt(sbbid, taxType, nsrxx.getString("type"));
                String uniqueKey = sbbid + taxType;
                String orgId = nsrxx.getString("orgId");
                String num = CodeRuleServiceHelper.getNumber((String)PAY_RECOORD_ENTITY, (DynamicObject)data, (String)orgId);
                data.set("billno", (Object)num);
                BigDecimal tailDiffAmt = (BigDecimal)tailDiffMap.get(uniqueKey);
                if (tailDiffAmt == null) {
                    yjje = amt.multiply(jkbl).setScale(2, RoundingMode.HALF_UP);
                    tailDiffMap.put(uniqueKey, yjje);
                } else {
                    yjje = amt.subtract(tailDiffAmt);
                }
                data.set("yjje", (Object)yjje);
                data.set("jkbl", (Object)jkbl);
                data.set("paystatus", (Object)paystatus);
                data.set("deadline", fjsfData.get("deadline"));
                BigDecimal sjje = BigDecimal.ZERO;
                if ("1".equals(paystatus)) {
                    sjje = yjje;
                }
                data.set("sjje", (Object)sjje);
                data.set("syqjje", (Object)yjje.subtract(sjje));
                data.set("payer", fjsfData.get("payer"));
                data.set("paydate", fjsfData.get("paydate"));
                data.set("sbbid", (Object)sbbid);
                if (hjsqData != null) {
                    DynamicObject apply = new DynamicObject(hjsqData.getDynamicObjectType());
                    hjsqid = DBUtils.getLongId((String)DEFERPAY_APPLY_ENTITY);
                    apply.set("id", (Object)hjsqid);
                    if (orgId != null) {
                        String applyno = CodeRuleServiceHelper.getNumber((String)DEFERPAY_APPLY_ENTITY, (DynamicObject)apply, (String)orgId);
                        apply.set("applyno", (Object)applyno);
                    }
                    apply.set("operator", hjsqData.get("operator"));
                    apply.set("operatetime", hjsqData.get("operatetime"));
                    apply.set("sbbid", hjsqData.get("sbbid"));
                    hjsqList.add(apply);
                }
                data.set("hjsqid", (Object)hjsqid);
                data.set("sbbentryid", fjsfData.get("sbbentryid"));
                data.set("taxtype", (Object)taxType);
                payRecordList.add(data);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)PAY_RECOORD_ENTITY), (Object[])delPayRecordIds.toArray());
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)DEFERPAY_APPLY_ENTITY), (Object[])delHjsqIds.toArray());
                if (!hjsqList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])hjsqList.toArray(new DynamicObject[0]));
                }
                if (!payRecordList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])payRecordList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e2) {
                LOGGER.error("taxc-PayRecordFjsfSplitUpgradePlugin upgrade fail:", (Throwable)e2);
                h.markRollback();
            }
        }
    }
}

