/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PayRecordPaynoUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_UPDATE_DATA = "select fid,forgid from t_bdtaxr_pay_record where fpayno = '' or fpayno = ' ' or fpayno is null";
    private static final String UPDATE_PAY_RECORD = "update t_bdtaxr_pay_record set fpayno = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(PayRecordPaynoUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7f34\u6b3e\u7f16\u53f7\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"PayRecordPaynoUpgradeService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        try {
            boolean exit = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_bdtaxr_pay_record");
            if (exit) {
                this.update();
            } else {
                info = log = ResManager.loadKDString((String)"\u65e0\u7f34\u6b3e\u7f16\u53f7\u9700\u5347\u7ea7\u7f34\u6b3e\u8bb0\u5f55\u6570\u636e", (String)"PayRecordPaynoUpgradeService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            }
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        List payList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)payList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(payList.size());
        for (Map payMap : payList) {
            Object org = payMap.get("FORGID");
            long id = Long.parseLong(String.valueOf(payMap.get("FID")));
            DynamicObject pay = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bdtaxr_pay_record");
            String number = CodeRuleServiceHelper.getNumber((String)"bdtaxr_pay_record", (DynamicObject)pay, (String)String.valueOf(org));
            paramsList.add(new Object[]{number, id});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

