/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PayRecordSbbnoUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_UPDATE_DATA = "select fid,fssbbid,fpaydate from t_bdtaxr_pay_record where fsbbno = '' or fsbbno = ' ' or fsbbno is null or ftaxauthority = 0 or ftaxauthority is null";
    private static final String UPDATE_PAY_RECORD = "update t_bdtaxr_pay_record set fsbbno = ?,ftaxauthority = ?,fentrydate = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(PayRecordSbbnoUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7f16\u53f7\u5386\u53f2\u6570\u636e\u5f00\u59cb\u5347\u7ea7", (String)"PayRecordSbbnoUpgradeService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        List payList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)payList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(payList.size());
        for (Map payMap : payList) {
            DynamicObject nsrxx;
            long id = Long.parseLong(String.valueOf(payMap.get("FID")));
            String fssbbid = (String)payMap.get("FSSBBID");
            Object fpaydate = payMap.get("FPAYDATE");
            if (fssbbid.isEmpty() || "null".equals(fssbbid)) continue;
            long sbbid = Long.parseLong(fssbbid);
            boolean exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(fssbbid))});
            if (!exists || null == (nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno,taxauthority", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbid)}))) continue;
            String sbbno = nsrxx.getString("billno");
            Long taxauthority = nsrxx.getLong("taxauthority");
            paramsList.add(new Object[]{sbbno, taxauthority, fpaydate, id});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

