/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declare;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.opplugin.declare.DeclareRiskControlValidator;

public class DeclareAuditOp
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(DeclareAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DeclareRiskControlValidator.fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new DeclareRiskControlValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            String operationKey = e.getOperationKey();
            this.syncMbksData(operationKey, dataEntities);
            DeclareUtils.saveRuleHistory((String)operationKey, (String)"tcvat_nsrxx", (DynamicObject[])dataEntities);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    private void syncMbksData(String operationKey, DynamicObject[] dataEntities) {
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
            List ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)"MbksTaxbookSyncService", (String)"syncData", (Object[])new Object[]{ids});
            DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])dataEntities, (DeclareOperationEnum)DeclareOperationEnum.AUDIT);
        }
    }
}

