/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declare;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctrc.RiskResultHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RiskControlUtils;

public class DeclareRiskControlValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(RiskControlUtils.class);
    public static List<String> fieldKeys = Lists.newArrayList((Object[])new String[]{"id", "billno", "type", "templatetype.number", "skssqq", "skssqz", "org", "draftpurpose", "taxtype"});

    public void validate() {
        try {
            List declares = Arrays.stream(this.getDataEntities()).map(v -> v.getDataEntity()).collect(Collectors.toList());
            if (EmptyCheckUtils.isEmpty(declares)) {
                return;
            }
            List riskControlParams = RiskControlUtils.buildRiskControlParams(declares, (String)this.getOperateKey());
            TaxResult riskControlResult = RiskResultHelper.getRiskControlResult((List)riskControlParams);
            if (riskControlResult.isSuccess()) {
                List data = (List)riskControlResult.getData();
                if (EmptyCheckUtils.isNotEmpty((Object)data)) {
                    Map<String, Map> declareResultMap = data.stream().collect(Collectors.toMap(k -> (String)k.get("id"), v -> v, (v1, v2) -> v2));
                    for (ExtendedDataEntity entity : this.getDataEntities()) {
                        Map declareResult = declareResultMap.get(entity.getDataEntity().getString("id"));
                        if (!EmptyCheckUtils.isNotEmpty((Object)declareResult) || !"0".equals(declareResult.get("verifyResult"))) continue;
                        String msg = (String)declareResult.get("tipMsg");
                        this.addFatalErrorMessage(entity, msg);
                    }
                } else {
                    logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38\uff0c\u8fd4\u56dedata\u4e3a\u7a7a\u3002");
                }
            } else {
                logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38{}\u3002", (Object)riskControlResult.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("RiskControlUtils.checkRiskControlResult error:" + e.getMessage(), (Throwable)e);
        }
    }
}

