/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declarelist;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.common.declare.helper.TaxBureauServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class DeclareListInvalidOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DeclareListInvalidOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("invalid".equals(operateKey)) {
            String opreateType = "";
            try {
                opreateType = this.getOption().getVariableValue("msgInput");
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicObject[] dataEntities = args.getDataEntities();
            Object pkValue = dataEntities[0].getPkValue();
            DynamicObject declares = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tcvat_nsrxx");
            String checkZfInfo = this.checkZfInfo(declares);
            if (checkZfInfo != null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(checkZfInfo);
                this.operationResult.setShowMessage(false);
                return;
            }
            String nsrtype = declares.getString("type");
            this.saveHisSbbInfo(declares, opreateType, nsrtype);
            if (!"ccxws".equals(nsrtype)) {
                declares.set("datatype", (Object)"1");
            }
            SaveServiceHelper.update((DynamicObject)declares);
            String entryentityId = dataEntities[0].getDataEntityType().getName();
            OperationResult cancelapplyResult = "ccxws".equals(nsrtype) ? OperationServiceHelper.executeOperate((String)"cancelapply", (String)"tcret_query_report", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create()) : OperationServiceHelper.executeOperate((String)"cancelapply", (String)entryentityId, (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
            logger.info("DeclareListInvalidOp\u4e2dcancelapply\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)cancelapplyResult));
            if (!cancelapplyResult.isSuccess()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7533\u62a5\u64cd\u4f5c\u5931\u8d25", (String)"DeclareListInvalidOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            OperationResult unauditResult = "ccxws".equals(nsrtype) ? OperationServiceHelper.executeOperate((String)"unaudit", (String)"tcret_query_report", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create()) : OperationServiceHelper.executeOperate((String)"unaudit", (String)"tcvat_zzs_declare_list", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
            logger.info("DeclareListInvalidOp\u4e2dunaudit\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)unauditResult));
            if (!unauditResult.isSuccess()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7533\u62a5\u64cd\u4f5c\u5931\u8d25\uff0c\u64a4\u9500\u672a\u6210\u529f", (String)"DeclareListInvalidOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
        }
    }

    private String checkZfInfo(DynamicObject declares) {
        String declarestatus = declares.getString("declarestatus");
        String paystatus = declares.getString("paystatus");
        if (!"declared".equals(declarestatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u4f5c\u5e9f\u7533\u62a5", (String)"DeclareListInvalidOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if (!"unpaid".equals(paystatus) && !"nopay".equals(paystatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u672a\u7f34\u6b3e\u201d\u6216\u201c\u65e0\u9700\u7f34\u6b3e\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u4f5c\u5e9f\u7533\u62a5", (String)"DeclareListInvalidOp_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if (this.judgeGenerCert(declares.getPkValue().toString())) {
            return ResManager.loadKDString((String)"\u7a0e\u91d1\u7f34\u7eb3\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u518d\u64cd\u4f5c", (String)"DeclareListInvalidOp_6", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        return null;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])dataEntities, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)e.getOperationKey()));
    }

    private boolean judgeGenerCert(String sbbid) {
        QFilter filter = new QFilter("sbbid", "=", (Object)sbbid).and("isvoucher", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{filter});
    }

    private void saveHisSbbInfo(DynamicObject declares, String opreateType, String nsrtype) {
        long orgid = ((DynamicObject)declares.get("org")).getLong("id");
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.valueOf(orgid));
        requestModel.setTemplateType(nsrtype);
        requestModel.setSkssqq(DateUtils.format((Date)declares.getDate("skssqq")));
        requestModel.setSkssqz(DateUtils.format((Date)declares.getDate("skssqz")));
        requestModel.setId(Long.valueOf(declares.getLong("id")));
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("versiontype", declares.get("versiontype"));
        extendParams.put("causedesc", opreateType);
        requestModel.setExtendParams(extendParams);
        TaxDeclareDataServiceImpl taxDeclareDataService = new TaxDeclareDataServiceImpl();
        DeclareResponseModel responseModel = taxDeclareDataService.queryData(requestModel);
        Map olddata = responseModel.getData();
        String declaredata = JsonUtil.toJson((Object)olddata);
        TaxBureauServiceHelper.saveData((DynamicObject)declares, (String)"bdtaxr_history_sbb", (DeclareRequestModel)requestModel, (String)declaredata);
    }
}

