/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class DeclareListUnpayOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("cancelpay".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                for (DynamicObject declare : declares) {
                    boolean deferpayapply;
                    DynamicObject org = declare.getDynamicObject("org");
                    String type = declare.getString("type");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String payType = declare.getString("paytype");
                    String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    String archivestatus = declare.getString("archivestatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7f34\u6b3e\u8868\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"paid".equals(declare.getString("paystatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if ("filed".equals(archivestatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u6b64\u7533\u62a5\u8868\u5df2\u7ecf\u5f52\u6863\uff0c\u8bf7\u5728\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u91cc\u53cd\u5f52\u6863\u540e\u518d\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (type.contains("zzs") && declare.containsProperty("entryentity")) {
                        DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
                        deferpayapply = entryentity.stream().anyMatch(e -> e.getBoolean("deferpayapply1"));
                    } else {
                        deferpayapply = declare.getBoolean("deferpayapply");
                    }
                    if (deferpayapply) {
                        message.append(String.format(ResManager.loadKDString((String)"\u7f34\u6b3e\u8bb0\u5f55\u5df2\u7533\u8bf7\u7f13\u7f34\uff0c\u8bf7\u5230\u7f13\u7f34\u7533\u8bf7\u67e5\u8be2\u754c\u9762\u64cd\u4f5c: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"0".equals(payType)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u624b\u5de5\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareListUnpayOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    declare.set("paystatus", (Object)"unpaid");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("paytype", (Object)"");
                    declare.set("paydate", null);
                    declare.set("payer", (Object)0L);
                    modifyDynamicObjects.add(declare);
                    String billno = declare.getString("billno");
                    String nsrtype = declare.getString("type");
                    if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                    OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u7f34\u6b3e", (String)"DeclareListUnpayOp_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7f34\u6b3e\u8868\u53d6\u6d88\u7f34\u6b3e\u6210\u529f", (String)"DeclareListUnpayOp_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (CollectionUtils.isNotEmpty(modifyDynamicObjects)) {
                    List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                    SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{sbbIds});
                    this.doUpdateZzsPrePayBill(Arrays.asList(declares));
                    DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]);
                    DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operateKey));
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }

    private void doUpdateZzsPrePayBill(List<DynamicObject> modifyDynamicObjects) {
        List yjList = modifyDynamicObjects.stream().filter(m -> "zzsyjskb".equals(m.getString("type"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(yjList)) {
            DynamicObject[] yjObjs;
            for (DynamicObject yjObj : yjObjs = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"id,paystatus,payer,paydate,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", yjList.stream().map(y -> y.getLong("id")).collect(Collectors.toList()))})) {
                yjObj.set("paystatus", (Object)"0");
                yjObj.set("payer", null);
                yjObj.set("modifytime", (Object)new Date());
                yjObj.set("paydate", null);
                yjObj.set("modifier", (Object)RequestContext.get().getUserId());
            }
            SaveServiceHelper.save((DynamicObject[])yjObjs);
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])dataEntities, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)e.getOperationKey()));
    }
}

