/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.multideclarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnumBase;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public abstract class DeclareListDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DeclareListDeleteOp.class);
    private static final String DELETE = "delete";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("org", "taxsystem", "taxtype", "taxareagroup", "accountsettype", "skssqq", "skssqz", "taxtype", "templatetype", "draftpurpose", "billstatus", "datatype", "declarestatus", "paystatus"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if (DeclareListDeleteOp.DELETE.equals(operateKey)) {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObject data = dataEntity.getDataEntity();
                        if (!data.containsProperty("versiontype")) {
                            return;
                        }
                        String versiontype = data.getString("versiontype");
                        if (!"gzsb".equals(versiontype)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u6b63\u7533\u62a5\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeclareListDeleteOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if (DELETE.equals(operateKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List<Object> list = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (list == null || list.isEmpty()) {
                return;
            }
            String modle = this.getModelNumber();
            MultiTableEnum tableEnum = MultiTableEnum.getMultiTableByModelNumber((String)modle);
            String mainTable = tableEnum.getDeclareMainTable();
            String detailTable = tableEnum.getDeclareDetailTabled();
            try {
                this.deleteDrillData(list, mainTable);
                DeleteServiceHelper.delete((String)detailTable, (QFilter[])new QFilter[]{new QFilter("entryid", "in", list)});
                this.businessDelete(list);
            }
            catch (Exception e) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage("delete error! please retry");
                logger.error("taxc-DeferPayRptPlugin pay fail:", (Object)e.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (MultiTableEnum.TSD001.getModel().equalsIgnoreCase(this.getModelNumber())) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                try {
                    AccrualMQSender.sendMQ((DynamicObject)dataEntity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (DELETE.equals(e.getOperationKey())) {
                OverSeaMQSender.sendMQ(Arrays.asList(dataEntities), (String)DELETE, (String)this.billEntityType.getName());
            }
        }
        if (DELETE.equals(e.getOperationKey())) {
            MultiDeclareMQSender.sendMQ((DynamicObject[])e.getDataEntities(), (String)DELETE);
            DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])e.getDataEntities(), (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)e.getOperationKey()));
        }
    }

    private void deleteDrillData(List<Object> list, String mainTable) {
        DynamicObject[] selectRowInfos;
        ArrayList<RuleFetchMainDto> ruleFetchMainDtos = new ArrayList<RuleFetchMainDto>(list.size());
        for (DynamicObject selectRowInfo : selectRowInfos = BusinessDataServiceHelper.load((String)mainTable, (String)MetadataUtil.getAllFieldToQuery((String)mainTable), (QFilter[])new QFilter[]{new QFilter("id", "in", list)})) {
            RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
            ruleFetchMainDto.setOrgId(Long.valueOf(selectRowInfo.getLong("org.id")));
            ruleFetchMainDto.setSkssqq(selectRowInfo.getDate("skssqq"));
            ruleFetchMainDto.setSkssqz(selectRowInfo.getDate("skssqz"));
            ruleFetchMainDto.setTemplateId(Long.valueOf(selectRowInfo.getLong("templateid.id")));
            if (MultiTableEnumBase.TSD001.getDeclareMainTable().equals(mainTable)) {
                if (selectRowInfo.containsProperty("taxsystem")) {
                    ruleFetchMainDto.setTaxsystem(Long.valueOf(selectRowInfo.getLong("taxsystem.id")));
                }
                if (selectRowInfo.containsProperty("taxareagroup")) {
                    ruleFetchMainDto.setTaxareagroup(Long.valueOf(selectRowInfo.getLong("taxareagroup.id")));
                }
                if (selectRowInfo.containsProperty("draftpurpose")) {
                    ruleFetchMainDto.setPurpose(selectRowInfo.getString("draftpurpose"));
                }
            }
            ruleFetchMainDtos.add(ruleFetchMainDto);
        }
        if (!CollectionUtils.isEmpty(ruleFetchMainDtos)) {
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.delRuleFetchData(ruleFetchMainDtos);
        }
    }

    public abstract String getModelNumber();

    protected abstract void businessDelete(List<Object> var1);
}

