/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.multideclarelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class MultiDeclareListApplyOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("apply".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            StringBuilder fzybhzMessage = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tpo_declare_main_tsc", (String)TaxDeclareConstant.MAIN_DECLARE_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    DynamicObject templatetype = (DynamicObject)declare.get("templatetype");
                    String type = templatetype.getString("number");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListApplyOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u786e\u8ba4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListApplyOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                    if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                        declare.set("paystatus", (Object)"nopay");
                    }
                    declare.set("declarestatus", (Object)"declared");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("declaremethod", (Object)"0");
                    declare.set("sbrq", (Object)new Date());
                    declare.set("declarer", (Object)RequestContext.get().getUserId());
                    modifyDynamicObjects.add(declare);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(String.valueOf(fzybhzMessage.insert(0, "fzybhz:")));
                    this.operationResult.setShowMessage(false);
                    return;
                }
                String appId = this.billEntityType.getAppId();
                if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                    List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                    if ("totf".equals(appId) || "tcnfep".equals(appId)) {
                        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                    }
                    DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]);
                    SaveServiceHelper.save((DynamicObject[])saveObjects);
                    for (DynamicObject modifyob : modifyDynamicObjects) {
                        DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)MultiDeclareListApplyOp.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)operateKey);
                    }
                    MultiDeclareMQSender.sendMQ((DynamicObject[])saveObjects, (String)operateKey);
                    DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operateKey));
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

