/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.multideclarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class MultiDeclareListUnapplyOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("cancelapply".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tpo_declare_main_tsc", (String)TaxDeclareConstant.MAIN_DECLARE_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    DynamicObject templatetype = (DynamicObject)declare.get("templatetype");
                    String type = templatetype.getString("number");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String declareType = declare.getString("declaremethod");
                    String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnapplyOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!("payfailed".equals(declare.getString("paystatus")) || "unpaid".equals(declare.getString("paystatus")) || "nopay".equals(declare.getString("paystatus")) || StringUtils.isBlank((CharSequence)declare.getString("paystatus")))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\u3001\u7f34\u6b3e\u5931\u8d25\u3001\u65e0\u9700\u7f34\u6b3e\u6216\u672a\u7533\u8bf7\u7f13\u7f34\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnapplyOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName));
                        continue;
                    }
                    if (!"declared".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnapplyOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"0".equals(declareType)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u65b9\u5f0f\u4e3a\u624b\u5de5\u7533\u62a5\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnapplyOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"1");
                    QFilter sbbidfilter = new QFilter("sbbid", "=", (Object)String.valueOf(declare.getLong("id")));
                    boolean exists = QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidfilter, voucherFilter});
                    if (exists) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\u53ef\u8fdb\u884c\u53d6\u6d88\u7533\u62a5\u64cd\u4f5c: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnapplyOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    declare.set("declarestatus", (Object)"editing");
                    declare.set("paystatus", (Object)"unpaid");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("declaremethod", (Object)"");
                    declare.set("paytype", (Object)"");
                    declare.set("sbrq", null);
                    declare.set("paydate", null);
                    declare.set("payer", (Object)0L);
                    declare.set("declarer", (Object)0L);
                    modifyDynamicObjects.add(declare);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                    List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"cancelDeclare", (Object[])new Object[]{sbbIds});
                    DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]);
                    SaveServiceHelper.save((DynamicObject[])saveObjects);
                    MultiDeclareMQSender.sendMQ((DynamicObject[])saveObjects, (String)operateKey);
                    DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operateKey));
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }
}

