/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.provision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAddOrDelProvisionByDraftOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
                    List idList = Arrays.stream(this.dataEntities).map(o -> o.getBillPkId()).collect(Collectors.toList());
                    DynamicObject[] objects = BusinessDataServiceHelper.load((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
                    if (ObjectUtils.isEmpty((Object)objects)) {
                        return;
                    }
                    HashMap<String, String> showErrorMap = new HashMap<String, String>(12);
                    HashSet<String> notStatusA = new HashSet<String>();
                    HashSet<String> statusA = new HashSet<String>();
                    List entityNumberList = Arrays.asList(objects).stream().map(o -> o.getString("billno")).collect(Collectors.toList());
                    QFilter billNoQ = new QFilter("entitynumber", "in", entityNumberList);
                    DynamicObjectCollection jtdCollection = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"billno,billstatus,entitynumber", (QFilter[])new QFilter[]{billNoQ});
                    for (DynamicObject jtdRow : jtdCollection) {
                        String entityNumber = jtdRow.getString("entitynumber");
                        if (StringUtil.equalsIgnoreCase((CharSequence)jtdRow.getString("billstatus"), (CharSequence)"A")) {
                            statusA.add(entityNumber);
                            continue;
                        }
                        notStatusA.add(entityNumber);
                        showErrorMap.put(entityNumber, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5168\u90e8\u8ba1\u63d0\u5355\u53ef\u4ee5\u5220\u9664\u3002", (String)"AbstractAddOrDelProvisionByDraftOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                    statusA.removeIf(s -> notStatusA.contains(s));
                    List noPassDraftList = entityNumberList.stream().filter(o -> !statusA.contains(o)).filter(o -> !notStatusA.contains(o)).collect(Collectors.toList());
                    noPassDraftList.stream().forEach(number -> showErrorMap.put((String)number, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"AbstractAddOrDelProvisionByDraftOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0])));
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        if (noPassDraftList.contains(dataEntity.getBillNo())) {
                            this.addFatalErrorMessage(dataEntity, (String)showErrorMap.get(dataEntity.getBillNo()));
                            continue;
                        }
                        if (!notStatusA.contains(dataEntity.getBillNo())) continue;
                        this.addFatalErrorMessage(dataEntity, (String)showErrorMap.get(dataEntity.getBillNo()));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"deletejtd")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List idList = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getEntitytype()));
            this.updateBillPointFieldAfterDeleteProvision(dynamicObjects);
            Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            ArrayList<String> successDraftBillNoList = new ArrayList<String>();
            HashSet<String> sourceDraftTypeList = new HashSet<String>();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            ArrayList successIdList = new ArrayList();
            Arrays.stream(successResult).forEach(o -> {
                successIdList.add(((DynamicObject)o).getLong("id"));
                successDraftBillNoList.add(((DynamicObject)o).getString("billno"));
                sourceDraftTypeList.add(((DynamicObject)o).getString("templatetype.name"));
            });
            DeleteServiceHelper.delete((String)"itp_proviston_taxes", (QFilter[])new QFilter[]{this.createDeleteProvisionQFilter(successDraftBillNoList, sourceDraftTypeList)});
            for (DynamicObject entity : dataEntities) {
                if (successIdList.contains(entity.getLong("id"))) {
                    successObjs.add(entity);
                    continue;
                }
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractAddOrDelProvisionByDraftOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), entity.getString("billno"));
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_Proviston_fail", ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"AbstractAddOrDelProvisionByDraftOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"newjtd")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List<Long> draftIds = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
            Map<Boolean, Map<Long, String>> resultMap = this.generateProvisionBill(draftIds);
            HashSet successDraftIdList = new HashSet();
            for (Map.Entry<Boolean, Map<Long, String>> entry : resultMap.entrySet()) {
                successDraftIdList = entry.getKey() != false ? entry.getValue().entrySet().stream().map(o -> (Long)o.getKey()).collect(Collectors.toSet()) : successDraftIdList;
            }
            ArrayList<DynamicObject> successDraftObjectList = new ArrayList<DynamicObject>();
            ArrayList saveSuccDraftId = new ArrayList();
            if (ObjectUtils.isNotEmpty(successDraftIdList)) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])successDraftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.billEntityType.getName()));
                this.updateSuccessBillPointField(dynamicObjects);
                Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                if (successResult.length > 0) {
                    Arrays.stream(successResult).forEach(o -> saveSuccDraftId.add(((DynamicObject)o).getLong("id")));
                }
            }
            for (DynamicObject rowObject : dataEntities) {
                ValidationErrorInfo info;
                Long draftId = rowObject.getLong("id");
                if (saveSuccDraftId.contains(rowObject.getLong("id"))) {
                    successDraftObjectList.add(rowObject);
                    continue;
                }
                String title = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"AbstractAddOrDelProvisionByDraftOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractAddOrDelProvisionByDraftOp_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), rowObject.getString("billno"));
                Map<Long, String> failMap = resultMap.get(Boolean.FALSE);
                if (ObjectUtils.isNotEmpty((Object)failMap.get(draftId))) {
                    info = new ValidationErrorInfo("", (Object)"", 0, 0, "generate_Proviston_fail", title, failMap.get(draftId), ErrorLevel.FatalError);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                    continue;
                }
                info = new ValidationErrorInfo("", (Object)"", 0, 0, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
            }
            args.setDataEntities(successDraftObjectList.toArray(new DynamicObject[0]));
        }
    }

    protected QFilter createDeleteProvisionQFilter(List<String> successDraftBillNoList, Set<String> sourceDraftTypeList) {
        QFilter billNoQ = new QFilter("entitynumber", "in", successDraftBillNoList);
        QFilter sourceDraftTypeQ = new QFilter("sourcedrafttype", "in", sourceDraftTypeList);
        QFilter entitytypeQ = new QFilter("entitytype", "=", (Object)this.getEntitytype());
        return billNoQ.and(sourceDraftTypeQ).and(entitytypeQ);
    }

    protected void updateBillPointFieldAfterDeleteProvision(DynamicObject[] dynamicObjects) {
        Arrays.stream(dynamicObjects).forEach(row -> row.set("generatebusinessdoc", (Object)Boolean.FALSE));
    }

    protected void updateSuccessBillPointField(DynamicObject[] dynamicObjects) {
        Arrays.stream(dynamicObjects).forEach(row -> row.set("generatebusinessdoc", (Object)Boolean.TRUE));
    }

    protected abstract String getEntitytype();

    protected abstract Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> var1);
}

