/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.provision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.helper.ProvisionOpHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DraftAddOrDelProvisionOp
extends AbstractOperationServicePlugIn {
    private static final String TCVAT_SJJT_DRAFT_QUERY = "tcvat_sjjt_draft_query";
    private static final String ITP_PROVISTON_ITEM = "itp_proviston_item";
    private static final String TCCIT_SJJT_LIST = "tccit_sjjt_list";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("templatetype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        String operationKey = args.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"newjtd")) {
            if (TemplateTypeConstant.TCVAT_SJJT_TYPES.contains(dataEntities[0].getString("templatetype"))) {
                this.createJtd(args, dataEntities);
            } else {
                this.newJtd(args, dataEntities);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"deletejtd")) {
            this.deleteJtd(args, dataEntities);
        }
    }

    private void newJtd(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        Map<Object, DynamicObject> objectMap = Arrays.stream(dataEntities).collect(Collectors.toMap(k -> k.getPkValue(), v -> v, (m, n) -> m));
        String title = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"DraftAddOrDelProvisionOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        ArrayList successDraftObjectList = new ArrayList();
        if (objectMap.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DraftAddOrDelProvisionOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
            this.operationResult.addErrorInfo((OperateErrorInfo)info);
            args.setDataEntities(successDraftObjectList.toArray(new DynamicObject[0]));
            args.setCancelFormService(true);
            return;
        }
        HashMap<String, DynamicObject> billnoMap = new HashMap<String, DynamicObject>(dataEntities.length);
        HashMap<Object, DynamicObject> pkValueMap = new HashMap<Object, DynamicObject>(dataEntities.length);
        HashMap<Object, Integer> pkValueIndex = new HashMap<Object, Integer>(dataEntities.length);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject rowObject = dataEntities[i];
            Object pkValue = rowObject.getPkValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)TCCIT_SJJT_LIST);
            String jtnumber = dynamicObject.getString("businessdocno");
            if (jtnumber.length() > 0) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DraftAddOrDelProvisionOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                ValidationErrorInfo info = new ValidationErrorInfo("", pkValue, i, i, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                continue;
            }
            Object billstatus = dynamicObject.get("billstatus");
            if (!"C".equals(billstatus)) {
                String msg = ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5df2\u5ba1\u6838\u7684\u5e95\u7a3f\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DraftAddOrDelProvisionOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                ValidationErrorInfo info = new ValidationErrorInfo("", pkValue, i, i, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                continue;
            }
            DynamicObject item = QueryServiceHelper.queryOne((String)ITP_PROVISTON_ITEM, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JTSX-0001"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (item == null) {
                String msg = ResManager.loadKDString((String)"\u8ba1\u63d0\u4e8b\u9879\u672a\u542f\u7528\u3002", (String)"DraftAddOrDelProvisionOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                ValidationErrorInfo info = new ValidationErrorInfo("", pkValue, i, i, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                continue;
            }
            arrayList.add(this.createParams(dynamicObject, item));
            String billnoCache = (String)dynamicObject.get("billno");
            billnoMap.put(billnoCache, dynamicObject);
            pkValueMap.put(pkValue, rowObject);
            pkValueIndex.put(pkValue, i);
        }
        String responseList = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(arrayList)});
        BaseResult data = (BaseResult)SerializationUtils.fromJsonString((String)responseList, BaseResult.class);
        if (data.getCode().equals(BaseResult.OK)) {
            List responses = (List)data.getData();
            HashMap responseMap = new HashMap();
            responses.forEach(a -> responseMap.putAll(a));
            for (Map.Entry entry : responseMap.entrySet()) {
                String billno = (String)entry.getKey();
                String businessdocno = (String)entry.getValue();
                DynamicObject dynamicObject = (DynamicObject)billnoMap.get(billno);
                dynamicObject.set("generatebusinessdoc", (Object)true);
                dynamicObject.set("businessdocno", (Object)businessdocno);
            }
            SaveServiceHelper.save((DynamicObject[])billnoMap.values().toArray(new DynamicObject[billnoMap.size()]));
            successDraftObjectList.addAll(pkValueMap.values());
        } else {
            pkValueIndex.forEach((k, v) -> {
                ValidationErrorInfo info = new ValidationErrorInfo("", k, v.intValue(), v.intValue(), "generate_Proviston_fail", title, data.getMessage(), ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
            });
        }
        args.setDataEntities(successDraftObjectList.toArray(new DynamicObject[0]));
    }

    private void deleteJtd(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        List idList = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_SJJT_DRAFT_QUERY));
        Arrays.stream(dynamicObjects).forEach(row -> {
            row.set("generatebusinessdoc", (Object)Boolean.FALSE);
            row.set("businessdocno", (Object)"");
        });
        Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        ArrayList successDraftBillNoList = new ArrayList();
        HashSet sourceDraftTypeList = new HashSet();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        ArrayList successIdList = new ArrayList();
        Arrays.stream(successResult).forEach(o -> {
            successIdList.add(((DynamicObject)o).getLong("id"));
            successDraftBillNoList.add(((DynamicObject)o).getString("billno"));
            sourceDraftTypeList.add(ProvisionOpHelper.getTemplateType((String)((DynamicObject)o).getString("templatetype")));
        });
        QFilter billNoQ = new QFilter("entitynumber", "in", successDraftBillNoList);
        QFilter sourceDraftTypeQ = new QFilter("sourcedrafttype", "in", sourceDraftTypeList);
        QFilter entitytypeQ = new QFilter("entitytype", "=", (Object)"tpo_declare_main_tsd");
        DeleteServiceHelper.delete((String)"itp_proviston_taxes", (QFilter[])new QFilter[]{billNoQ, sourceDraftTypeQ, entitytypeQ});
        for (DynamicObject entity : dataEntities) {
            if (successIdList.contains(entity.getLong("id"))) {
                successObjs.add(entity);
                continue;
            }
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25", (String)"DraftAddOrDelProvisionOp_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), entity.getString("billno"));
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_Proviston_fail", ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"DraftAddOrDelProvisionOp_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), msg, ErrorLevel.FatalError);
            this.operationResult.addErrorInfo((OperateErrorInfo)info);
        }
        args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - void declaration
     */
    private void createJtd(BeginOperationTransactionArgs args, DynamicObject[] dataEntities) {
        String msg;
        Set ids = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
        String title = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"DraftAddOrDelProvisionOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCVAT_SJJT_DRAFT_QUERY, (String)"generatebusinessdoc,id,billstatus", (QFilter[])new QFilter("id", "in", ids).toArray());
        Map<Object, DynamicObject> objectMap = query.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v));
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject rowObject = dataEntities[i];
            Object pkValue = rowObject.getPkValue();
            DynamicObject dynamicObject = objectMap.get(pkValue);
            String string = rowObject.getString("billno");
            boolean generatebusinessdoc = dynamicObject.getBoolean("generatebusinessdoc");
            if (generatebusinessdoc) {
                String msg2 = String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DraftAddOrDelProvisionOp_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), string);
                ValidationErrorInfo info = new ValidationErrorInfo("billno", pkValue, i, i, "generate_Proviston_fail", title, msg2, ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                continue;
            }
            Object billstatus = dynamicObject.get("billstatus");
            if (!"C".equals(billstatus)) {
                msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4ec5\u5141\u8bb8\u5df2\u5ba1\u6838\u7684\u5e95\u7a3f\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DraftAddOrDelProvisionOp_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), string);
                ValidationErrorInfo info = new ValidationErrorInfo("billno", pkValue, i, i, "generate_Proviston_fail", title, msg, ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                continue;
            }
            idList.add((Long)pkValue);
        }
        ArrayList<DynamicObject> successDraftObjectList = new ArrayList<DynamicObject>();
        if (idList.size() > 0) {
            void var12_19;
            Map resultMap = ProvisionOpHelper.requestZzsGenerateProvisionBillService(idList);
            HashSet successDraftIdList = new HashSet();
            for (Map.Entry entry : resultMap.entrySet()) {
                successDraftIdList = (Boolean)entry.getKey() != false ? ((Map)entry.getValue()).entrySet().stream().map(o -> (Long)o.getKey()).collect(Collectors.toSet()) : successDraftIdList;
            }
            ArrayList saveSuccDraftId = new ArrayList();
            if (ObjectUtils.isNotEmpty(successDraftIdList)) {
                DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])successDraftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.billEntityType.getName()));
                Arrays.stream(dynamicObjectArray).forEach(row -> row.set("generatebusinessdoc", (Object)Boolean.TRUE));
                Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                Arrays.stream(successResult).forEach(o -> saveSuccDraftId.add(((DynamicObject)o).getLong("id")));
            }
            boolean bl = false;
            while (var12_19 < dataEntities.length) {
                DynamicObject rowObject = dataEntities[var12_19];
                Long draftId = rowObject.getLong("id");
                if (idList.contains(draftId)) {
                    if (saveSuccDraftId.contains(rowObject.getLong("id"))) {
                        successDraftObjectList.add(rowObject);
                    } else {
                        ValidationErrorInfo info;
                        msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25", (String)"DraftAddOrDelProvisionOp_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), rowObject.getString("billno"));
                        Map failMap = (Map)resultMap.get(Boolean.FALSE);
                        if (ObjectUtils.isNotEmpty(failMap.get(draftId))) {
                            info = new ValidationErrorInfo("billno", rowObject.getPkValue(), (int)var12_19, (int)var12_19, "generate_Proviston_fail", title, (String)failMap.get(draftId), ErrorLevel.FatalError);
                            this.operationResult.addErrorInfo((OperateErrorInfo)info);
                        } else {
                            info = new ValidationErrorInfo("billno", rowObject.getPkValue(), (int)var12_19, (int)var12_19, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                            this.operationResult.addErrorInfo((OperateErrorInfo)info);
                        }
                    }
                }
                ++var12_19;
            }
        }
        args.setDataEntities(successDraftObjectList.toArray(new DynamicObject[0]));
    }

    private Map<String, Object> createParams(DynamicObject dynamicObject, DynamicObject item) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List entryentity = (List)dynamicObject.get("entryentity");
        if (entryentity.size() > 0) {
            Object bqybtse = ((DynamicObject)entryentity.get(0)).get("bqybtse");
            map.put("total", bqybtse);
        } else {
            map.put("total", new BigDecimal(0));
        }
        DynamicObject org = (DynamicObject)dynamicObject.get("org");
        DynamicObject accountorg = (DynamicObject)dynamicObject.get("accountorg");
        String billno = (String)dynamicObject.get("billno");
        String userId = RequestContext.get().getUserId();
        map.put("taxtype", 3);
        map.put("taxsystem", 1);
        map.put("coins", 1);
        map.put("provistonitem", item.get("id"));
        map.put("taxorg", org.getLong("id"));
        map.put("accountorg", accountorg != null ? accountorg.getLong("id") : 0L);
        map.put("startdate", dynamicObject.get("skssqq"));
        map.put("enddate", dynamicObject.get("skssqz"));
        map.put("entitytype", TCCIT_SJJT_LIST);
        map.put("entitynumber", billno);
        map.put("creator", userId);
        map.put("modifier", userId);
        map.put("entrydate", dynamicObject.get("skssqz"));
        return map;
    }
}

