/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.validator.provision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleQueryDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleResultDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionRuleDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CreateProvisionValidator
extends AbstractValidator {
    private static final String ITP_PROVISTON_ITEM = "itp_proviston_item";

    public void validate() {
        List taxtypeList = Arrays.stream(this.dataEntities).map(d -> d.getDataEntity().getDynamicObject("taxtype").getLong("id")).collect(Collectors.toList());
        HashSet<Object> pks = new HashSet<Object>();
        ArrayList<ProvisionRuleQueryDto> queryDtoList = new ArrayList<ProvisionRuleQueryDto>(this.dataEntities.length);
        Map<Object, Object> ruleMaps = new HashMap(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            taxtypeList.add(entity.getDynamicObject("taxtype").getLong("id"));
            pks.add(dataEntity.getBillPkId());
            if (BaseTaxCategory.ZZS.longValue() != entity.getLong("taxtype.id") || !"tcvat_rta_query".equals(this.entityKey) && !"tcvat_sjjt_draft_query".equals(this.entityKey)) continue;
            List<Long> taxTypeIds = this.getTaxTypeIds();
            for (Long taxTypeId : taxTypeIds) {
                ProvisionRuleQueryDto dto = new ProvisionRuleQueryDto();
                dto.setOrgId(Long.valueOf(entity.getDynamicObject("org").getLong("id")));
                dto.setTaxationsysId(TaxationSysEnum.CHAIN_MAINLAND.getId());
                dto.setTaxtype(taxTypeId);
                dto.setTemplateType("tcvat_rta_query".equals(this.entityKey) ? entity.getDynamicObject("templatetype").getString("number") : entity.getString("templatetype"));
                queryDtoList.add(dto);
            }
            TaxResult provisionRules = ProvisionRuleDataServiceHelper.getProvisionRules(queryDtoList);
            List data = (List)provisionRules.getData();
            if (!CollectionUtils.isNotEmpty((Collection)data)) continue;
            ruleMaps = data.stream().collect(Collectors.groupingBy(o -> o.getOrgId() + "_" + o.getTemplateType()));
        }
        QFilter qFilter = new QFilter("taxtype", "in", taxtypeList);
        QFilter qFilter1 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection distinctTaxtype = QueryServiceHelper.query((String)ITP_PROVISTON_ITEM, (String)"taxtype", (QFilter[])new QFilter[]{qFilter, qFilter1});
        List enableTaxtypes = distinctTaxtype.stream().map(d -> d.getLong("taxtype")).collect(Collectors.toList());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)this.getEntityKey(), (String)"id,generatebusinessdoc,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks.toArray())});
        Map<Object, DynamicObject> dynamicObjectMap = Arrays.stream(objects).collect(Collectors.toMap(a -> a.get("id"), v -> v, (m, n) -> m));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Map<Long, DynamicObject> ruleIdMap;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject dbData = dynamicObjectMap.getOrDefault(dataEntity.getBillPkId(), dataEntity.getDataEntity());
            if (dbData.getBoolean("generatebusinessdoc")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"CreateProvisionValidator_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equalsIgnoreCase(dbData.getString("billstatus"))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5df2\u5ba1\u6838\u7684\u5e95\u7a3f\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"CreateProvisionValidator_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue;
            }
            long taxtypeId = entity.getDynamicObject("taxtype").getLong("id");
            AccrualListEnum accrualListEnum = AccrualListEnum.valueOfBaseTaxId((Long)taxtypeId);
            if (accrualListEnum != null && "tcret".equals(accrualListEnum.getAppId())) {
                QFilter q3 = new QFilter("number", "=", (Object)accrualListEnum.getProvistonItemNumber());
                boolean exists = QueryServiceHelper.exists((String)ITP_PROVISTON_ITEM, (QFilter[])new QFilter[]{qFilter, qFilter1, q3});
                if (!exists) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u63d0\u4e8b\u9879\u672a\u542f\u7528\u3002", (String)"CreateProvisionValidator_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    continue;
                }
            } else if (!enableTaxtypes.contains(taxtypeId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u63d0\u4e8b\u9879\u672a\u542f\u7528\u3002", (String)"CreateProvisionValidator_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue;
            }
            if (BaseTaxCategory.QYSDS.longValue() == entity.getLong("taxtype.id") && "tccit_sjjt_list".equals(entity.getDataEntityType().getName())) {
                DynamicObject[] branchOrgList;
                DynamicObject seasonalPolicy = this.getSeasonalPolicy(entity.getDynamicObject("org").getLong("id"), entity.getDate("skssqq"), entity.getDate("skssqz"), "sjjt");
                if (null == seasonalPolicy || !seasonalPolicy.getString("declaretype").equals("210") && !seasonalPolicy.getString("declaretype").equals("220") && !seasonalPolicy.getString("declaretype").equals("230") || !"czzs".equals(seasonalPolicy.getString("levytype"))) continue;
                for (DynamicObject dynamicObject : branchOrgList = BusinessDataServiceHelper.load((String)"tccit_seasonal_split_sjjt", (String)"branchorgid,branchybtse,org,draftnumber,skssqq,skssqz", (QFilter[])new QFilter[]{new QFilter("draftnumber", "in", (Object)entity.getString("billno"))})) {
                    Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)dynamicObject.getDynamicObject("branchorgid").getLong("id")).getData();
                    if (null != orgRelation) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8ba1\u63d0\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateProvisionValidator_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.getDynamicObject("branchorgid").getString("name")));
                }
                continue;
            }
            if (!"tcvat_rta_query".equals(this.entityKey) && !"tcvat_sjjt_draft_query".equals(this.entityKey)) continue;
            String templateType = "tcvat_rta_query".equals(this.entityKey) ? entity.getDynamicObject("templatetype").getString("number") : entity.getString("templatetype");
            String key = entity.getDynamicObject("org").getLong("id") + "_" + templateType;
            List ruleResultDtoList = (List)ruleMaps.get(key);
            if (CollectionUtils.isNotEmpty((Collection)ruleResultDtoList) && (ruleIdMap = ruleResultDtoList.stream().map(ProvisionRuleResultDto::getRules).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (o1, o2) -> o1))).size() > 0) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u65e0\u53ef\u7528\u7684\u8ba1\u63d0\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u201c\u7a0e\u52a1\u4e91>\u589e\u503c\u7a0e>\u57fa\u7840\u8bbe\u7f6e>\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u201d\u4e2d\u914d\u7f6e\u3002", (String)"CreateProvisionValidator_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), entity.getDynamicObject("org").getString("name")));
        }
    }

    private List<Long> getTaxTypeIds() {
        return Arrays.asList(1L, 6L, 19L, 20L);
    }

    public DynamicObject getSeasonalPolicy(Long orgid, Date startDate, Date endDate, String draftpurpose) {
        QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
        QFilter q1 = new QFilter("startdate", "=", (Object)startDate);
        QFilter q2 = new QFilter("enddate", "=", (Object)endDate);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        return QueryServiceHelper.queryOne((String)"tccit_seasonal_policy", (String)"declaretype,levytype", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
    }
}

