/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.ruleEngine;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.TdmBalanceFilterService;

public class TdmBalanceFilterServiceImpl
implements TdmBalanceFilterService {
    private static final String QICHU = "openinglocalcurrency";
    private static final String QIMO = "closinglocalcurrency";
    private static final String ACCOUNTPERIOD = "accountperiod";

    @Override
    public List<QFilter> buildBalanceNewFilter(Date startDate, Date endDate, List<QFilter> filterList, String selectFieldwithid, Map<String, String> params) {
        List selectFields;
        CopyOnWriteArrayList<QFilter> resultFilter = new CopyOnWriteArrayList<QFilter>(filterList);
        if (params != null && StringUtil.equalsIgnoreCase((CharSequence)Boolean.TRUE.toString(), (CharSequence)params.get("special"))) {
            startDate = DateUtils.stringToDate((String)params.get("startdate"));
            endDate = DateUtils.stringToDate((String)params.get("enddate"));
        }
        if ((selectFields = Arrays.stream(selectFieldwithid.split(",")).collect(Collectors.toList())).contains(QICHU)) {
            resultFilter.removeIf(s -> ACCOUNTPERIOD.equals(s.getProperty()));
            int month = DateUtils.getMonthOfDate((Date)startDate);
            String monthOfFormat = String.format("%02d", month);
            QFilter monthFilter = new QFilter(ACCOUNTPERIOD, "in", (Object)Lists.newArrayList((Object[])new String[]{String.valueOf(month), monthOfFormat}));
            resultFilter.add(monthFilter);
        } else if (selectFields.contains(QIMO)) {
            resultFilter.removeIf(s -> ACCOUNTPERIOD.equals(s.getProperty()));
            int month = DateUtils.getMonthOfDate((Date)endDate);
            String monthOfFormat = String.format("%02d", month);
            QFilter monthFilter = new QFilter(ACCOUNTPERIOD, "in", (Object)Lists.newArrayList((Object[])new String[]{String.valueOf(month), monthOfFormat}));
            resultFilter.add(monthFilter);
        }
        return resultFilter;
    }
}

