/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.rulecalculate;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.task.RuleSettingTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.rule.RuleSettingUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.bdtaxr.mservice.api.rulecalculate.RuleCalculateService;

public class RuleCalService
implements RuleCalculateService {
    private static Log logger = LogFactory.getLog(RuleCalService.class);
    private static final String SELECTED_FIELDS = "id,conditionjson,func,distinctfield,groupfields";
    private static final String BATCH_SELECTED_FIELDS = "id,conditionjson,isbatch,fields.distinctfield,fields.func,groupfields";
    private static final String IS_BATCH = "isbatch";

    @Override
    public Map<Long, Object> ruleCalService(String bussinessParamsStr, List<Long> ruleIds) {
        if (null == ruleIds || ruleIds.size() == 0) {
            logger.warn("\u672a\u4f20\u5165\u89c4\u5219Id.");
            return new HashMap<Long, Object>();
        }
        DynamicObject[] ruleObjs = BusinessDataServiceHelper.load((String)"bdtaxr_rule_set", (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", ruleIds)});
        if (null == ruleObjs || ruleObjs.length == 0) {
            logger.warn("\u4f20\u5165\u7684\u89c4\u5219Id\u5747\u4e3a\u65e0\u6548\u503c.");
            return new HashMap<Long, Object>();
        }
        BussinessParamsVo bussinessParams = (BussinessParamsVo)JsonUtil.fromJson((String)bussinessParamsStr, BussinessParamsVo.class);
        return this.calculate(bussinessParams, ruleObjs);
    }

    @Override
    public List<Map<String, Object>> batchRuleCalService(String bussinessParamsStr, Long ruleId) {
        if (null == ruleId) {
            logger.warn("\u672a\u4f20\u5165\u89c4\u5219Id.");
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject[] ruleObj = BusinessDataServiceHelper.load((String)"bdtaxr_batch_rule_set", (String)BATCH_SELECTED_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
        if (null == ruleObj || ruleObj.length == 0) {
            logger.warn("\u4f20\u5165\u7684\u89c4\u5219Id\u4e3a\u65e0\u6548\u503c.");
            return new ArrayList<Map<String, Object>>();
        }
        if (!ruleObj[0].getBoolean(IS_BATCH)) {
            logger.warn("\u4f20\u5165\u7684Id\u975e\u6279\u91cf\u8bbe\u7f6e\u89c4\u5219.");
            return new ArrayList<Map<String, Object>>();
        }
        BussinessParamsVo bussinessParams = (BussinessParamsVo)JsonUtil.fromJson((String)bussinessParamsStr, BussinessParamsVo.class);
        List maps = RuleSettingUtils.batchCalculate((BussinessParamsVo)bussinessParams, (DynamicObject)ruleObj[0]);
        this.formatValues(maps);
        return maps;
    }

    private void formatValues(List<Map<String, Object>> maps) {
        for (Map<String, Object> map : maps) {
            for (Map.Entry<String, Object> objectEntry : map.entrySet()) {
                int beginIndex;
                String timestampStr;
                String substring;
                Object value = objectEntry.getValue();
                if (!(value instanceof Timestamp) || !(substring = (timestampStr = value.toString()).substring(beginIndex = timestampStr.indexOf(" "))).equals(" 00:00:00.0")) continue;
                map.put(objectEntry.getKey(), timestampStr.substring(0, beginIndex));
            }
        }
    }

    private Map<Long, Object> calculate(BussinessParamsVo bussinessParams, DynamicObject[] ruleObjs) {
        RuleSettingTask ruleSettingTask = new RuleSettingTask(bussinessParams, new ArrayList<DynamicObject>(Arrays.asList(ruleObjs)));
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        HashMap<Long, Object> idToResult = new HashMap<Long, Object>(ruleObjs.length);
        for (Future future : futures) {
            try {
                idToResult.putAll((Map)future.get());
            }
            catch (Exception e) {
                logger.warn("\u90e8\u5206\u89c4\u5219\u53d6\u6570\u5931\u8d25\uff1a" + e.getLocalizedMessage());
            }
        }
        return idToResult;
    }

    private List<String> checkParams(BussinessParamsVo bussinessParams) {
        ArrayList<String> errors = new ArrayList<String>();
        if (null == bussinessParams) {
            errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a.", (String)"RuleCalService_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
            return errors;
        }
        if (StringUtil.isEmpty((CharSequence)bussinessParams.getOrgId())) {
            errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u6570\u4e2d\u4e0d\u5305\u542borgId.", (String)"RuleCalService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        }
        if (null == bussinessParams.getStartDate()) {
            errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u6570\u4e2d\u4e0d\u5305\u542bstartDate.", (String)"RuleCalService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        }
        if (null == bussinessParams.getEndDate()) {
            errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u6570\u4e2d\u4e0d\u5305\u542bendDate.", (String)"RuleCalService_3", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        }
        return errors;
    }
}

