/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.taxrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.taxc.vo.TaxAmountMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlinelog.TaxLineLogService;
import kd.taxc.bdtaxr.common.refactor.tax.service.BillRegisterService;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxLineService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.BillRegisterServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxLineServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillRegisterVo;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.mservice.api.taxrule.BillTaxLineService;
import kd.taxc.bdtaxr.mservice.taxrule.BillTaxServiceImpl;

public class BillTaxLineServiceImpl
implements BillTaxLineService {
    private static Log logger = LogFactory.getLog(BillTaxServiceImpl.class);
    private TaxLineService taxLineService = new TaxLineServiceImpl();
    private BillRegisterService billRegisterService = new BillRegisterServiceImpl();

    @Override
    public String wholeService(String currentBillKey, DynamicObject dos) {
        logger.info("tax-BillTaxLineServiceImpl wholeService\u8c03\u7528\u5f00\u59cb");
        BillRegisterVo billRegisterVo = this.billRegisterService.getBillParams(currentBillKey, "billTaxLineService", "wholeService", dos);
        if (null != billRegisterVo) {
            LinkedHashMap logs = new LinkedHashMap(16);
            TaxLineLogService taxLineLogService = new TaxLineLogService(logs);
            String taxBillEntryKey = billRegisterVo.getTaxbillentrykey();
            String internationalTaxKey = billRegisterVo.getInternationaltaxkey();
            String taxTypeKey = billRegisterVo.getTaxtypekey();
            String taxCodeKey = billRegisterVo.getTaxcodekey();
            String billKey = dos.getDataEntityType().getName();
            DynamicObjectCollection taxBill = dos.getDynamicObjectCollection(taxBillEntryKey);
            ArrayList<TaxAmountMaterialLineVo> materialLineVoList = new ArrayList<TaxAmountMaterialLineVo>(taxBill.size());
            final String taxDetailLineKey = internationalTaxKey.substring(internationalTaxKey.lastIndexOf(".") + 1, internationalTaxKey.length());
            final String taxDetailLineTaxTypeKey = taxTypeKey.substring(taxTypeKey.lastIndexOf(".") + 1, taxTypeKey.length());
            final String taxDetailLineTaxCodeKey = taxCodeKey.substring(taxCodeKey.lastIndexOf(".") + 1, taxCodeKey.length());
            HashMap<String, String> keyMap = new HashMap<String, String>(){
                {
                    this.put("taxDetailLineKey", taxDetailLineKey);
                    this.put("taxDetailLineTaxTypeKey", taxDetailLineTaxTypeKey);
                    this.put("taxDetailLineTaxCodeKey", taxDetailLineTaxCodeKey);
                }
            };
            String taxResults = "";
            AtomicInteger atomicInteger = new AtomicInteger(0);
            try {
                for (int i = 0; i < taxBill.size(); ++i) {
                    List lineVoList = this.taxLineService.service(dos, billKey, (DynamicObject)taxBill.get(i), taxLineLogService, (Map)keyMap, i);
                    TaxAmountMaterialLineVo materialLineVo = new TaxAmountMaterialLineVo(lineVoList);
                    materialLineVoList.add(materialLineVo);
                }
                materialLineVoList.stream().forEach(materialVo -> {
                    int count;
                    List lineVos = materialVo.getTaxAmountLineVo();
                    if (!ObjectUtils.isEmpty((Object)lineVos) && (count = (int)lineVos.stream().filter(taxAmountLineVo -> null != taxAmountLineVo.getTaxAmount()).count()) == lineVos.size()) {
                        atomicInteger.getAndIncrement();
                    }
                });
                taxResults = atomicInteger.get() == taxBill.size() ? "allSucc" : (atomicInteger.get() > 0 ? "partSucc" : "fail");
                try {
                    taxLineLogService.saveTaxLineLog(dos, taxLineLogService.getLogs(), taxResults);
                }
                catch (Exception e) {
                    logger.error("taxLineLogService save exception", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("tax-BillTaxLineServiceImpl wholeService exception", (Throwable)e);
            }
            logger.info("tax-BillTaxLineServiceImpl wholeService result " + JsonUtil.toJson(materialLineVoList));
            return JsonUtil.toJson(materialLineVoList);
        }
        logger.error("tax-BillTaxLineServiceImpl wholeService BillRegisterService no config!");
        return JsonUtil.toJson(new ArrayList());
    }

    @Override
    public String partService(String currentBillKey, DynamicObject dos, DynamicObject taxBillEntry) {
        logger.info("tax-BillTaxLineServiceImpl partService \u8c03\u7528\u5f00\u59cb");
        BillRegisterVo billRegisterVo = this.billRegisterService.getBillParams(currentBillKey, "billTaxLineService", "partService", dos);
        if (null != billRegisterVo) {
            LinkedHashMap logs = new LinkedHashMap(1);
            TaxLineLogService taxLineLogService = new TaxLineLogService(logs);
            ArrayList lineVoList = new ArrayList();
            String internationalTaxKey = billRegisterVo.getInternationaltaxkey();
            String taxTypeKey = billRegisterVo.getTaxtypekey();
            String taxCodeKey = billRegisterVo.getTaxcodekey();
            String billKey = dos.getDataEntityType().getName();
            final String taxDetailLineKey = internationalTaxKey.substring(internationalTaxKey.lastIndexOf(".") + 1, internationalTaxKey.length());
            final String taxDetailLineTaxTypeKey = taxTypeKey.substring(taxTypeKey.lastIndexOf(".") + 1, taxTypeKey.length());
            final String taxDetailLineTaxCodeKey = taxCodeKey.substring(taxCodeKey.lastIndexOf(".") + 1, taxCodeKey.length());
            HashMap<String, String> keyMap = new HashMap<String, String>(){
                {
                    this.put("taxDetailLineKey", taxDetailLineKey);
                    this.put("taxDetailLineTaxTypeKey", taxDetailLineTaxTypeKey);
                    this.put("taxDetailLineTaxCodeKey", taxDetailLineTaxCodeKey);
                }
            };
            String taxResults = "";
            try {
                int count;
                lineVoList.addAll(this.taxLineService.service(dos, billKey, taxBillEntry, taxLineLogService, (Map)keyMap, 0));
                taxResults = ObjectUtils.isEmpty(lineVoList) ? "fail" : ((count = (int)lineVoList.stream().filter(taxAmountLineVo -> null != taxAmountLineVo.getTaxAmount()).count()) == lineVoList.size() ? "allSucc" : "fail");
                try {
                    taxLineLogService.saveTaxLineLog(dos, taxLineLogService.getLogs(), taxResults);
                }
                catch (Exception e) {
                    logger.error("taxLineLogService save exception", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("tax-BillTaxLineServiceImpl partService exception", (Throwable)e);
            }
            logger.info("tax-BillTaxLineServiceImpl partService result " + JsonUtil.toJson(lineVoList));
            return JsonUtil.toJson(lineVoList);
        }
        logger.error("tax-BillTaxLineServiceImpl partService BillRegisterService no config!");
        return JsonUtil.toJson(new ArrayList());
    }
}

