/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.taxrule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.taxc.vo.TaxMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMaterialLineDto;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogService;
import kd.taxc.bdtaxr.common.refactor.tax.service.BillRegisterService;
import kd.taxc.bdtaxr.common.refactor.tax.service.BusinessScenarioService;
import kd.taxc.bdtaxr.common.refactor.tax.service.CollectDataService;
import kd.taxc.bdtaxr.common.refactor.tax.service.FourPService;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxRuleService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.BillRegisterServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.BusinessScenarioServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.CollectDataServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.FourPServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.SpecificServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxRuleServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLogUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillRegisterVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.mservice.api.taxrule.BillTaxService;

public class BillTaxServiceImpl
implements BillTaxService {
    private static Log logger = LogFactory.getLog(BillTaxServiceImpl.class);
    private CollectDataService collectDataService = new CollectDataServiceImpl();
    private BusinessScenarioService businessScenarioService = new BusinessScenarioServiceImpl();
    private FourPService fourPService = new FourPServiceImpl();
    private TaxRuleService taxRuleService = new TaxRuleServiceImpl();
    private BillRegisterService billRegisterService = new BillRegisterServiceImpl();

    @Override
    public String service(String currentBillKey, String billKey, long billId, String entrySourceKey, String billEntryKey, final DynamicObject dos) {
        logger.info("tax-BillTaxServiceImpl: \u5f00\u59cb\u8c03\u7528\u63a5\u53e3");
        BillRegisterVo billRegisterVo = this.billRegisterService.getBillParams(currentBillKey, "billTaxService", "service", dos);
        if (null != billRegisterVo) {
            logger.info("tax-BillTaxServiceImpl params:" + billRegisterVo.toString());
            TaxLogService taxLogService = new TaxLogService(TaxLogUtils.isCloseWriteLog((String)"uselog"));
            long orgId = billRegisterVo.getOrgId();
            long country = billRegisterVo.getCountry();
            Date date = billRegisterVo.getDate();
            String taxBillEntryKey = billRegisterVo.getTaxbillentrykey();
            String taxcodeProperty = billRegisterVo.getVat();
            DynamicObjectCollection taxBillEntrys = dos.getDynamicObjectCollection(taxBillEntryKey);
            ArrayList<TaxMaterialLineVo> materialLineVoList = new ArrayList<TaxMaterialLineVo>(taxBillEntrys.size());
            LinkedHashMap taxcodeLineLog = new LinkedHashMap(taxBillEntrys.size());
            String taxResults = "";
            try {
                Map sourceData = this.collectDataService.service(billKey, billId);
                BillTaxVo billTaxVo = new BillTaxVo(orgId, country, date, billKey, billId, taxBillEntryKey, entrySourceKey, billEntryKey, dos, sourceData, taxcodeProperty, currentBillKey, taxLogService);
                taxLogService.collectBillTaxVo(billTaxVo);
                HashMap<String, Object> callBillMap = new HashMap<String, Object>(){
                    {
                        this.put("billid", dos.getLong("id"));
                        this.put("billno", dos.getString("billno"));
                        this.put("billlname", dos.getDataEntityType().getName());
                    }
                };
                taxLogService.collectCallBillMap((Map)callBillMap);
                for (int i = 0; i < taxBillEntrys.size(); ++i) {
                    TaxMaterialLineVo taxMaterialLineVo = new TaxMaterialLineVo();
                    taxLogService.getMaterialLineDtos().add(new TaxLogMaterialLineDto(TaxLogUtils.isCloseWriteLog((String)"uselog")));
                    List taxLineVos = new ArrayList();
                    DynamicObject taxBillEntry = (DynamicObject)taxBillEntrys.get(i);
                    billTaxVo.setTaxBillEntry(taxBillEntry);
                    billTaxVo.getLogger().addLog(billTaxVo.toString());
                    billTaxVo.getLogger().addSourceData(sourceData);
                    billTaxVo.getLogger().addTaxBillEntry(taxBillEntry, i + 1);
                    DynamicObject businessScenario = this.businessScenarioService.service(billTaxVo);
                    billTaxVo.getLogger().addBusinessScenario(businessScenario);
                    billTaxVo.getTaxLogMaterialLineDto().collectLastBillTaxConfig(businessScenario);
                    if (null != businessScenario) {
                        List fourP = this.fourPService.service(billTaxVo, businessScenario, taxBillEntry);
                        billTaxVo.getLogger().addFourP(fourP);
                        billTaxVo.getTaxLogMaterialLineDto().collectFourP(fourP);
                        taxLineVos = this.taxRuleService.service(billTaxVo, fourP);
                        logger.info("tax-taxCodeAndRates:" + taxLineVos.stream().map(taxLineVo -> taxLineVo.getTaxCode() + "," + taxLineVo.getTaxRate()).collect(Collectors.toList()).toString());
                    }
                    taxMaterialLineVo.setTaxLineVos(taxLineVos);
                    materialLineVoList.add(taxMaterialLineVo);
                    billTaxVo.getLogger().printLog(i, taxcodeLineLog);
                }
                String specificTaxMapKey = billTaxVo.getEntityNumber() + billTaxVo.getDos().getString("id");
                if (SpecificServiceImpl.getSpecificTaxMap().containsKey(specificTaxMapKey)) {
                    SpecificServiceImpl.getSpecificfourPLogMap().remove(specificTaxMapKey);
                    SpecificServiceImpl.getSpecificTaxMap().remove(specificTaxMapKey);
                }
                taxResults = billTaxVo.getAtomicInteger().get() == taxBillEntrys.size() ? "allSucc" : (billTaxVo.getAtomicInteger().get() > 0 ? "partSucc" : "fail");
                taxLogService.collectTaxResults(taxResults);
                taxLogService.collectTaxCodeLineLog(taxcodeLineLog);
                logger.info("tax-taxValuesJson:" + SerializationUtils.toJsonString(materialLineVoList));
            }
            catch (Exception e) {
                logger.error("tax-BillTaxServiceImpl", (Throwable)e);
            }
            ThreadPoolsService.getInstance().submit((Task)taxLogService);
            return JsonUtil.toJson(materialLineVoList);
        }
        logger.error("tax-BillTaxServiceImpl BillRegisterService no config!");
        return JsonUtil.toJson(new ArrayList());
    }
}

