/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BillTaxFilterVo;

public class BillTaxConfigsUpgradeService
implements IUpgradeService {
    private static final String BILLTAXCONFIGS_DATA_UPGRADE_SUCCESS = "BilltaxConfigs Data Upgrade SUCCESS!";
    private static final String OLD_JSON = "'{\"_Type_\":%'";

    private String getOrCn() {
        return ResManager.loadKDString((String)"\u6216\u8005", (String)"BillTaxConfigsUpgradeService_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
    }

    private String getAndCn() {
        return ResManager.loadKDString((String)"\u5e76\u4e14", (String)"BillTaxConfigsUpgradeService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = BILLTAXCONFIGS_DATA_UPGRADE_SUCCESS;
        String info = BILLTAXCONFIGS_DATA_UPGRADE_SUCCESS;
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            info = log = this.getStackTraceMessage(var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        ArrayList paramList;
        StringBuilder configsSql = new StringBuilder();
        configsSql.append("select fid ,fcallconditionjson ,fcallcondition ,fcallbillkey from t_bdtaxr_billtax_configs where fcallconditionjson like ").append(OLD_JSON);
        StringBuilder productSql = new StringBuilder();
        productSql.append("select fentryid ,fproductconditionjson ,fproductcondition ,fproductsourcekey from t_bdtaxr_billtax_product  where fproductconditionjson like ").append(OLD_JSON);
        StringBuilder partySql = new StringBuilder();
        partySql.append("select fentryid ,fpartyconditionjson ,fpartycondition ,fpartysourcekey  from t_bdtaxr_billtax_party  where fpartyconditionjson like ").append(OLD_JSON);
        StringBuilder elementSql = new StringBuilder();
        elementSql.append("select fentryid ,felementconditionjson ,felementcondition ,felementsourcekey from t_bdtaxr_billtax_element where felementconditionjson like ").append(OLD_JSON);
        List configsList = DBUtils.query((String)configsSql.toString());
        List productList = DBUtils.query((String)productSql.toString());
        List partyList = DBUtils.query((String)partySql.toString());
        List elementList = DBUtils.query((String)elementSql.toString());
        if (!ObjectUtils.isEmpty((Object)configsList)) {
            paramList = new ArrayList(configsList.size());
            configsList.stream().forEach(map -> {
                Object pid = map.get("FID");
                String callBill = ObjectUtils.isEmpty(map.get("FCALLBILLKEY")) ? "" : String.valueOf(map.get("FCALLBILLKEY"));
                String callconditionJson = ObjectUtils.isEmpty(map.get("FCALLCONDITIONJSON")) ? "" : String.valueOf(map.get("FCALLCONDITIONJSON"));
                String callcondition = ObjectUtils.isEmpty(map.get("FCALLCONDITION")) ? "" : String.valueOf(map.get("FCALLCONDITION"));
                Object[] param = new Object[]{callconditionJson, callcondition, pid};
                this.updateFilterJson(callBill, callconditionJson, param);
                paramList.add(param);
            });
            DBUtils.executeBatch((String)"update t_bdtaxr_billtax_configs set fcallconditionjson = ?,fcallcondition = ? where fid = ?", paramList);
        }
        if (!ObjectUtils.isEmpty((Object)productList)) {
            paramList = new ArrayList(productList.size());
            productList.stream().forEach(map -> {
                Object pid = map.get("FENTRYID");
                String bill = ObjectUtils.isEmpty(map.get("FPRODUCTSOURCEKEY")) ? "" : String.valueOf(map.get("FPRODUCTSOURCEKEY"));
                String conditionJson = ObjectUtils.isEmpty(map.get("FPRODUCTCONDITIONJSON")) ? "" : String.valueOf(map.get("FPRODUCTCONDITIONJSON"));
                String condition = ObjectUtils.isEmpty(map.get("FPRODUCTCONDITION")) ? "" : String.valueOf(map.get("FPRODUCTCONDITION"));
                Object[] param = new Object[]{conditionJson, condition, pid};
                this.updateFilterJson(bill, conditionJson, param);
                paramList.add(param);
            });
            DBUtils.executeBatch((String)"update t_bdtaxr_billtax_product set fproductconditionjson = ?,fproductcondition = ? where fentryid = ?", paramList);
        }
        if (!ObjectUtils.isEmpty((Object)partyList)) {
            paramList = new ArrayList(partyList.size());
            partyList.stream().forEach(map -> {
                Object pid = map.get("FENTRYID");
                String bill = ObjectUtils.isEmpty(map.get("FPARTYSOURCEKEY")) ? "" : String.valueOf(map.get("FPARTYSOURCEKEY"));
                String conditionJson = ObjectUtils.isEmpty(map.get("FPARTYCONDITIONJSON")) ? "" : String.valueOf(map.get("FPARTYCONDITIONJSON"));
                String condition = ObjectUtils.isEmpty(map.get("FPARTYCONDITION")) ? "" : String.valueOf(map.get("FPARTYCONDITION"));
                Object[] param = new Object[]{conditionJson, condition, pid};
                this.updateFilterJson(bill, conditionJson, param);
                paramList.add(param);
            });
            DBUtils.executeBatch((String)"update t_bdtaxr_billtax_party set fpartyconditionjson = ?,fpartycondition = ? where fentryid = ?", paramList);
        }
        if (!ObjectUtils.isEmpty((Object)elementList)) {
            paramList = new ArrayList(elementList.size());
            elementList.stream().forEach(map -> {
                Object pid = map.get("FENTRYID");
                String bill = ObjectUtils.isEmpty(map.get("FELEMENTSOURCEKEY")) ? "" : String.valueOf(map.get("FELEMENTSOURCEKEY"));
                String conditionJson = ObjectUtils.isEmpty(map.get("FELEMENTCONDITIONJSON")) ? "" : String.valueOf(map.get("FELEMENTCONDITIONJSON"));
                String condition = ObjectUtils.isEmpty(map.get("FELEMENTCONDITION")) ? "" : String.valueOf(map.get("FELEMENTCONDITION"));
                Object[] param = new Object[]{conditionJson, condition, pid};
                this.updateFilterJson(bill, conditionJson, param);
                paramList.add(param);
            });
            DBUtils.executeBatch((String)"update t_bdtaxr_billtax_element set felementconditionjson = ?,felementcondition = ? where fentryid = ?", paramList);
        }
    }

    private void updateFilterJson(String billNumber, String conditionJson, Object[] param) {
        Map<String, FilterField> filterFields = this.getFilterFields(billNumber);
        Map<String, Map<String, Object>> entityFields = this.getEntityFields(billNumber);
        List<SimpleFilterRow> filterRows = this.getFilterRows(conditionJson);
        ArrayList<BillTaxFilterVo> filterVos = new ArrayList<BillTaxFilterVo>();
        filterRows.stream().forEach(simpleFilterRow -> {
            FilterField filterField = (FilterField)filterFields.get(simpleFilterRow.getFieldName());
            IDataEntityProperty fieldProperty = filterField.getFieldProp();
            BillTaxFilterVo filterVo = new BillTaxFilterVo();
            filterVo.setLeftBracket(simpleFilterRow.getLeftBracket());
            filterVo.setField(ObjectUtils.isEmpty(entityFields.get(filterField.getFullFieldName())) ? Long.valueOf(0L) : Long.valueOf(((Map)entityFields.get(filterField.getFullFieldName())).get("FID").toString()));
            filterVo.setFieldNumber(filterField.getFullFieldName());
            filterVo.setFieldCn(filterField.getCaption().getLocaleValue());
            Map<String, Object> conditon = this.getConditonMap().get(simpleFilterRow.getCompareType());
            filterVo.setConditon(Long.valueOf(conditon.get("id").toString()));
            filterVo.setConditonNumber(ObjectUtils.isEmpty((Object)conditon.get("number")) ? "" : String.valueOf(conditon.get("number")));
            filterVo.setConditonCn(ObjectUtils.isEmpty((Object)conditon.get("name")) ? "" : String.valueOf(conditon.get("name")));
            List<String> list = this.getValue(simpleFilterRow.getValue());
            filterVo.setValueCn(list.get(0));
            filterVo.setValue(list);
            if (!ObjectUtils.isEmpty((Object)simpleFilterRow.getBaseDataIds())) {
                this.setBasedataValue(filterField, (SimpleFilterRow)simpleFilterRow, filterVo, entityFields);
            } else if (fieldProperty instanceof ComboProp || fieldProperty instanceof BooleanProp) {
                this.setComboValue(filterField, (SimpleFilterRow)simpleFilterRow, filterVo);
            }
            filterVo.setRightBracket(simpleFilterRow.getRightBracket());
            filterVo.setLogic(simpleFilterRow.getLogic());
            filterVo.setFieldType(fieldProperty.getPropertyType().getSimpleName());
            filterVos.add(filterVo);
        });
        if (ObjectUtils.isEmpty(filterVos) || ObjectUtils.isEmpty(filterRows)) {
            param[0] = "";
        } else {
            param[0] = JsonUtil.toJson(filterVos);
            param[1] = this.getFilterDesc(filterVos);
        }
    }

    private Map<String, FilterField> getFilterFields(String entityNumber) {
        HashMap<String, FilterField> map = new HashMap<String, FilterField>();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)mainType);
        filterFields.forEach(filterField -> map.put(filterField.getFieldName(), (FilterField)filterField));
        return map;
    }

    private List<SimpleFilterRow> getFilterRows(String filterJson) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)filterJson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        return filterCondition.getFilterRow();
    }

    private Map<String, Map<String, Object>> getEntityFields(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fid,a.fbillnumber,a.fnumber,a.flongnumber,b.fname from t_bdtaxr_where_fields a,t_bdtaxr_where_fields_l b ");
        sql.append(" where a.fid = b.fid and b.flocaleid = 'zh_CN' and a.fbillnumber = ").append("'").append(entityNumber).append("'");
        List list = DBUtils.query((String)sql.toString());
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        if (!ObjectUtils.isEmpty((Object)list)) {
            list.stream().forEach(o -> map.put(String.valueOf(o.get("FNUMBER")), (Map<String, Object>)o));
        }
        return map;
    }

    private Map<String, Map<String, Object>> getConditonMap() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> equals = new HashMap<String, Object>();
        equals.put("id", 1044116180719471616L);
        equals.put("number", "=");
        equals.put("name", ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"BillTaxConfigsUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        HashMap<String, Object> not_equals = new HashMap<String, Object>();
        not_equals.put("id", 1044116964349676544L);
        not_equals.put("number", "!=");
        not_equals.put("name", ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"BillTaxConfigsUpgradeService_3", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        HashMap<String, Object> less_than = new HashMap<String, Object>();
        less_than.put("id", 1044116448886492160L);
        less_than.put("number", "<");
        less_than.put("name", ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"BillTaxConfigsUpgradeService_4", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        HashMap<String, Object> large_than = new HashMap<String, Object>();
        large_than.put("id", 1044116299065953280L);
        large_than.put("number", ">");
        large_than.put("name", ResManager.loadKDString((String)"\u5927\u4e8e", (String)"BillTaxConfigsUpgradeService_5", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        HashMap<String, Object> less_equals = new HashMap<String, Object>();
        less_equals.put("id", 1044116665413241856L);
        less_equals.put("number", "<=");
        less_equals.put("name", ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"BillTaxConfigsUpgradeService_6", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        HashMap<String, Object> large_equals = new HashMap<String, Object>();
        large_equals.put("id", 1044116561604217856L);
        large_equals.put("number", ">=");
        large_equals.put("name", ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"BillTaxConfigsUpgradeService_7", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        map.put("67", equals);
        map.put("110", equals);
        map.put("800", equals);
        map.put("105", equals);
        map.put("83", not_equals);
        map.put("114", not_equals);
        map.put("801", not_equals);
        map.put("106", not_equals);
        map.put("36", less_than);
        map.put("19", less_equals);
        map.put("813", less_equals);
        map.put("21", large_than);
        map.put("65", large_equals);
        map.put("812", large_equals);
        return map;
    }

    private List<String> getValue(List<FilterValue> filterValue) {
        List<String> value = new ArrayList<String>();
        if (!ObjectUtils.isEmpty(filterValue)) {
            value = Collections.singletonList(filterValue.get(0).getValue().toString());
        } else {
            value.add("");
        }
        return value;
    }

    private void setComboValue(FilterField filterField, SimpleFilterRow simpleFilterRow, BillTaxFilterVo filterVo) {
        List<String> values = this.getValue(simpleFilterRow.getValue());
        List list = filterField.getComboItems();
        List valueMapItems = list.stream().filter(valueMapItem -> StringUtils.equalsIgnoreCase((CharSequence)valueMapItem.getValue(), (CharSequence)((CharSequence)values.get(0)))).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(valueMapItems)) {
            filterVo.setValueCn(((ValueMapItem)valueMapItems.get(0)).getName().getLocaleValue());
        }
    }

    private void setBasedataValue(FilterField filterField, SimpleFilterRow simpleFilterRow, BillTaxFilterVo filterVo, Map<String, Map<String, Object>> entityFields) {
        filterVo.setValue(this.getValue(simpleFilterRow.getBaseDataIds()));
        String fieldNumber = filterField.getFullFieldName().substring(0, filterField.getFullFieldName().lastIndexOf(46));
        filterVo.setFieldNumber(fieldNumber);
        filterVo.setFieldCn(ObjectUtils.isEmpty(entityFields.get(fieldNumber)) ? filterVo.getFieldCn() : entityFields.get(filterField.getFullFieldName()).get("FNAME").toString());
    }

    private String getFilterDesc(List<BillTaxFilterVo> dtos) {
        StringBuilder sb = new StringBuilder();
        for (BillTaxFilterVo dto : dtos) {
            sb.append(dto.toCnString()).append(' ');
        }
        String desc = sb.toString().trim();
        if (desc.endsWith(this.getAndCn()) || desc.endsWith(this.getOrCn())) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return desc;
    }

    private String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

