/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    public static void setServiceMap(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    static {
        serviceMap.put("TemplateService", "kd.taxc.bdtaxr.business.template.impl.TemplateServiceImpl");
        serviceMap.put("FormulaService", "kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl");
        serviceMap.put("DynamicRowMSService", "kd.taxc.bdtaxr.business.template.impl.DynamicRowMSServiceImpl");
        serviceMap.put("SharingSchemeAutoSharService", "kd.taxc.bdtaxr.business.serviceImpl.sharingscheme.SharingSchemeAutoSharServiceImpl");
        serviceMap.put("TaxableListService", "kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxableListServiceImpl");
        serviceMap.put("AccrualListQueryService", "kd.taxc.bdtaxr.mservice.accrual.AccrualListQueryServiceImpl");
        serviceMap.put("DeclareService", "kd.taxc.bdtaxr.mservice.declare.DeclareServiceImpl");
        serviceMap.put("RuleCalculateService", "kd.taxc.bdtaxr.mservice.rulecalculate.RuleCalService");
        serviceMap.put("BillTaxService", "kd.taxc.bdtaxr.mservice.taxrule.BillTaxServiceImpl");
        serviceMap.put("BillTaxLineService", "kd.taxc.bdtaxr.mservice.taxrule.BillTaxLineServiceImpl");
        serviceMap.put("BillTaxLogService", "kd.taxc.bdtaxr.mservice.taxlog.BillTaxLogServiceImpl");
        serviceMap.put("DeferPayApplyService", "kd.taxc.bdtaxr.mservice.applypay.DeclarePayServiceImpl");
        serviceMap.put("RuleFilterService", "kd.taxc.bdtaxr.mservice.ruleEngine.RuleFilterServiceImpl");
        serviceMap.put("GlBalanceService", "kd.taxc.bdtaxr.mservice.ruleEngine.GlBalanceServiceImpl");
        serviceMap.put("DefaultAdvanceConfService", "kd.taxc.bdtaxr.mservice.ruleEngine.DefaultAdvanceConfServiceImpl");
        serviceMap.put("TdmBalanceFilterService", "kd.taxc.bdtaxr.mservice.ruleEngine.TdmBalanceFilterServiceImpl");
        serviceMap.put("RuleEnginService", "kd.taxc.bdtaxr.mservice.ruleEngine.RuleEnginServiceImpl");
        serviceMap.put("AssertAcceDepreEnginService", "kd.taxc.bdtaxr.mservice.ruleEngine.AssertAcceDepreEnginServiceImpl");
        serviceMap.put("BillTaxConfigsUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.BillTaxConfigsUpgradeService");
        serviceMap.put("DeferPayApplyUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.DeferPayApplyUpgradeService");
        serviceMap.put("DeferPayApplyTaxTypeUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.DeferPayApplyTaxTypeUpgradeService");
        serviceMap.put("DeclareStepsStatusService", "kd.taxc.bdtaxr.common.service.DeclareStepsStatusService");
        serviceMap.put("PayRecordUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordUpgradeService");
        serviceMap.put("PayRecordPaynoUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordPaynoUpgradeService");
        serviceMap.put("PayRecordDeferUpgradePlugin", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordDeferUpgradePlugin");
        serviceMap.put("PayRecordSbbnoUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordSbbnoUpgradeService");
        serviceMap.put("PayRecordPayDateUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordPayDateUpgradeService");
        serviceMap.put("TaxBureauDeclareService", "kd.taxc.bdtaxr.mservice.declare.TaxBureauDeclareServiceImpl");
        serviceMap.put("PayRecordDetailUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.PayRecordDetailUpgradeService");
        serviceMap.put("DeclareMainUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.DeclareMainUpgradeService");
        serviceMap.put("ArchiveService", "kd.taxc.bdtaxr.business.archive.impl.ArchiveServiceImpl");
        serviceMap.put("MultiDeclarePayApplyService", "kd.taxc.bdtaxr.mservice.applypay.MultiDeclarePayServiceImpl");
        serviceMap.put("NsrxxRemarkUpgradeService", "kd.taxc.bdtaxr.formplugin.upgradeservice.NsrxxRemarkUpgradeService");
        serviceMap.put("CustomSourceMService", "kd.taxc.bdtaxr.mservice.customsource.CustomSourceMServiceImpl");
        serviceMap.put("TaxcCombineMService", "kd.taxc.bdtaxr.mservice.combine.TaxcCombineMServiceImpl");
        serviceMap.put("DeclareReportJsxmFormulaInsertService", "kd.taxc.bdtaxr.formplugin.upgradeservice.DeclareReportJsxmFormulaInsertService");
        serviceMap.put("FinanceTaxableListUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.FinanceTaxableListUpgradeService");
        serviceMap.put("TaxableListDraftNoUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.TaxableListDraftNoUpgradeService");
        serviceMap.put("TaxCodeResultUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.TaxCodeResultUpgradeService");
        serviceMap.put("RuleFetchMainUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.RuleFetchMainUpgradeService");
        serviceMap.put("DeclareMainTableUpgradeService", "kd.taxc.bdtaxr.mservice.upgradeservice.DeclareMainTableUpgradeService");
    }
}

