/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.business.TaxcDataLoadBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxcCombineBusinessDataBusiness {
    public static TaxResult<List<DynamicObject>> loadExtentByTaxcCodeNumbers(List<String> numbers) {
        List collect;
        TaxResult<List<DynamicObject>> taxcCodeResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumbers(numbers);
        ArrayList objs = new ArrayList();
        if (taxcCodeResult != null && CollectionUtils.isNotEmpty((Collection)taxcCodeResult.getData()) && CollectionUtils.isNotEmpty(collect = taxcCodeResult.getData().stream().filter(o -> CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection("entryentity1"))).map(f -> f.getDynamicObjectCollection("entryentity1").stream().filter(d -> d.get("valuesource") != null && StringUtils.equals((CharSequence)d.getString("valuetype"), (CharSequence)"0")).collect(Collectors.toMap(s -> s.getDynamicObject("valuesource").getString("number"), s -> {
            ArrayList<Long> list = new ArrayList<Long>();
            Long valueId = StringUtils.isEmpty((CharSequence)s.getString("valueid")) ? 0L : s.getLong("valueid");
            list.add(valueId);
            return list;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }))).collect(Collectors.toList()))) {
            collect.stream().forEach(o -> {
                for (Map.Entry entry : o.entrySet()) {
                    objs.addAll(TaxcDataLoadBusiness.load((List)entry.getValue(), (String)entry.getKey()));
                }
            });
        }
        return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, objs);
    }

    public static TaxResult<Map<String, List<TaxcodeDetailDto>>> loadExtentByTaxcCodeNumbersGroupByTaxCode(List<String> numbers) {
        TaxResult<List<DynamicObject>> taxcCodeResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumbers(numbers);
        HashMap resultTaxcodeDetailDtoMap = new HashMap(16);
        HashMap resultMap = new HashMap(16);
        if (taxcCodeResult != null && CollectionUtils.isNotEmpty((Collection)taxcCodeResult.getData())) {
            HashMap taxcodeDetailMap = new HashMap(16);
            taxcCodeResult.getData().stream().filter(o -> CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection("entryentity1"))).forEach(f -> {
                Map<String, List> collect = f.getDynamicObjectCollection("entryentity1").stream().filter(d -> d.get("valuesource") != null && StringUtils.equals((CharSequence)d.getString("valuetype"), (CharSequence)"0")).collect(Collectors.toMap(s -> s.getDynamicObject("valuesource").getString("number"), s -> {
                    ArrayList<Long> list = new ArrayList<Long>();
                    Long valueId = StringUtils.isEmpty((CharSequence)s.getString("valueid")) ? 0L : s.getLong("valueid");
                    list.add(valueId);
                    return list;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
                taxcodeDetailMap.put(f.getString("number"), collect);
            });
            HashMap queryRateDataMap = new HashMap(12);
            HashMap queryMinTaxDataMap = new HashMap(12);
            if (ObjectUtils.isNotEmpty(taxcodeDetailMap)) {
                taxcodeDetailMap.entrySet().forEach(entry -> {
                    if (ObjectUtils.isNotEmpty(entry.getValue())) {
                        HashMap queryMap = new HashMap(16);
                        ((Map)entry.getValue()).entrySet().stream().forEach(o -> {
                            if (ObjectUtils.isNotEmpty(o.getKey())) {
                                if (!queryMap.containsKey(o.getKey())) {
                                    queryMap.put(o.getKey(), new ArrayList());
                                }
                                ((List)queryMap.get(o.getKey())).add(o.getValue());
                            }
                        });
                        if (ObjectUtils.isNotEmpty(queryMap)) {
                            queryMap.entrySet().stream().forEach(o -> {
                                List<DynamicObject> dynamicObjects;
                                ArrayList<Object> list = new ArrayList<Object>(12);
                                if (ObjectUtils.isNotEmpty(o.getValue())) {
                                    ((List)o.getValue()).forEach(k -> {
                                        if (ObjectUtils.isNotEmpty((Object)k)) {
                                            ((List)k).stream().forEach(s -> list.add(s));
                                        }
                                    });
                                }
                                if (ObjectUtils.isNotEmpty(dynamicObjects = TaxcDataLoadBusiness.load(list, (String)o.getKey()))) {
                                    dynamicObjects.stream().forEach(obj -> {
                                        if ("bd_taxrate".equals(o.getKey())) {
                                            queryRateDataMap.put(obj.getString("id"), obj);
                                        }
                                        if ("bd_minimumtax".equals(o.getKey())) {
                                            queryMinTaxDataMap.put(obj.getString("id"), obj);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
            if (ObjectUtils.isNotEmpty(taxcodeDetailMap)) {
                taxcodeDetailMap.entrySet().forEach(entry -> {
                    String mapkey = (String)entry.getKey();
                    if (ObjectUtils.isNotEmpty(entry.getValue())) {
                        ((Map)entry.getValue()).entrySet().stream().forEach(o -> {
                            if (!resultTaxcodeDetailDtoMap.containsKey(mapkey)) {
                                resultTaxcodeDetailDtoMap.put(mapkey, new ArrayList());
                            }
                            if (ObjectUtils.isNotEmpty(o.getValue())) {
                                if ("bd_taxrate".equals(o.getKey())) {
                                    ((List)o.getValue()).stream().forEach(m -> {
                                        if (ObjectUtils.isNotEmpty(queryRateDataMap.get(m.toString()))) {
                                            ((List)resultTaxcodeDetailDtoMap.get(mapkey)).add(queryRateDataMap.get(m.toString()));
                                        }
                                    });
                                }
                                if ("bd_minimumtax".equals(o.getKey())) {
                                    ((List)o.getValue()).stream().forEach(m -> {
                                        if (ObjectUtils.isNotEmpty(queryMinTaxDataMap.get(m.toString()))) {
                                            ((List)resultTaxcodeDetailDtoMap.get(mapkey)).add(queryMinTaxDataMap.get(m.toString()));
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
            taxcCodeResult.getData().stream().filter(o -> CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection("entryentity1"))).forEach(f -> {
                Long taxCodeId = f.getLong("id");
                String taxCodeNumber = f.getString("number");
                String taxCodeName = f.getString("name");
                DynamicObjectCollection dynamicObjectCollection = f.getDynamicObjectCollection("entryentity1");
                for (DynamicObject row : dynamicObjectCollection) {
                    if (row.get("valuesource") == null && StringUtils.equals((CharSequence)row.getString("valuetype"), (CharSequence)"0")) continue;
                    TaxcodeDetailDto taxcodeDetailDto = new TaxcodeDetailDto(taxCodeId, taxCodeNumber, taxCodeName, row.getLong("result.id"), row.getString("valuesource.id"), row.getString("valueid"), row.getString("valuenumber"));
                    taxcodeDetailDto.setResultName(row.getDataEntityType().getProperties().containsKey((Object)"name") ? row.getString("name") : "");
                    List dynamicObjects = (List)resultTaxcodeDetailDtoMap.get(taxCodeNumber);
                    if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            if (!dynamicObject.getString("id").equals(row.getString("valueid"))) continue;
                            taxcodeDetailDto.setResultObject(dynamicObject);
                            taxcodeDetailDto.setResultName(dynamicObject.getDataEntityType().getProperties().containsKey((Object)"name") ? dynamicObject.getString("name") : "");
                            taxcodeDetailDto.setTaxrateType(StringUtils.equalsIgnoreCase((CharSequence)"bd_taxrate", (CharSequence)dynamicObject.getDataEntityType().getName()) ? dynamicObject.getLong("taxratetype.id") : 0L);
                        }
                    }
                    if (!resultMap.containsKey(taxCodeNumber)) {
                        resultMap.put(taxCodeNumber, new ArrayList());
                    }
                    ((List)resultMap.get(taxCodeNumber)).add(taxcodeDetailDto);
                }
            });
        }
        return ServiceInvokeUtils.buildTaxResult(Map.class, resultMap);
    }

    public static TaxResult<List<TaxcodeDetailDto>> loadMatchTaxCodeDetailByTaxcCodeNumber(String number) {
        ArrayList<TaxcodeDetailDto> resultList = new ArrayList<TaxcodeDetailDto>();
        TaxResult<List<DynamicObject>> taxcCodeResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumbers(Collections.singletonList(number));
        ArrayList taxCodeDetailTypeObjectList = new ArrayList();
        if (taxcCodeResult != null && CollectionUtils.isNotEmpty((Collection)taxcCodeResult.getData())) {
            List collect = taxcCodeResult.getData().stream().filter(o -> CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection("entryentity1"))).map(f -> f.getDynamicObjectCollection("entryentity1").stream().filter(d -> d.get("valuesource") != null && StringUtils.equals((CharSequence)d.getString("valuetype"), (CharSequence)"0")).collect(Collectors.toMap(s -> s.getDynamicObject("valuesource").getString("number"), s -> {
                ArrayList<Long> list = new ArrayList<Long>();
                Long valueId = StringUtils.isEmpty((CharSequence)s.getString("valueid")) ? 0L : s.getLong("valueid");
                list.add(valueId);
                return list;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                collect.stream().forEach(o -> {
                    for (Map.Entry entry : o.entrySet()) {
                        taxCodeDetailTypeObjectList.addAll(TaxcDataLoadBusiness.load((List)entry.getValue(), (String)entry.getKey()));
                    }
                });
            }
            List<DynamicObject> list = taxcCodeResult.getData();
            if (ObjectUtils.isNotEmpty(taxCodeDetailTypeObjectList)) {
                DynamicObject taxCodeObject = list.get(0);
                Long taxCodeId = taxCodeObject.getLong("id");
                String taxCodeNumber = taxCodeObject.getString("number");
                String taxCodeName = taxCodeObject.getString("name");
                DynamicObjectCollection collection = taxCodeObject.getDynamicObjectCollection("entryentity1");
                for (DynamicObject row : collection) {
                    TaxcodeDetailDto taxcodeDetailDto = new TaxcodeDetailDto(taxCodeId, taxCodeNumber, taxCodeName, row.getLong("result.id"), row.getString("valuesource.id"), row.getString("valueid"), row.getString("valuenumber"));
                    boolean isExist = false;
                    for (DynamicObject dynamicObject : taxCodeDetailTypeObjectList) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)dynamicObject.getString("id"), (CharSequence)row.getString("valueid"))) continue;
                        taxcodeDetailDto.setResultName(dynamicObject.getDataEntityType().getProperties().containsKey((Object)"name") ? dynamicObject.getString("name") : "");
                        taxcodeDetailDto.setResultObject(dynamicObject);
                        isExist = true;
                        taxcodeDetailDto.setTaxrateType(StringUtils.equalsIgnoreCase((CharSequence)"bd_taxrate", (CharSequence)dynamicObject.getDataEntityType().getName()) ? dynamicObject.getLong("taxratetype.id") : 0L);
                        break;
                    }
                    if (!isExist) continue;
                    resultList.add(taxcodeDetailDto);
                }
            }
        }
        return ServiceInvokeUtils.buildTaxResult(List.class, resultList);
    }
}

