/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.bd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxAtionsysDataLoadBusiness {
    public static DynamicObject loadSingleById(Long id) {
        QFilter qFilter = TaxAtionsysDataLoadBusiness.buildQfilter();
        if (id != null) {
            qFilter = qFilter.and("id", "=", (Object)id);
        }
        return BusinessDataServiceHelper.loadSingle((String)"bd_taxationsys", (String)MetadataUtil.getAllFieldString("bd_taxationsys"), (QFilter[])new QFilter[]{qFilter});
    }

    public static List<DynamicObject> loadByIds(List<Long> ids) {
        QFilter qFilter = TaxAtionsysDataLoadBusiness.buildQfilter();
        if (CollectionUtils.isNotEmpty(ids)) {
            qFilter = qFilter.and("id", "in", ids);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)MetadataUtil.getAllFieldString("bd_taxationsys"), (QFilter[])new QFilter[]{qFilter});
        return new ArrayList<DynamicObject>(Arrays.asList(load));
    }

    public static List<DynamicObject> loadByNumbers(List<String> numbers) {
        QFilter qFilter = TaxAtionsysDataLoadBusiness.buildQfilter();
        if (CollectionUtils.isNotEmpty(numbers)) {
            qFilter = qFilter.and("number", "in", numbers);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)MetadataUtil.getAllFieldString("bd_taxationsys"), (QFilter[])new QFilter[]{qFilter});
        return new ArrayList<DynamicObject>(Arrays.asList(load));
    }

    public static DynamicObject loadSingleByNumber(String numbers) {
        QFilter qFilter = TaxAtionsysDataLoadBusiness.buildQfilter();
        if (StringUtils.isNotEmpty((CharSequence)numbers)) {
            qFilter = qFilter.and("number", "=", (Object)numbers);
        }
        return BusinessDataServiceHelper.loadSingle((String)"bd_taxationsys", (String)MetadataUtil.getAllFieldString("bd_taxationsys"), (QFilter[])new QFilter[]{qFilter});
    }

    public static List<DynamicObject> loadValidTaxationsysData() {
        Date date = new Date();
        QFilter qFilter = TaxAtionsysDataLoadBusiness.buildQfilter().and("activedate", "<=", (Object)date).and(new QFilter("expdate", ">=", (Object)date).or("expdate", "is null", null));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,activedate,expdate,countryid,issystem", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (objs != null) {
            list.addAll(Arrays.asList(objs));
        }
        return list;
    }

    public static List<Long> loadValidTaxationsys() {
        List<DynamicObject> list = TaxAtionsysDataLoadBusiness.loadValidTaxationsysData();
        if (list != null && list.size() > 0) {
            return list.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Long> queryValidTaxareaIds(Long taxsysId) {
        DynamicObject taxsysDyn = TaxAtionsysDataLoadBusiness.loadSingleById(taxsysId);
        Long countryId = taxsysDyn.getDynamicObject("countryid").getLong("id");
        TaxResult<List<DynamicObject>> listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId(countryId);
        if (listTaxResult != null && !kd.bos.orm.util.CollectionUtils.isEmpty((Collection)listTaxResult.getData())) {
            return listTaxResult.getData().stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static QFilter buildQfilter() {
        return new QFilter("enable", "=", (Object)"1");
    }
}

