/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.business.changemodel.SrcBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.service.IBillLogService;
import kd.taxc.bdtaxr.common.enums.changemodel.BizValidStatusEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang3.StringUtils;

public class ChangeResumeBusiness {
    public static DynamicObject getChangeResumeBySrcBillId(Long srcbillid) {
        QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcbillid);
        QFilter qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0);
        DynamicObject changeResume = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_changeresume", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return changeResume;
    }

    public static DynamicObject getChangeResumeByXBillId(Long xbillid) {
        QFilter qFilter1 = new QFilter("xbillid", "=", (Object)xbillid);
        QFilter qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0);
        DynamicObject changeResume = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_changeresume", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return changeResume;
    }

    public static boolean existsChangeResumeByXBillId(Long xbillid) {
        QFilter qf1 = new QFilter("xbillid", "=", (Object)xbillid);
        boolean hasExist = QueryServiceHelper.exists((String)"bdtaxr_changeresume", (QFilter[])new QFilter[]{qf1});
        return hasExist;
    }

    public static DynamicObject getChangeResumeById(Long id) {
        DynamicObject changeResume = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bdtaxr_changeresume");
        return changeResume;
    }

    public static DynamicObject getChangeResumeDetailByXBillId(Long xbillid) {
        QFilter qFilter = new QFilter("xbillid", "=", (Object)xbillid);
        DynamicObject dys = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_changeresumedetail", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return dys;
    }

    public static int getCurrentChangeNumberBySrcBillId(Long srcbillid) {
        QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcbillid);
        QFilter qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bdtaxr_changeresume", (String)"currentchangenumber", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"currentchangenumber");
        return coll.size();
    }

    public static void saveChangeResume(DynamicObject[] bills) {
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(bills[0].getDataEntityType().getName());
        if (changeModel == null) {
            return;
        }
        List<Long> xBillIDs = Stream.of(bills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        DynamicObject[] xBills = CommonDataBusiness.load(xBillIDs, bills[0].getDataEntityType().getName());
        Map<Long, DynamicObject> xBillMap = Stream.of(xBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<Long> sourceBillIDs = Stream.of(xBills).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
        String srcBillEntity = xBills[0].getString("sourcebillentity");
        DynamicObject[] srcBills = CommonDataBusiness.load(sourceBillIDs, srcBillEntity);
        Map<Long, DynamicObject> srcBillMap = Stream.of(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<String, Map<String, String>> entryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        String billno = entryAndOp.get("_bill").get("number");
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        IBillLogService logService = ChangeModelBusiness.getBillLogService(changeModel);
        for (int i = 0; i < xBills.length; ++i) {
            DynamicObject bill2 = xBills[i];
            DynamicObject srcBill = srcBillMap.get(bill2.get("sourcebillid"));
            DynamicObject xBill = xBillMap.get(bill2.getLong("id"));
            if (srcBill == null || xBill == null) continue;
            long srcbillid = (Long)srcBill.getPkValue();
            String srcBillNo = srcBill.getString(billno);
            long xbillid = (Long)bill2.getPkValue();
            String xbillno = bill2.getString(billno);
            String xbillentity = bill2.getDataEntityType().getName();
            DynamicObject creator = user;
            Date biztime = bill2.getDate("changebizdate");
            String xreason = bill2.getString("changereason");
            String newVersion = SrcBillBusiness.getNewVersion(srcBill);
            MainEntityType changeResumeDetailET = MetadataServiceHelper.getDataEntityType((String)"bdtaxr_changeresumedetail");
            QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)srcbillid);
            QFilter qFilter2 = new QFilter("xbillid", "=", (Object)xbillid);
            DeleteServiceHelper.delete((String)"bdtaxr_changeresumedetail", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            DynamicObject resumeDetailDO = new DynamicObject((DynamicObjectType)changeResumeDetailET);
            resumeDetailDO.set("srcbillid", (Object)srcbillid);
            resumeDetailDO.set("srcbillno", (Object)srcBillNo);
            resumeDetailDO.set("srcbillentity", (Object)srcBillEntity);
            resumeDetailDO.set("srcbillversion", (Object)newVersion);
            resumeDetailDO.set("xbillid", (Object)xbillid);
            resumeDetailDO.set("xbillentity", (Object)xbillentity);
            resumeDetailDO.set("xbillno", (Object)xbillno);
            resumeDetailDO.set("xbiztime", (Object)biztime);
            resumeDetailDO.set("xcreator", (Object)creator);
            resumeDetailDO.set("xreason", (Object)xreason);
            resumeDetailDO.set("crdheadjson_tag", (Object)logService.getBilljson(srcBill, xBill));
            resumeDetailDO.set("crdentryjson_tag", (Object)logService.getBillEntryjson(srcBill, xBill, entryAndOp));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resumeDetailDO});
            QFilter qFilter3 = new QFilter("srcbillid", "=", (Object)srcbillid);
            QFilter qFilter4 = new QFilter("xbillid", "=", (Object)xbillid);
            QFilter qFilter5 = new QFilter("currentchangenumber", "!=", (Object)0);
            DeleteServiceHelper.delete((String)"bdtaxr_changeresume", (QFilter[])new QFilter[]{qFilter3, qFilter4, qFilter5});
            MainEntityType changeResumeET = MetadataServiceHelper.getDataEntityType((String)"bdtaxr_changeresume");
            DynamicObject currentChangeResumeDO = new DynamicObject((DynamicObjectType)changeResumeET);
            int currentChangeNumber = ChangeResumeBusiness.getCurrentChangeNumberBySrcBillId(srcbillid) + 1;
            currentChangeResumeDO.set("srcbillid", (Object)srcbillid);
            currentChangeResumeDO.set("srcbillentity", (Object)srcBillEntity);
            currentChangeResumeDO.set("srcbillno", (Object)srcBillNo);
            currentChangeResumeDO.set("srcbillversion", (Object)newVersion);
            currentChangeResumeDO.set("currentchangenumber", (Object)currentChangeNumber);
            currentChangeResumeDO.set("xvalidstatus", (Object)bill2.getString("validstatus"));
            currentChangeResumeDO.set("xbillid", (Object)xbillid);
            currentChangeResumeDO.set("xbillentity", (Object)xbillentity);
            currentChangeResumeDO.set("xbillno", (Object)xbillno);
            currentChangeResumeDO.set("xbiztime", (Object)biztime);
            currentChangeResumeDO.set("xreason", (Object)xreason);
            currentChangeResumeDO.set("xcreator", (Object)creator);
            currentChangeResumeDO.set("changemodel", changeModel.getPkValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentChangeResumeDO});
        }
        ChangeResumeBusiness.saveZeroChangeResume(xBills);
    }

    public static void saveZeroChangeResume(DynamicObject[] xBills) {
        String xBillEntity = xBills[0].getDataEntityType().getName();
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBills[0].getDataEntityType().getName());
        Map<String, Map<String, String>> entryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        String billno = entryAndOp.get("_bill").get("number");
        List<Long> sourceBillIDs = Stream.of(xBills).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
        String srcBillEntity = xBills[0].getString("sourcebillentity");
        DynamicObject[] srcBills = CommonDataBusiness.load(sourceBillIDs, srcBillEntity);
        Map<Long, DynamicObject> srcBillMap = Stream.of(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObject[] zeroXbills = XBillBusiness.getZeroXBillBySrcBillIds(sourceBillIDs, xBillEntity);
        Map<Long, DynamicObject> srcZeroMap = Stream.of(zeroXbills).collect(Collectors.toMap(k -> k.getLong("sourcebillid"), v -> v));
        for (DynamicObject xBill : xBills) {
            Long srcbillid = xBill.getLong("sourcebillid");
            DynamicObject srcBill = srcBillMap.get(srcbillid);
            if (srcBill == null || srcZeroMap.containsKey(srcbillid) || !StringUtils.isEmpty((CharSequence)srcBill.getString("version"))) continue;
            DynamicObject zeroXBill = XBillBusiness.generateXBill(srcbillid, srcBillEntity);
            zeroXBill.set("changestatus", (Object)"D");
            zeroXBill.set(billno, (Object)(srcBill.getString(billno) + "_0"));
            Object[] inDBZeroXBill = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{zeroXBill});
            if (inDBZeroXBill == null || inDBZeroXBill.length <= 0 || inDBZeroXBill[0] == null) continue;
            DynamicObject zeroXBillDO = (DynamicObject)inDBZeroXBill[0];
            MainEntityType changeResumeET = MetadataServiceHelper.getDataEntityType((String)"bdtaxr_changeresume");
            DynamicObject changeResumeDO = new DynamicObject((DynamicObjectType)changeResumeET);
            changeResumeDO.set("xbillid", zeroXBillDO.getPkValue());
            changeResumeDO.set("xbillno", (Object)zeroXBillDO.getString(billno));
            changeResumeDO.set("xvalidstatus", (Object)zeroXBillDO.getString("validstatus"));
            changeResumeDO.set("xbillentity", (Object)xBill.getDataEntityType().getName());
            changeResumeDO.set("xbiztime", (Object)xBill.getDate("changebizdate"));
            DynamicObject creator = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
            changeResumeDO.set("xcreator", (Object)creator);
            changeResumeDO.set("srcbillid", (Object)srcbillid);
            changeResumeDO.set("srcbillentity", (Object)srcBillEntity);
            changeResumeDO.set("srcbillno", (Object)srcBill.getString(billno));
            changeResumeDO.set("changemodel", changeModel.getPkValue());
            changeResumeDO.set("currentchangenumber", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{changeResumeDO});
        }
    }

    public static void volidChangeResume(List<Long> xBillIds) {
        QFilter qFilter = new QFilter("xbillid", "in", xBillIds);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bdtaxr_changeresume", (String)"id,xvalidstatus,xvaliddate,xvalider", (QFilter[])new QFilter[]{qFilter});
        DynamicObject valider = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        Date validdate = new Date(System.currentTimeMillis());
        if (!ChangeModelUtil.isNull(colls)) {
            for (DynamicObject bill : colls) {
                String xValidStatus = (String)bill.get("xvalidstatus");
                if (!xValidStatus.equals(BizValidStatusEnum.UNVALID.getValue())) continue;
                bill.set("xvalidstatus", (Object)BizValidStatusEnum.VALID.getValue());
                bill.set("xvaliddate", (Object)validdate);
                bill.set("xvalider", (Object)valider);
            }
            SaveServiceHelper.update((DynamicObject[])colls);
        }
    }

    public static void deleteChangeResume(List<Long> xBillIds) {
        QFilter qFilter = new QFilter("xbillid", "in", xBillIds);
        DeleteServiceHelper.delete((String)"bdtaxr_changeresume", (QFilter[])new QFilter[]{qFilter});
        DeleteServiceHelper.delete((String)"bdtaxr_changeresumedetail", (QFilter[])new QFilter[]{qFilter});
    }
}

