/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillTransferService;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class SrcBillBusiness {
    private static final Log logger = LogFactory.getLog(SrcBillBusiness.class);

    public static DynamicObject[] reserveSrcBill(DynamicObject[] xBills) {
        BillTransferService transferService = new BillTransferService();
        List<Long> xBillIDs = Stream.of(xBills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dbXBills = CommonDataBusiness.load(xBillIDs, xBills[0].getDataEntityType().getName());
        DynamicObject[] srcBills = transferService.reserveSrcBill(dbXBills);
        if (srcBills != null && srcBills.length > 0) {
            SaveServiceHelper.save((DynamicObject[])srcBills);
        }
        return srcBills;
    }

    public static String getNewVersion(DynamicObject srcBill) {
        String srcBillVersion = srcBill.getString("version");
        if (StringUtils.isEmpty((CharSequence)srcBillVersion)) {
            srcBillVersion = "0";
        }
        int newVersion = 1;
        try {
            newVersion = Integer.parseInt(srcBillVersion) + 1;
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return String.valueOf(newVersion);
    }

    public static void updateSrcBillStatus(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            bill.set("changestatus", (Object)BizChangeStatusEnum.CHANGING.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])bills);
    }

    public static void updateSrcBill4BizChange(DynamicObject[] xbills) {
        List<Long> sourceBillIDs = Stream.of(xbills).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
        String srcBillEntity = xbills[0].getString("sourcebillentity");
        DynamicObject[] srcBills = CommonDataBusiness.load(sourceBillIDs, srcBillEntity);
        Map<Long, DynamicObject> srcBillMap = Stream.of(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList<DynamicObject> updateSrcBills = new ArrayList<DynamicObject>(xbills.length);
        for (DynamicObject bill2 : xbills) {
            DynamicObject srcBill = srcBillMap.get(bill2.getLong("sourcebillid"));
            if (srcBill == null || BizChangeStatusEnum.CHANGING.getValue().equals(srcBill.get("changestatus"))) continue;
            srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGING.getValue());
            updateSrcBills.add(srcBill);
        }
        if (updateSrcBills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateSrcBills.toArray(new DynamicObject[updateSrcBills.size()]));
        }
    }

    public static DynamicObject[] updateSrcBill4BizDelete(DynamicObject[] xbills) {
        List<Long> sourceBillIDs = Stream.of(xbills).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
        String srcBillEntity = xbills[0].getString("sourcebillentity");
        DynamicObject[] srcBills = CommonDataBusiness.load(sourceBillIDs, srcBillEntity);
        Map<Long, DynamicObject> srcBillMap = Stream.of(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList<DynamicObject> updateSrcBills = new ArrayList<DynamicObject>(xbills.length);
        for (DynamicObject xbill : xbills) {
            DynamicObject srcBill = srcBillMap.get(xbill.getLong("sourcebillid"));
            if (srcBill == null) continue;
            if (srcBill.get("changer") == null) {
                srcBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
            } else {
                srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
            }
            updateSrcBills.add(srcBill);
        }
        if (updateSrcBills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateSrcBills.toArray(new DynamicObject[updateSrcBills.size()]));
        }
        return srcBills;
    }
}

