/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.IntegerProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.helper.ChangeModelHelper;
import kd.taxc.bdtaxr.business.changemodel.service.IBillLogService;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.pojo.ChangeResumeLogFieldInfo;
import kd.taxc.bdtaxr.common.pojo.ChangeResumeLogInfo;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class BillLogService
implements IBillLogService {
    private static final Log logger = LogFactory.getLog(BillLogService.class);
    private static final String KEY_UPDATE = "*";
    private static final String KEY_ADD = "+";
    private static final String KEY_DELETE = "-";
    private static final String KEY_EQUAL = "=";

    protected String displayFieldAlias(DynamicObject obj, String entryName, String field) {
        if (StringUtils.isNotBlank((CharSequence)entryName)) {
            return ChangeModelHelper.getEntryPropertyAlias(obj.getDataEntityType(), entryName, field);
        }
        return ChangeModelHelper.getPropertyAlias(obj.getDataEntityType(), field);
    }

    protected String displayFieldValue(DynamicObject obj, String field, Object value, DynamicProperty property) {
        return ChangeModelHelper.displayFieldValue(value, property);
    }

    @Override
    public String getBilljson(DynamicObject srcBill, DynamicObject xBill) {
        ChangeResumeLogInfo cifo = new ChangeResumeLogInfo();
        cifo.setKeyId(String.valueOf(srcBill.getPkValue()));
        cifo.setKeyName(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f", (String)"BillLogService_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        cifo.setKeyLine(null);
        String eq = KEY_EQUAL;
        String[] billfields = ChangeModelBusiness.getCanLogProperty((IDataEntityType)xBill.getDynamicObjectType());
        DynamicPropertyCollection srcEntitys = (DynamicPropertyCollection)srcBill.getDataEntityType().getProperties();
        if (!ChangeModelUtil.isNull(billfields)) {
            for (String billfield : billfields) {
                if (srcEntitys.get((Object)billfield) == null) continue;
                Object srcField = srcBill.get(billfield);
                Object newField = xBill.get(billfield);
                String caption = this.displayFieldAlias(srcBill, null, billfield);
                DynamicProperty srcdp = srcBill.getDynamicObjectType().getProperty(billfield);
                String oField = this.displayFieldValue(srcBill, billfield, srcField, srcdp);
                String nField = this.displayFieldValue(xBill, billfield, newField, srcdp);
                boolean equal = ChangeModelHelper.compareField(srcField, newField);
                ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                if (equal) {
                    logFieldInfo.setIsequals(KEY_EQUAL);
                } else {
                    eq = KEY_UPDATE;
                    logFieldInfo.setIsequals(KEY_UPDATE);
                    if (srcField instanceof BigDecimal && newField instanceof BigDecimal || srcdp instanceof IntegerProp) {
                        nField = nField + ChangeModelHelper.compareSizes(srcField, newField);
                    }
                }
                logFieldInfo.setFieldname(caption);
                logFieldInfo.setOldValue(oField);
                logFieldInfo.setNewValue(nField);
                logFieldInfo.setPropertyname(billfield);
                cifo.getLogFields().add(logFieldInfo);
            }
        }
        cifo.setKeyFlag(eq);
        return cifo.formatJson();
    }

    @Override
    public String getBillEntryjson(DynamicObject srcBill, DynamicObject xBill, Map<String, Map<String, String>> xbillEntryAndField) {
        Map<String, String[]> allChangeLogProperty = ChangeModelHelper.getAllChangeLogPropertyMap(xBill);
        if (allChangeLogProperty.size() == 0) {
            return "";
        }
        List<EntityType> entryEntities = ChangeModelHelper.getChildEntities(xBill.getDataEntityType());
        StringBuilder billEntrys = new StringBuilder();
        for (EntityType entryEntity : entryEntities) {
            String billEntry;
            String name = entryEntity.getName();
            if (xbillEntryAndField.get(name) == null) continue;
            try {
                srcBill.getDynamicObjectCollection(name);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            String[] canLogProperty = allChangeLogProperty.get(name);
            if (ChangeModelUtil.isNull(canLogProperty) || ChangeModelUtil.isNull(billEntry = this.genFormatString(srcBill, xBill, xbillEntryAndField, entryEntity, allChangeLogProperty))) continue;
            billEntrys.append(billEntry).append(',');
        }
        if (billEntrys.length() > 0) {
            return "{" + billEntrys.substring(0, billEntrys.length() - 1) + "}";
        }
        return "";
    }

    private String genFormatString(DynamicObject srcBill, DynamicObject xBill, Map<String, Map<String, String>> xBillEntryAndField, EntityType entryEntity, Map<String, String[]> allCanLogProperty) {
        if (xBill == null || entryEntity == null || ChangeModelUtil.isNull(xBillEntryAndField) || ChangeModelUtil.isNull(allCanLogProperty)) {
            return "";
        }
        String entryName = entryEntity.getName();
        Map<String, String> entryRegisterField = xBillEntryAndField.get(entryName);
        if (ChangeModelUtil.isNull(entryRegisterField)) {
            return "";
        }
        String registerEntryID = entryRegisterField.get("srcid");
        String registerChangeType = entryRegisterField.get("changetype");
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(entryName);
        String[] billEntryFields = allCanLogProperty.get(entryName);
        if (billEntryFields.length > 0 && !ChangeModelUtil.isNull(xBillEntrys)) {
            StringBuilder fieldJson = new StringBuilder();
            ChangeResumeLogInfo fieldinfo = new ChangeResumeLogInfo();
            fieldinfo.setKey_caption(entryName);
            int rows = 1;
            for (DynamicObject xBillEntry : xBillEntrys) {
                String formatJson;
                Long xBillID = xBillEntry.getLong(registerEntryID);
                String eq = KEY_EQUAL;
                ChangeResumeLogInfo cifo = new ChangeResumeLogInfo();
                cifo.setKeyId(String.valueOf(xBillID));
                cifo.setKeyName(String.valueOf(entryEntity.getDisplayName()));
                cifo.setKeyLine(String.valueOf(rows));
                ++rows;
                List<EntityType> childEntities = ChangeModelHelper.getChildEntities(xBillEntry.getDataEntityType());
                StringBuilder childField = new StringBuilder();
                String changetype = String.valueOf(xBillEntry.get(registerChangeType));
                if (BizChangeTypeEnum.ADDNEW.getValue().equals(changetype)) {
                    for (String billEntryField : billEntryFields) {
                        Object newField = xBillEntry.get(billEntryField);
                        DynamicProperty newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryField);
                        String caption = this.displayFieldAlias(xBill, entryName, billEntryField);
                        String nField = this.displayFieldValue(xBillEntry, billEntryField, newField, newdp);
                        if (newField != null) {
                            Number newBig;
                            if (newField instanceof BigDecimal) {
                                newBig = (BigDecimal)newField;
                                if (((BigDecimal)newBig).compareTo(BigDecimal.valueOf(0L)) != 0) {
                                    nField = nField + "\u2191";
                                }
                            } else if (newField instanceof Integer && ((Integer)(newBig = (Integer)newField)).compareTo(0) != 0) {
                                nField = nField + "\u2191";
                            }
                        }
                        ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                        logFieldInfo.setOldValue(null);
                        logFieldInfo.setNewValue(nField);
                        logFieldInfo.setIsequals(KEY_ADD);
                        logFieldInfo.setFieldname(caption);
                        logFieldInfo.setPropertyname(billEntryField);
                        cifo.getLogFields().add(logFieldInfo);
                    }
                    eq = KEY_ADD;
                    if (childEntities.size() > 0) {
                        for (EntityType childEntity : childEntities) {
                            String childJson;
                            String childEnName = childEntity.getName();
                            String[] canLogProperty = allCanLogProperty.get(childEnName);
                            if (ChangeModelUtil.isNull(canLogProperty) || ChangeModelUtil.isNull(childJson = this.genFormatString(null, xBillEntry, xBillEntryAndField, childEntity, allCanLogProperty))) continue;
                            childField.append(childJson).append(',');
                        }
                    }
                } else if (BizChangeTypeEnum.UPDATE.getValue().equals(changetype) || BizChangeTypeEnum.DELETE.getValue().equals(changetype)) {
                    if (srcBill == null) continue;
                    DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(entryName);
                    for (DynamicObject srcBillEntry : srcBillEntrys) {
                        Long srcBillID = (Long)srcBillEntry.getPkValue();
                        if (xBillID.longValue() != srcBillID.longValue()) continue;
                        for (String billEntryField : billEntryFields) {
                            Object srcField = srcBillEntry.get(billEntryField);
                            DynamicProperty srcdp = srcBillEntry.getDynamicObjectType().getProperty(billEntryField);
                            Object newField = xBillEntry.get(billEntryField);
                            DynamicProperty newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryField);
                            String caption = this.displayFieldAlias(xBill, entryName, billEntryField);
                            String nField = this.displayFieldValue(xBillEntry, billEntryField, newField, newdp);
                            String oField = this.displayFieldValue(srcBillEntry, billEntryField, srcField, srcdp);
                            boolean equal = ChangeModelHelper.compareField(srcField, newField);
                            ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                            if (equal) {
                                logFieldInfo.setIsequals(KEY_EQUAL);
                            } else {
                                eq = KEY_UPDATE;
                                logFieldInfo.setIsequals(KEY_UPDATE);
                                if (srcField instanceof BigDecimal && newField instanceof BigDecimal || srcdp instanceof IntegerProp && newdp instanceof IntegerProp) {
                                    nField = nField + ChangeModelHelper.compareSizes(srcField, newField);
                                }
                            }
                            logFieldInfo.setOldValue(oField);
                            logFieldInfo.setNewValue(nField);
                            logFieldInfo.setFieldname(caption);
                            logFieldInfo.setPropertyname(billEntryField);
                            if (BizChangeTypeEnum.DELETE.getValue().equals(changetype)) {
                                logFieldInfo.setNewValue(null);
                            }
                            cifo.getLogFields().add(logFieldInfo);
                        }
                        if (childEntities.size() <= 0) continue;
                        for (EntityType childEntity : childEntities) {
                            String childJson;
                            String childEnName = childEntity.getName();
                            String[] canLogProperty = allCanLogProperty.get(childEnName);
                            if (ChangeModelUtil.isNull(canLogProperty) || ChangeModelUtil.isNull(childJson = this.genFormatString(srcBillEntry, xBillEntry, xBillEntryAndField, childEntity, allCanLogProperty))) continue;
                            childField.append(childJson).append(',');
                        }
                    }
                }
                if (BizChangeTypeEnum.DELETE.getValue().equals(changetype)) {
                    eq = KEY_DELETE;
                }
                cifo.setKeyFlag(eq);
                if (childField.length() > 0) {
                    childField.deleteCharAt(childField.length() - 1);
                }
                if ((formatJson = cifo.formatJson()).length() > 0) {
                    StringBuilder cifoStrBuilder = new StringBuilder(formatJson);
                    if (childField.length() > 0) {
                        cifoStrBuilder.deleteCharAt(cifoStrBuilder.length() - 1);
                        childField = cifoStrBuilder.append(',').append((CharSequence)childField).append('}');
                    } else {
                        childField = cifoStrBuilder;
                    }
                }
                fieldJson.append((CharSequence)childField).append(',');
            }
            if (fieldJson.length() > 0) {
                fieldJson = new StringBuilder(fieldJson.substring(0, fieldJson.length() - 1));
            }
            return fieldinfo.formatJson(fieldJson.toString());
        }
        return "";
    }
}

