/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.business.changemodel.SrcBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.helper.ChangeModelHelper;
import kd.taxc.bdtaxr.business.changemodel.service.IBillTransferService;
import kd.taxc.bdtaxr.common.enums.changemodel.BillStatusEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizValidStatusEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang3.StringUtils;

public class BillTransferService
implements IBillTransferService {
    private static final Log logger = LogFactory.getLog(BillTransferService.class);

    @Override
    public DynamicObject[] generateXBill(DynamicObject[] srcBills) {
        ArrayList<DynamicObject> xBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject srcBill : srcBills) {
            DynamicObject xBill = this.generateXBill(srcBill.getLong("id"), srcBill.getDataEntityType().getName());
            if (ChangeModelUtil.isNull(xBill)) continue;
            xBills.add(xBill);
        }
        return xBills.size() == 0 ? null : xBills.toArray(new DynamicObject[xBills.size()]);
    }

    @Override
    public DynamicObject generateXBill(Long srcBillId, String srcBillEntiy) {
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4SrcBill(srcBillEntiy);
        if (changeModel == null) {
            return null;
        }
        Map<String, Map<String, String>> entryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)srcBillEntiy);
        if (srcBill == null) {
            return null;
        }
        ChangeModelBusiness.excutePluginMethod(changeModel, "beforeSrcBillChange", srcBill);
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") == null || changeModel.getDynamicObject("xbill").getPkValue() == null) {
            return null;
        }
        xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities((IDataEntityType)xBillDt);
        IDataEntityType srcBillET = srcBill.getDataEntityType();
        List<EntityType> srcBillentryEntitys = ChangeModelBusiness.getChildEntities(srcBillET);
        DynamicObject xBill = new DynamicObject((DynamicObjectType)xBillDt);
        DynamicObjectCollection mapplingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"BillTransferService_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"BillTransferService_0", (String)"taxc-bdtaxr-base");
        for (DynamicObject mapplingEntity : mapplingEntitys) {
            String targetFieldName = mapplingEntity.getString("targetfieldname");
            String sourceFieldName = mapplingEntity.getString("sourcefieldname");
            if (ChangeModelUtil.isNull(sourceFieldName)) continue;
            String[] targetItems = targetFieldName.split("\\.");
            String[] sourceItems = sourceFieldName.split("\\.");
            if (headTitle != null && headTitle.containsValue((Object)targetItems[0])) {
                this.generateXBillHead(srcBill, xBill, mapplingEntity, entryAndOp);
                continue;
            }
            if (targetItems.length != 2 || sourceItems.length != 2 || headTitle != null && headTitle.containsValue((Object)targetItems[0])) continue;
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            params.put("entryAndOp", entryAndOp);
            params.put("xBillEntryType", ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]));
            params.put("srcBillEntryType", ChangeModelHelper.getChildEntitiesByAlias(srcBillentryEntitys, sourceItems[0]));
            this.generateXBillEntry(srcBill, xBill, mapplingEntity, params);
        }
        ChangeModelBusiness.excutePluginMethod(changeModel, "afterSrcBillChange", xBill);
        return xBill;
    }

    private void generateXBillHead(DynamicObject srcBill, DynamicObject xBill, DynamicObject mapplingEntity, Map<String, Map<String, String>> entryAndOp) {
        DataEntityPropertyCollection headProps = xBill.getDynamicObjectType().getProperties();
        if (xBill.containsProperty(mapplingEntity.getString("targetfield"))) {
            xBill.set(mapplingEntity.getString("targetfield"), srcBill.get(mapplingEntity.getString("sourcefield")));
            IDataEntityProperty prop = (IDataEntityProperty)headProps.get((Object)mapplingEntity.getString("targetfield"));
            if (prop instanceof LargeTextProp) {
                xBill.set(mapplingEntity.getString("targetfield") + "_tag", srcBill.get(mapplingEntity.getString("sourcefield") + "_tag"));
            }
        }
        String billno = entryAndOp.get("_bill").get("number");
        String billstatus = entryAndOp.get("_bill").get("status");
        String newVersion = SrcBillBusiness.getNewVersion(srcBill);
        xBill.set(billno, (Object)(srcBill.get("number") + "_bg_" + newVersion));
        xBill.set(billstatus, (Object)BillStatusEnum.SAVE.getValue());
        xBill.set("changebizdate", (Object)new Date(System.currentTimeMillis()));
        xBill.set("sourcebillid", srcBill.getPkValue());
        xBill.set("sourcebillentity", (Object)srcBill.getDataEntityType().getName());
        xBill.set("sourcebillstatus", srcBill.get(billstatus));
        xBill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        xBill.set("valider", null);
        xBill.set("validdate", null);
        xBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        xBill.set("creator", (Object)currentUserDO);
        xBill.set("createtime", (Object)new Date(System.currentTimeMillis()));
        xBill.set("modifier", (Object)currentUserDO);
        xBill.set("modifytime", (Object)new Date(System.currentTimeMillis()));
        xBill.set("enable", (Object)Character.valueOf('1'));
    }

    private void generateXBillEntry(DynamicObject srcBill, DynamicObject xBill, DynamicObject mapplingEntity, Map<String, Object> params) {
        block16: {
            String entrysrcid;
            String entrychangetype;
            EntityType srcBillEntryType;
            EntityType xBillEntryType;
            block17: {
                DynamicObject xBillEntry;
                int i;
                Map entryAndOp;
                block15: {
                    entryAndOp = (Map)params.get("entryAndOp");
                    xBillEntryType = (EntityType)params.get("xBillEntryType");
                    srcBillEntryType = (EntityType)params.get("srcBillEntryType");
                    if (xBillEntryType == null || srcBillEntryType == null) {
                        return;
                    }
                    String entryTypeName = xBillEntryType.getName();
                    if (entryAndOp.get(entryTypeName) == null) {
                        return;
                    }
                    entrychangetype = (String)((Map)entryAndOp.get(xBillEntryType.getName())).get("changetype");
                    entrysrcid = (String)((Map)entryAndOp.get(xBillEntryType.getName())).get("srcid");
                    if (xBillEntryType.getClass() != EntryType.class) break block15;
                    DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(xBillEntryType.getName());
                    DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(srcBillEntryType.getName());
                    if (entryAndOp.get(xBillEntryType.getName()) == null) {
                        return;
                    }
                    if (srcBillEntrys.size() > 0 && xBillEntrys.size() == 0) {
                        for (int i2 = 0; i2 < srcBillEntrys.size(); ++i2) {
                            DynamicObject xBillEntry2 = xBillEntrys.addNew();
                            xBillEntry2.set(entrysrcid, ((DynamicObject)srcBillEntrys.get(i2)).getPkValue());
                            xBillEntry2.set(entrychangetype, (Object)BizChangeTypeEnum.UPDATE.getValue());
                        }
                    }
                    DataEntityPropertyCollection entryProps = xBillEntryType.getProperties();
                    for (int i3 = 0; i3 < srcBillEntrys.size(); ++i3) {
                        DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i3);
                        DynamicObject xBillEntry3 = (DynamicObject)xBillEntrys.get(i3);
                        if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid) || !xBillEntry3.containsProperty(mapplingEntity.getString("targetfield"))) continue;
                        xBillEntry3.set(mapplingEntity.getString("targetfield"), srcBillEntry.get(mapplingEntity.getString("sourcefield")));
                        IDataEntityProperty prop = (IDataEntityProperty)entryProps.get((Object)mapplingEntity.getString("targetfield"));
                        if (!(prop instanceof LargeTextProp)) continue;
                        xBillEntry3.set(mapplingEntity.getString("targetfield") + "_tag", srcBillEntry.get(mapplingEntity.getString("sourcefield") + "_tag"));
                    }
                    break block16;
                }
                if (xBillEntryType.getClass() != TreeEntryType.class) break block17;
                DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(xBillEntryType.getName());
                DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(srcBillEntryType.getName());
                if (entryAndOp.get(xBillEntryType.getName()) == null) {
                    return;
                }
                HashMap<Long, Long> srcMap = new HashMap<Long, Long>(srcBillEntrys.size());
                HashMap<Long, Long> pidSrcMap = new HashMap<Long, Long>(srcBillEntrys.size());
                if (srcBillEntrys.size() > 0 && xBillEntrys.size() == 0) {
                    long[] ids = DB.genLongIds((String)(xBill.getDataEntityType().getName() + "." + xBillEntryType.getName()), (int)srcBillEntrys.size());
                    int size = srcBillEntrys.size();
                    for (i = 0; i < size; ++i) {
                        xBillEntry = xBillEntrys.addNew();
                        xBillEntry.set("id", (Object)ids[i]);
                        xBillEntry.set(entrysrcid, ((DynamicObject)srcBillEntrys.get(i)).getPkValue());
                        xBillEntry.set(entrychangetype, (Object)BizChangeTypeEnum.UPDATE.getValue());
                        srcMap.put(xBillEntry.getLong(entrysrcid), xBillEntry.getLong("id"));
                        pidSrcMap.put(xBillEntry.getLong("id"), ((DynamicObject)srcBillEntrys.get(i)).getLong("pid"));
                    }
                }
                int size = xBillEntrys.size();
                for (int i4 = 0; i4 < size; ++i4) {
                    DynamicObject xBillEntry4 = (DynamicObject)xBillEntrys.get(i4);
                    Long srcpid = (Long)pidSrcMap.get(xBillEntry4.getLong("id"));
                    if (srcpid == null) continue;
                    Long pid = (Long)srcMap.get(srcpid);
                    xBillEntry4.set("pid", (Object)pid);
                }
                DataEntityPropertyCollection entryProps = xBillEntryType.getProperties();
                for (i = 0; i < srcBillEntrys.size(); ++i) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                    xBillEntry = (DynamicObject)xBillEntrys.get(i);
                    if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid) || !xBillEntry.containsProperty(mapplingEntity.getString("targetfield"))) continue;
                    xBillEntry.set(mapplingEntity.getString("targetfield"), srcBillEntry.get(mapplingEntity.getString("sourcefield")));
                    IDataEntityProperty prop = (IDataEntityProperty)entryProps.get((Object)mapplingEntity.getString("targetfield"));
                    if (!(prop instanceof LargeTextProp)) continue;
                    xBillEntry.set(mapplingEntity.getString("targetfield") + "_tag", srcBillEntry.get(mapplingEntity.getString("sourcefield") + "_tag"));
                }
                break block16;
            }
            if (xBillEntryType.getClass() != SubEntryType.class) break block16;
            DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
            DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
            for (int i = 0; i < srcBillEntrys.size(); ++i) {
                DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                DynamicObject xBillEntry = (DynamicObject)xBillEntrys.get(i);
                DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(srcBillEntryType.getName());
                DynamicObjectCollection subXBillEntrys = xBillEntry.getDynamicObjectCollection(xBillEntryType.getName());
                if (subSrcBillEntrys.size() > 0 && subXBillEntrys.size() == 0) {
                    for (int j = 0; j < subSrcBillEntrys.size(); ++j) {
                        DynamicObject subXBillEntry = subXBillEntrys.addNew();
                        subXBillEntry.set("seq", ((DynamicObject)subSrcBillEntrys.get(j)).get("seq"));
                        subXBillEntry.set(entrysrcid, ((DynamicObject)subSrcBillEntrys.get(j)).getPkValue());
                        subXBillEntry.set(entrychangetype, (Object)BizChangeTypeEnum.UPDATE.getValue());
                    }
                }
                DataEntityPropertyCollection subEntryProps = subSrcBillEntrys.getDynamicObjectType().getProperties();
                for (int j = 0; j < subSrcBillEntrys.size(); ++j) {
                    DynamicObject subSrcBillEntry = (DynamicObject)subSrcBillEntrys.get(j);
                    DynamicObject subXBillEntry = (DynamicObject)subXBillEntrys.get(j);
                    if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid) || !subXBillEntry.containsProperty(mapplingEntity.getString("targetfield"))) continue;
                    subXBillEntry.set(mapplingEntity.getString("targetfield"), subSrcBillEntry.get(mapplingEntity.getString("sourcefield")));
                    IDataEntityProperty prop = (IDataEntityProperty)subEntryProps.get((Object)mapplingEntity.getString("targetfield"));
                    if (!(prop instanceof LargeTextProp)) continue;
                    subXBillEntry.set(mapplingEntity.getString("targetfield") + "_tag", subSrcBillEntry.get(mapplingEntity.getString("sourcefield") + "_tag"));
                }
            }
        }
    }

    @Override
    public DynamicObject[] reserveSrcBill(DynamicObject[] xBills) {
        if (ChangeModelUtil.isNull(xBills)) {
            return null;
        }
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBills[0].getDataEntityType().getName());
        if (ChangeModelUtil.isNull(changeModel)) {
            return null;
        }
        Map<Long, DynamicObject> xBillMap = Stream.of(xBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<Long> sourceBillIDs = Stream.of(xBills).map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
        String srcBillEntity = xBills[0].getString("sourcebillentity");
        DynamicObject[] srcBills = CommonDataBusiness.load(sourceBillIDs, srcBillEntity);
        Map<Long, DynamicObject> srcBillMap = Stream.of(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (DynamicObject bill2 : xBills) {
            DynamicObject srcBill;
            if ((bill2 = xBillMap.get(bill2.getLong("id"))) == null || ChangeModelUtil.isNull(srcBill = srcBillMap.get(bill2.getLong("sourcebillid")))) continue;
            this.reverseHead(bill2, srcBill);
            List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities(bill2.getDataEntityType());
            for (EntityType xBillentryEntity : xBillentryEntitys) {
                if (xBillentryEntity.getClass() == EntryType.class) {
                    this.reverseEntry(changeModel, bill2, srcBill, xBillentryEntity);
                    continue;
                }
                if (xBillentryEntity.getClass() != TreeEntryType.class) continue;
                this.reverseTreeEntry(changeModel, bill2, srcBill, xBillentryEntity);
            }
        }
        return srcBills;
    }

    private void reverseHead(DynamicObject bill, DynamicObject srcBill) {
        String[] enablePropertys;
        for (String enableProperty : enablePropertys = ChangeModelBusiness.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType())) {
            Object newObject;
            Object oldObject;
            if (!srcBill.containsProperty(enableProperty) || !bill.containsProperty(enableProperty) || !ChangeModelUtil.isRealChanged(oldObject = srcBill.get(enableProperty), newObject = bill.get(enableProperty))) continue;
            srcBill.set(enableProperty, bill.get(enableProperty));
        }
        srcBill.set("version", (Object)SrcBillBusiness.getNewVersion(srcBill));
        srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
        srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
        srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
    }

    private void reverseEntry(DynamicObject changeModel, DynamicObject xbill, DynamicObject srcBill, EntityType xBillentryEntity) {
        String xBillEntryEntityKey = xBillentryEntity.getName();
        Map<String, String> xBillEntryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel).get(xBillEntryEntityKey);
        String[] enableEntryPropertys = ChangeModelBusiness.getCanWritebackProperty((IDataEntityType)xbill.getDynamicObjectType(), xBillEntryEntityKey);
        DynamicObjectCollection xBillEntrys = xbill.getDynamicObjectCollection(xBillEntryEntityKey);
        if (ChangeModelUtil.isNull(xBillEntrys) || ChangeModelUtil.isNull(enableEntryPropertys)) {
            return;
        }
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(xBillentryEntity.getName());
        Map<Long, DynamicObject> srcBillMap = srcBillEntrys.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        String entryChangeType = xBillEntryAndOp.get("changetype");
        String entrySrcId = xBillEntryAndOp.get("srcid");
        for (DynamicObject xBillEntry : xBillEntrys) {
            DynamicObject srcBillEntry;
            if (BizChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(entryChangeType))) {
                srcBillEntry = srcBillMap.get(xBillEntry.getLong(entrySrcId));
                if (srcBillEntry == null) continue;
                for (String entryProperty : enableEntryPropertys) {
                    if (!srcBillEntry.containsProperty(entryProperty) || !xBillEntry.containsProperty(entryProperty)) continue;
                    srcBillEntry.set(entryProperty, xBillEntry.get(entryProperty));
                }
                this.reverseSubEntry(changeModel, xbill, xBillEntry, srcBillEntry);
                continue;
            }
            if (BizChangeTypeEnum.DELETE.getValue().equals(xBillEntry.get(entryChangeType))) {
                srcBillEntry = srcBillMap.get(xBillEntry.getLong(entrySrcId));
                if (srcBillEntry == null) continue;
                srcBillEntrys.remove((Object)srcBillEntry);
                continue;
            }
            if (!BizChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(entryChangeType))) continue;
            srcBillEntry = srcBillEntrys.addNew();
            for (IDataEntityProperty entityProperty : srcBillEntry.getDataEntityType().getProperties()) {
                String newEntityProName = entityProperty.getName();
                if (!xBillEntry.containsProperty(newEntityProName)) continue;
                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection) && !(xBillEntry.get(newEntityProName) instanceof LinkEntryProp)) {
                    if (newEntityProName.equals(entryChangeType)) {
                        srcBillEntry.set(newEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                    } else if (srcBillEntry.containsProperty(newEntityProName) && xBillEntry.containsProperty(newEntityProName)) {
                        srcBillEntry.set(newEntityProName, xBillEntry.get(newEntityProName));
                    }
                }
                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection)) continue;
                this.reverseAddSubEntry(changeModel, xBillEntry, srcBillEntry, newEntityProName);
            }
        }
    }

    private void reverseTreeEntry(DynamicObject changeModel, DynamicObject xbill, DynamicObject srcBill, EntityType xBillentryEntity) {
        String xBillEntryEntityKey = xBillentryEntity.getName();
        Map<String, String> xBillEntryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel).get(xBillEntryEntityKey);
        String[] enableEntryPropertys = ChangeModelBusiness.getCanWritebackProperty((IDataEntityType)xbill.getDynamicObjectType(), xBillEntryEntityKey);
        DynamicObjectCollection xBillEntrys = xbill.getDynamicObjectCollection(xBillEntryEntityKey);
        if (ChangeModelUtil.isNull(xBillEntrys) || ChangeModelUtil.isNull(enableEntryPropertys) || ChangeModelUtil.isNull(xBillEntryAndOp)) {
            return;
        }
        String entryChangeType = xBillEntryAndOp.get("changetype");
        String entrySrcId = xBillEntryAndOp.get("srcid");
        DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(xBillentryEntity.getName());
        Map<Long, DynamicObject> srcBillMap = srcBillEntrys.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap<Long, Long> srcMap = new HashMap<Long, Long>(10);
        for (DynamicObject xBillEntry : xBillEntrys) {
            DynamicObject srcBillEntry;
            if (BizChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(entryChangeType))) {
                srcBillEntry = srcBillMap.get(xBillEntry.getLong(entrySrcId));
                if (srcBillEntry == null) continue;
                srcBillEntry.set("pid", (Object)xBillEntry.getLong("pid"));
                srcMap.put(xBillEntry.getLong("id"), srcBillEntry.getLong("id"));
                for (String entryProperty : enableEntryPropertys) {
                    if (!srcBillEntry.containsProperty(entryProperty) || !xBillEntry.containsProperty(entryProperty)) continue;
                    srcBillEntry.set(entryProperty, xBillEntry.get(entryProperty));
                }
                this.reverseSubEntry(changeModel, xbill, xBillEntry, srcBillEntry);
                continue;
            }
            if (BizChangeTypeEnum.DELETE.getValue().equals(xBillEntry.get(entryChangeType))) {
                srcBillEntry = srcBillMap.get(xBillEntry.getLong(entrySrcId));
                if (srcBillEntry == null) continue;
                srcBillEntrys.remove((Object)srcBillEntry);
                continue;
            }
            if (!BizChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(entryChangeType))) continue;
            srcBillEntry = srcBillEntrys.addNew();
            for (IDataEntityProperty entityProperty : srcBillEntry.getDataEntityType().getProperties()) {
                String newEntityProName = entityProperty.getName();
                if (!xBillEntry.containsProperty(newEntityProName)) continue;
                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection) && !(xBillEntry.get(newEntityProName) instanceof LinkEntryProp)) {
                    if (newEntityProName.equals(entryChangeType)) {
                        srcBillEntry.set(newEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                    } else if (srcBillEntry.containsProperty(newEntityProName)) {
                        srcBillEntry.set(newEntityProName, xBillEntry.get(newEntityProName));
                    }
                }
                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection)) continue;
                this.reverseAddSubEntry(changeModel, xBillEntry, srcBillEntry, newEntityProName);
            }
            srcBillEntry.set("pid", (Object)xBillEntry.getLong("pid"));
            srcMap.put(xBillEntry.getLong("id"), srcBillEntry.getLong("id"));
        }
        for (DynamicObject srcBillEntry : srcBillEntrys) {
            Long pid = srcBillEntry.getLong("pid");
            if (srcMap.get(pid) == null) continue;
            srcBillEntry.set("pid", srcMap.get(pid));
        }
    }

    private void reverseSubEntry(DynamicObject changeModel, DynamicObject xbill, DynamicObject xBillEntry, DynamicObject srcBillEntry) {
        for (IDataEntityProperty entityProperty : xBillEntry.getDataEntityType().getProperties()) {
            String entityProName = entityProperty.getName();
            if (!(xBillEntry.get(entityProName) instanceof DynamicObjectCollection)) continue;
            String[] subEnableEntryPropertys = ChangeModelBusiness.getCanWritebackProperty((IDataEntityType)xbill.getDynamicObjectType(), entityProName);
            Map<String, String> xBillEntryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel).get(entityProName);
            if (subEnableEntryPropertys == null || subEnableEntryPropertys.length == 0 || xBillEntryAndOp == null || xBillEntryAndOp.size() == 0) continue;
            String entryChangeType = xBillEntryAndOp.get("changetype");
            String entrySrcId = xBillEntryAndOp.get("srcid");
            DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(entityProName);
            DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(entityProName);
            Map<Long, DynamicObject> subSrcBillMap = subSrcBillEntrys.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (DynamicObject subXBillEntry : subXBillEntrys) {
                DynamicObject subSrcBillEntry;
                if (BizChangeTypeEnum.DELETE.getValue().equals(subXBillEntry.get(entryChangeType))) {
                    subSrcBillEntry = subSrcBillMap.get(subXBillEntry.getLong(entrySrcId));
                    if (subSrcBillEntry == null) continue;
                    subSrcBillEntrys.remove((Object)subSrcBillEntry);
                    continue;
                }
                if (BizChangeTypeEnum.ADDNEW.getValue().equals(subXBillEntry.get(entryChangeType))) {
                    subSrcBillEntry = subSrcBillEntrys.addNew();
                    for (IDataEntityProperty subEntityProperty : subSrcBillEntry.getDataEntityType().getProperties()) {
                        String subEntityProName = subEntityProperty.getName();
                        if (!subXBillEntry.containsProperty(subEntityProName) || subXBillEntry.get(subEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(subEntityProName) instanceof LinkEntryProp || subEntityProName.equals("id")) continue;
                        if (subEntityProName.equals(entryChangeType)) {
                            subSrcBillEntry.set(subEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                            continue;
                        }
                        if (!subSrcBillEntry.containsProperty(subEntityProName) || !subXBillEntry.containsProperty(subEntityProName)) continue;
                        subSrcBillEntry.set(subEntityProName, subXBillEntry.get(subEntityProName));
                    }
                    continue;
                }
                if (!BizChangeTypeEnum.UPDATE.getValue().equals(subXBillEntry.get(entryChangeType)) || (subSrcBillEntry = subSrcBillMap.get(subXBillEntry.getLong(entrySrcId))) == null) continue;
                for (String subEnableEntryProperty : subEnableEntryPropertys) {
                    if (!subSrcBillEntry.containsProperty(subEnableEntryProperty) || !subXBillEntry.containsProperty(subEnableEntryProperty)) continue;
                    subSrcBillEntry.set(subEnableEntryProperty, subXBillEntry.get(subEnableEntryProperty));
                }
            }
        }
    }

    private void reverseAddSubEntry(DynamicObject changeModel, DynamicObject xBillEntry, DynamicObject srcBillEntry, String newEntityProName) {
        Map<String, String> newSubFieldmap = ChangeModelBusiness.getXBillEntryAndOp(changeModel).get(newEntityProName);
        String subEntityChangeTypePro = newSubFieldmap.get("changetype");
        DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(newEntityProName);
        DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(newEntityProName);
        for (DynamicObject subXBillEntry : subXBillEntrys) {
            DynamicObject subSrcBillEntry = subSrcBillEntrys.addNew();
            for (IDataEntityProperty subEntityProperty : subSrcBillEntry.getDataEntityType().getProperties()) {
                String newSubEntityProName = subEntityProperty.getName();
                if (!subXBillEntry.containsProperty(newSubEntityProName) || subXBillEntry.get(newSubEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(newSubEntityProName) instanceof LinkEntryProp) continue;
                if (StringUtils.isNotEmpty((CharSequence)subEntityChangeTypePro) && subEntityChangeTypePro.equals(newSubEntityProName)) {
                    subSrcBillEntry.set(newSubEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                    continue;
                }
                if (!subSrcBillEntry.containsProperty(newSubEntityProName)) continue;
                subSrcBillEntry.set(newSubEntityProName, subXBillEntry.get(newSubEntityProName));
            }
        }
    }
}

