/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.comparisonmodel.service.impl;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCalculateService;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCompareService;
import kd.taxc.bdtaxr.business.comparisonmodel.task.DataCompareThreadTask;
import kd.taxc.bdtaxr.business.executor.ThreadPoolEnum;
import kd.taxc.bdtaxr.common.enums.comparisonmodel.DataCompareEnum;
import kd.taxc.bdtaxr.common.helper.TaxcThreadPoolHelper;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DataCompareService
implements IDataCompareService {
    private static Log logger = LogFactory.getLog(DataCompareService.class);
    protected DataCompareResult result = null;

    public void beforeCompare(DataCompareParams params) {
    }

    @Override
    public DataCompareResult compare(DataCompareParams params) {
        this.init(params);
        this.beforeCompare(params);
        this.doCompare(params);
        this.afterCompare(params);
        return this.result;
    }

    protected void init(DataCompareParams params) {
        this.result = new DataCompareResult();
        this.result.setSchemeId(params.getSchemeId());
    }

    protected void doCompare(DataCompareParams params) {
        try {
            if (params.isUseThread()) {
                DataCompareThreadTask task = new DataCompareThreadTask(params, this.result);
                TaxcThreadPoolHelper.submit(task, ThreadPoolEnum.TAXC_DATACOMPARE, true);
            } else {
                DataCompareConfig config = DataCompareEnum.getEnum(params.getSchemeId()).getConfig();
                IDataCalculateService calculateService = config.getCalculateService();
                List<DataCompareTaskParams> paramsList = calculateService.buildTaskParamsList(params, this.result);
                DataCompareTaskParams taskParams = null;
                int size = paramsList.size();
                for (int i = 0; i < size; ++i) {
                    taskParams = paramsList.get(i);
                    taskParams.getConfig().getCompareSubService().process(taskParams, this.result);
                }
            }
            this.doSuccess(params, this.result);
        }
        catch (Throwable e) {
            String msg = ExceptionUtils.getStackTrace((Throwable)e);
            logger.error("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareService.doCompare\u6570\u636e\u6bd4\u5bf9\u5f02\u5e38\uff1a{}", (Object)msg);
            this.doFailure(params, this.result, msg);
        }
    }

    protected void doSuccess(DataCompareParams params, DataCompareResult result) {
    }

    protected void doFailure(DataCompareParams params, DataCompareResult result, String msg) {
    }

    protected void afterCompare(DataCompareParams params) {
    }
}

