/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CustomSource {
    private Boolean ifUseKeyId = false;
    private String group;
    private String entityname;
    private String subname;
    private String type;
    private String orgtakerelation;
    private String selectKeyEntity;
    private String selectKey;
    private List<Long> selectKeyIds;
    private Boolean ischild;
    private String bblx;
    private EntityField accesslogic;
    private EntityField orgstate;
    private EntityField datastate;
    private EntityField yearstate;
    private EntityField monthstate;
    private EntityField accessmapstate;
    private Map<Long, EntityField> datasourceFields = new HashMap<Long, EntityField>(24);

    public List<Long> getSelectKeyIds() {
        return this.selectKeyIds;
    }

    public void setSelectKeyIds(List<Long> selectKeyIds) {
        this.selectKeyIds = selectKeyIds;
    }

    public EntityField getAccessmapstate() {
        return this.accessmapstate;
    }

    public void setAccessmapstate(String fieldsubname, String fieldname) {
        this.accessmapstate = new EntityField(fieldsubname, fieldname, null);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getEntityname() {
        return this.entityname;
    }

    public void setEntityname(String entityname) {
        this.entityname = entityname;
    }

    public String getSubname() {
        return this.subname;
    }

    public void setSubname(String subname) {
        this.subname = subname;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOrgtakerelation(String orgtakerelation) {
        this.orgtakerelation = orgtakerelation;
    }

    public void setIschild(Boolean ischild) {
        this.ischild = ischild;
    }

    public String getBblx() {
        return this.bblx;
    }

    public void setBblx(String bblx) {
        this.bblx = bblx;
    }

    public void setAccesslogic(String fieldsubname, String fieldname) {
        this.accesslogic = new EntityField(fieldsubname, fieldname, null);
    }

    public EntityField getOrgstate() {
        return this.orgstate;
    }

    public void setOrgstate(String fieldsubname, String fieldname) {
        this.orgstate = new EntityField(fieldsubname, fieldname, null);
    }

    public EntityField getDatastate() {
        return this.datastate;
    }

    public void setDatastate(String fieldsubname, String fieldname) {
        this.datastate = new EntityField(fieldsubname, fieldname, null);
    }

    public EntityField getYearstate() {
        return this.yearstate;
    }

    public void setYearstate(String fieldsubname, String fieldname) {
        this.yearstate = new EntityField(fieldsubname, fieldname, null);
    }

    public EntityField getMonthstate() {
        return this.monthstate;
    }

    public void setMonthstate(String fieldsubname, String fieldname) {
        this.monthstate = new EntityField(fieldsubname, fieldname, null);
    }

    public String getSelectKeyEntity() {
        return this.selectKeyEntity;
    }

    public void setSelectKeyEntity(String selectKeyEntity) {
        this.selectKeyEntity = selectKeyEntity;
    }

    public String getSelectKey() {
        return this.selectKey;
    }

    public void setSelectKey(String selectKey) {
        this.selectKey = selectKey;
    }

    public String getOrgtakerelation() {
        return this.orgtakerelation;
    }

    public Boolean getIschild() {
        return this.ischild;
    }

    public EntityField getAccesslogic() {
        return this.accesslogic;
    }

    public Boolean getIfUseKeyId() {
        return this.ifUseKeyId;
    }

    public void setIfUseKeyId(Boolean ifUseKeyId) {
        this.ifUseKeyId = ifUseKeyId;
    }

    public void initDatasourceFields(List<EntityField> list) {
        for (EntityField field : list) {
            Long id = field.getId();
            this.datasourceFields.put(id, field);
        }
    }

    public EntityField getDatasourceFieldById(Long id) {
        return this.datasourceFields.get(id);
    }

    public EntityField getFieldByAccessmapId(Long accessmapId) {
        Optional<EntityField> op = this.datasourceFields.values().stream().filter(item -> item.getAccessmapId().compareTo(accessmapId) == 0).findFirst();
        return op.isPresent() ? op.get() : null;
    }

    public Map<Long, String> getAccessmapKey(List<Long> accessmapIds) {
        HashMap<Long, String> accessmapKey = new HashMap<Long, String>(8);
        for (Long accessmapId : accessmapIds) {
            EntityField filed = this.getFieldByAccessmapId(accessmapId);
            if (filed == null) continue;
            accessmapKey.put(accessmapId, filed.getFieldname());
        }
        return accessmapKey;
    }

    public List<EntityField> getAllAccessmapFiled() {
        ArrayList<EntityField> accessmapFileds = new ArrayList<EntityField>(10);
        for (EntityField field : this.datasourceFields.values()) {
            Long accessmapId = field.getAccessmapId();
            if (accessmapId == null || accessmapId == 0L) continue;
            accessmapFileds.add(field);
        }
        return accessmapFileds;
    }

    public static class EntityField {
        private Long id;
        private String fieldsubname;
        private String fieldname;
        private Object value;
        private Long accessmapId;

        public String getFieldsubname() {
            return this.fieldsubname;
        }

        public String getFieldname() {
            return this.fieldname;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setFieldname(String fieldname) {
            this.fieldname = fieldname;
        }

        public EntityField(Object value) {
            this.value = value;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public EntityField(Long id, String fieldsubname, String fieldname) {
            this(id, fieldsubname, fieldname, null);
        }

        public EntityField(String fieldsubname, String fieldname, Object value) {
            this(null, fieldsubname, fieldname, value);
        }

        public Long getAccessmapId() {
            return this.accessmapId;
        }

        public void setAccessmapId(Long accessmapId) {
            this.accessmapId = accessmapId;
        }

        public EntityField(Long id, String fieldsubname, String fieldname, Object value) {
            this.id = id;
            this.fieldsubname = fieldsubname;
            this.fieldname = fieldname;
            this.value = value;
        }
    }
}

