/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import org.apache.commons.lang3.ObjectUtils;

public class DbQueryService {
    private static final String ENTITYKEY = "tctb_custom_datasource";
    private static final String FID = "id";

    private DbQueryService() {
    }

    public static DbQueryService getInstance() {
        return SingleDbQueryService.INSTANCE;
    }

    public CustomSource queryCustomSource(long tableId) {
        ArrayList<CustomSource.EntityField> entityFields;
        CustomSource source = new CustomSource();
        QFilter tableid = new QFilter(FID, "=", (Object)tableId);
        QFilter[] filters = new QFilter[]{tableid};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITYKEY, (String)"group,entityname,subname,type,bblx,orgtakerelation,ischild,entryentity,entryentity.fieldsubname as fieldsubname,entryentity.fieldname as fieldname,entryentity.accesslogic as accesslogic,entryentity.orgstate as orgstate,entryentity.datastate as datastate,entryentity.yearstate as yearstate,entryentity.monthstate as monthstate,entryentity.accessmap as accessmap", (QFilter[])filters);
        if (collection.size() > 0) {
            source.setGroup(((DynamicObject)collection.get(0)).getString("group"));
            source.setEntityname(((DynamicObject)collection.get(0)).getString("entityname"));
            source.setSubname(((DynamicObject)collection.get(0)).getString("subname"));
            source.setType(((DynamicObject)collection.get(0)).getString("type"));
            source.setBblx(((DynamicObject)collection.get(0)).getString("bblx"));
            source.setOrgtakerelation(((DynamicObject)collection.get(0)).getString("orgtakerelation"));
            source.setIschild(((DynamicObject)collection.get(0)).getBoolean("ischild"));
            entityFields = new ArrayList<CustomSource.EntityField>(40);
            for (DynamicObject d : collection) {
                String subname = d.getString("fieldsubname");
                String fieldname = d.getString("fieldname");
                if ("true".equals(d.getString("accesslogic"))) {
                    source.setAccesslogic(subname, fieldname);
                }
                if ("true".equals(d.getString("orgstate"))) {
                    source.setOrgstate(subname, fieldname);
                }
                if ("true".equals(d.getString("datastate"))) {
                    source.setDatastate(subname, fieldname);
                }
                if ("true".equals(d.getString("yearstate"))) {
                    source.setYearstate(subname, fieldname);
                }
                if ("true".equals(d.getString("monthstate"))) {
                    source.setMonthstate(subname, fieldname);
                }
                Long accessmapId = 0L;
                if (ObjectUtils.isNotEmpty((Object)d.getString("accessmap")) && !"0".equalsIgnoreCase(d.getString("accessmap"))) {
                    source.setAccessmapstate(subname, fieldname);
                    accessmapId = d.getLong("accessmap");
                }
                Long entryid = d.getLong("entryentity");
                CustomSource.EntityField entryField = new CustomSource.EntityField(entryid, subname, fieldname);
                entryField.setAccessmapId(accessmapId);
                entityFields.add(entryField);
            }
        } else {
            return null;
        }
        source.initDatasourceFields(entityFields);
        return source;
    }

    private static class SingleDbQueryService {
        private static DbQueryService INSTANCE = new DbQueryService();

        private SingleDbQueryService() {
        }
    }
}

