/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource;

import kd.bos.exception.KDBizException;

public class SelectKey {
    String table;
    String key;
    String alias;
    String selectKey;
    String expression;

    public SelectKey(String selectKey) {
        this.selectKey = selectKey;
        String[] arrays = selectKey.split("as");
        this.key = arrays[0].trim();
        String[] arrays1 = this.key.split("\\.");
        if (arrays1.length > 1) {
            this.table = arrays1[0];
            this.key = arrays1[1].trim();
        }
        if (arrays.length > 1) {
            this.alias = arrays[1].trim();
        }
        if (this.key.contains("(")) {
            throw new KDBizException("not support expression");
        }
    }

    public SelectKey(String key, String alias, String expression) {
        this(key, alias, expression, null);
    }

    public SelectKey(String key, String alias, String expression, String table) {
        this.key = key;
        this.alias = alias;
        this.expression = expression;
        this.table = table;
        String selectKey = key;
        if (expression != null && expression.length() > 0) {
            selectKey = expression.replace("$", key);
        }
        if (alias != null && alias.length() > 0) {
            selectKey = selectKey + " as " + alias;
        }
        this.selectKey = selectKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSelectKey() {
        return this.selectKey;
    }

    public void setSelectKey(String selectKey) {
        this.selectKey = selectKey;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }
}

