/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.impl.AbstractDataQueryService;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public abstract class AbstractSoftRelationQueryServiceImpl
extends AbstractDataQueryService {
    protected static final String KEY_MAIN = "main";
    protected static final String KEY_MAIN_ONFILEDSTYPE = "main_onfiledstype";
    protected static final String KEY_SUB = "sub";
    protected static final String KEY_SUB_ONFILEDSTYPE = "sub_onfiledstype";
    private static final String ALGO_KEY = AbstractSoftRelationQueryServiceImpl.class.getName();

    @Override
    public DataSet queryBizData(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        if (StringUtil.isEmpty((CharSequence)customSource.getSubname())) {
            throw new KDBizException("subentity is null,not support");
        }
        Map<String, String> metaMap = this.joinMetaSetting(customSource);
        String metaMain = metaMap.get(KEY_MAIN);
        String metaSub = metaMap.get(KEY_SUB);
        Map<String, QFilter> filters = this.analyseQfilter(customSource, metaMap.get(KEY_MAIN), metaMap.get(KEY_SUB), orgQFilter, dateQFilter, whereQFilter);
        QFilter mainFilter = filters.get(KEY_MAIN);
        QFilter subFilter = filters.get(KEY_SUB);
        Map<String, String> selectKeyMap = this.analyseSelectKey(customSource, metaMain, metaSub, selectKey);
        String selectkeyMain = selectKeyMap.get(KEY_MAIN);
        String selectkeySub = selectKeyMap.get(KEY_SUB);
        DataSet data = this.query(customSource, mainFilter, subFilter, selectkeyMain, selectkeySub);
        return data;
    }

    @Override
    protected BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        DataSet data = this.queryBizData(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter);
        BigDecimal sum = new BigDecimal(0);
        selectKey = this.setSelectKeyNoSum(selectKey);
        selectKey = this.setSelectKeyNoSubName(customSource, selectKey);
        while (data.hasNext()) {
            Row row = data.next();
            BigDecimal item = row.getBigDecimal(selectKey);
            sum = sum.add(item);
        }
        return sum;
    }

    protected DataSet query(CustomSource customSource, QFilter mainFilter, QFilter subFilter, String mainSelectKey, String subSelectKey) {
        Map<String, String> metaMaps = this.joinMetaSetting(customSource);
        Map<String, String> onCondition = this.joinFieldsSetting(customSource);
        String onMainFileds = onCondition.get(KEY_MAIN);
        String onSubFileds = onCondition.get(KEY_SUB);
        String metaMain = metaMaps.get(KEY_MAIN);
        String metaSub = metaMaps.get(KEY_SUB);
        DataSet main = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)metaMain, (String)mainSelectKey, (QFilter[])new QFilter[]{mainFilter}, (String)"");
        QFilter subExtFilterByMainIds = this.getSubFilterExtByMainId(customSource, main);
        DataSet sub = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)metaSub, (String)subSelectKey, (QFilter[])new QFilter[]{subFilter, subExtFilterByMainIds}, (String)"");
        String subJoinFiledsAlais = onMainFileds + "_ext";
        DataSet subExt = this.addJoinExtKey(customSource, sub, subJoinFiledsAlais);
        JoinDataSet join = main.join(subExt).on(onMainFileds, subJoinFiledsAlais);
        DataSet data = join.select(this.formateJoinSelectKeyByFildId(mainSelectKey).split(","), this.formateJoinSelectKeyByFildId(subSelectKey).split(",")).finish();
        return data;
    }

    private String formateJoinSelectKeyByFildId(String selectKey) {
        String[] array = selectKey.split(",");
        StringBuilder newSelectKey = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (newSelectKey.length() > 0) {
                newSelectKey.append(",");
            }
            String k = array[i];
            int index1 = k.indexOf("k_");
            int index2 = k.indexOf("as");
            if (index1 != -1 && index2 != -1 && index2 < index1) {
                newSelectKey.append(k.substring(index1));
                continue;
            }
            newSelectKey.append(k);
        }
        return newSelectKey.toString();
    }

    protected Map<String, QFilter> analyseQfilter(CustomSource customSource, String mainMeta, String subMeta, QFilter ... filters) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(8);
        QFilter filterMain = new QFilter("1", "=", (Object)1);
        QFilter filterSub = new QFilter("1", "=", (Object)1);
        filterMap.put(KEY_MAIN, filterMain);
        filterMap.put(KEY_SUB, filterSub);
        for (QFilter filter : filters) {
            this.dealQfilterProperty(customSource, filter);
            if (StringUtil.isEmpty((CharSequence)subMeta) || mainMeta.equals(subMeta)) {
                filterMain.and(filter);
            }
            if ("1".equalsIgnoreCase(filter.getProperty())) continue;
            if (this.isMainFilter(filter, mainMeta, subMeta)) {
                filterMain.and(filter.__copy(false));
            } else {
                filterSub.and(filter.__copy(false));
            }
            List nestList = filter.getNests(true);
            for (QFilter.QFilterNest nest : nestList) {
                QFilter nestQ = nest.getFilter().__copy(false);
                if (this.isMainFilter(nest.getFilter(), mainMeta, subMeta)) {
                    if (nest.isAnd()) {
                        filterMain.and(nestQ);
                        continue;
                    }
                    filterMain.or(nestQ);
                    continue;
                }
                if (nest.isAnd()) {
                    filterSub.and(nestQ);
                    continue;
                }
                filterSub.or(nestQ);
            }
        }
        return filterMap;
    }

    private boolean isMainFilter(QFilter filter, String mainMeta, String subMeta) {
        String property = filter.getProperty();
        String[] pArray = property.split("\\.");
        if (pArray.length > 1) {
            property = pArray[0];
        }
        if ("1".equalsIgnoreCase(property)) {
            return false;
        }
        if (this.containProperty(mainMeta, property)) {
            return true;
        }
        if (this.containProperty(subMeta, property)) {
            return false;
        }
        throw new KDBizException("filter properties is not in maintable or subtable:" + filter.getProperty());
    }

    protected Map<String, String> analyseSelectKey(CustomSource customSource, String mainMeta, String subMeta, String selectKey) {
        Map<String, String> joinCondition = this.joinFieldsSetting(customSource);
        String onMainFileds = joinCondition.get(KEY_MAIN);
        String onSubFileds = joinCondition.get(KEY_SUB);
        selectKey = this.setSelectKeyNoSum(selectKey);
        selectKey = this.setSelectKeyIfNotContain(selectKey, onMainFileds);
        selectKey = this.setSelectKeyIfNotContain(selectKey, onSubFileds);
        String[] keys = selectKey.split(",");
        StringBuilder mainKeys = new StringBuilder();
        StringBuilder subKeys = new StringBuilder();
        for (String key : keys) {
            if (StringUtil.isEmpty((CharSequence)key)) continue;
            if (key.startsWith(customSource.getSubname())) {
                if (subKeys.length() > 0) {
                    subKeys.append(",");
                }
                subKeys.append(key.substring(customSource.getSubname().length() + 1));
                continue;
            }
            if (this.containProperty(mainMeta, key)) {
                if (mainKeys.length() > 0) {
                    mainKeys.append(",");
                }
                mainKeys.append(key);
                continue;
            }
            if (this.containProperty(subMeta, key)) {
                if (subKeys.length() > 0) {
                    subKeys.append(",");
                }
                subKeys.append(key);
                continue;
            }
            throw new KDBizException("selectkey not find in maintable or subtable:" + key);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_MAIN, mainKeys.toString());
        map.put(KEY_SUB, subKeys.toString());
        return map;
    }

    private boolean containProperty(String meta, String field) {
        if (field.contains(".")) {
            field = field.split("\\.")[0];
        }
        return EntityMetadataCache.getDataEntityType((String)meta).findProperty(field) != null;
    }

    protected Map<String, String> joinFieldsSetting(CustomSource customSource) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_MAIN, "id");
        map.put(KEY_MAIN_ONFILEDSTYPE, Long.class.getName());
        map.put(KEY_SUB, "sbbid");
        map.put(KEY_SUB_ONFILEDSTYPE, String.class.getName());
        return map;
    }

    abstract Map<String, String> joinMetaSetting(CustomSource var1);

    private String setSelectKeyIfNotContain(String selectKey, String checkKey) {
        if (!selectKey.contains(checkKey)) {
            selectKey = selectKey + "," + checkKey;
        }
        return selectKey;
    }

    private String setSelectKeyNoSum(String selectKey) {
        if (selectKey.trim().startsWith("sum(")) {
            return selectKey.substring(4, selectKey.length() - 1);
        }
        return selectKey;
    }

    private String setSelectKeyNoSubName(CustomSource customSource, String selectKey) {
        if (selectKey.trim().startsWith(customSource.getSubname())) {
            return selectKey.substring(customSource.getSubname().length() + 1);
        }
        return selectKey;
    }

    private QFilter getSubFilterExtByMainId(CustomSource customSource, DataSet mainData) {
        String mainJoinFileds = this.getJoinFiledsOnMain(customSource);
        String subJoinFileds = this.getJoinFiledsOnSub(customSource);
        Class mainFiledType = this.getJoinFiledsTypeOnMain(customSource);
        Class subFiledType = this.getJoinFiledsTypeOnSub(customSource);
        DataSet mainCopy = mainData.copy();
        ArrayList<Object> subJoinValues = new ArrayList<Object>(10);
        while (mainCopy.hasNext()) {
            Row row = mainCopy.next();
            Object v = row.get(mainJoinFileds);
            Object subV = this.caseValue(mainFiledType, subFiledType, v);
            subJoinValues.add(subV);
        }
        QFilter filter = new QFilter(subJoinFileds, "in", subJoinValues);
        return filter;
    }

    private Object caseValue(Class fromClazz, Class toClazz, Object fromValue) {
        if (fromClazz == toClazz) {
            return fromValue;
        }
        if (Long.class == fromClazz && String.class == toClazz) {
            Long v = (Long)fromValue;
            return v + "";
        }
        throw new KDBizException("cast erro:type not support");
    }

    private DataSet addJoinExtKey(CustomSource customSource, DataSet subData, String joinFiledsAlias) {
        Class subFiledType;
        String mainJoinFileds = this.getJoinFiledsOnMain(customSource);
        String subJoinFileds = this.getJoinFiledsOnSub(customSource);
        Class mainFiledType = this.getJoinFiledsTypeOnMain(customSource);
        if (mainFiledType == (subFiledType = this.getJoinFiledsTypeOnSub(customSource))) {
            subData.addField(subJoinFileds, joinFiledsAlias);
        }
        if (Long.class == mainFiledType && String.class == subFiledType) {
            String str = "cast(" + subJoinFileds + " as Long)";
            DataSet ext = subData.addField(str, joinFiledsAlias);
            return ext;
        }
        throw new KDBizException("cast erro:type not support");
    }

    private String getJoinFiledsOnMain(CustomSource customSource) {
        Map<String, String> joinFileds = this.joinFieldsSetting(customSource);
        return joinFileds.get(KEY_MAIN);
    }

    private String getJoinFiledsOnSub(CustomSource customSource) {
        Map<String, String> joinFileds = this.joinFieldsSetting(customSource);
        return joinFileds.get(KEY_SUB);
    }

    private Class getJoinFiledsTypeOnMain(CustomSource customSource) {
        Map<String, String> joinFileds = this.joinFieldsSetting(customSource);
        try {
            return Class.forName(joinFileds.get(KEY_MAIN_ONFILEDSTYPE));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private Class getJoinFiledsTypeOnSub(CustomSource customSource) {
        Map<String, String> joinFileds = this.joinFieldsSetting(customSource);
        try {
            return Class.forName(joinFileds.get(KEY_SUB_ONFILEDSTYPE));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getMetaMain(CustomSource customSource) {
        return this.joinMetaSetting(customSource).get(KEY_MAIN);
    }

    private String getMetaSub(CustomSource customSource) {
        return this.joinMetaSetting(customSource).get(KEY_SUB);
    }

    private String getSelectKeyOnMain(CustomSource customSource, String selectKey) {
        Map<String, String> selectKeys = this.analyseSelectKey(customSource, this.getMetaMain(customSource), this.getMetaSub(customSource), selectKey);
        return selectKeys.get(KEY_MAIN);
    }

    private String getSelectKeyOnSub(CustomSource customSource, String selectKey) {
        Map<String, String> selectKeys = this.analyseSelectKey(customSource, this.getMetaMain(customSource), this.getMetaSub(customSource), selectKey);
        return selectKeys.get(KEY_SUB);
    }

    private void dealQfilterProperty(CustomSource customSource, QFilter qFilter) {
        ArrayList<Object> list = new ArrayList<Object>(10);
        List nestQ = qFilter.getNests(true).stream().map(nest -> nest.getFilter()).collect(Collectors.toList());
        list.add(qFilter);
        list.addAll(nestQ);
        for (QFilter qFilter2 : list) {
            String subEntity;
            String property = qFilter2.getProperty();
            if (!property.startsWith(subEntity = customSource.getSubname())) continue;
            qFilter2.__setProperty(property.substring(subEntity.length() + 1));
        }
    }
}

