/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.SelectKey;
import kd.taxc.bdtaxr.business.customsource.impl.AbstractDataQueryService;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import org.apache.commons.lang3.ObjectUtils;

public class FinanceDataQueryServiceImpl
extends AbstractDataQueryService {
    @Override
    public QFilter buildWhereQfilter(CustomSource customSource, String whereFilter, Map<String, QFilter> customFilter) {
        return this.buildFilter(whereFilter, customSource.getSubname());
    }

    @Override
    public DataSet queryBizData(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        String[] split = selectKey.split(",");
        List<String> mainTableFields = Arrays.asList(MetadataUtil.getAllFieldString(customSource.getEntityname()).split(","));
        List<String> subTableFields = Arrays.asList(MetadataUtil.getAllFieldString(customSource.getSubname()).split(","));
        ArrayList<SelectKey> originMainKeys = new ArrayList<SelectKey>();
        ArrayList<SelectKey> originSubKeys = new ArrayList<SelectKey>();
        ArrayList<SelectKey> mainSelectKeys = new ArrayList<SelectKey>();
        ArrayList<SelectKey> subSelectKeys = new ArrayList<SelectKey>();
        mainSelectKeys.add(new SelectKey("id"));
        for (String itemKey : split) {
            SelectKey key = new SelectKey(itemKey);
            if (mainTableFields.contains(key.getKey())) {
                mainSelectKeys.add(key);
                originMainKeys.add(key);
            }
            if (!subTableFields.contains(key.getKey())) continue;
            subSelectKeys.add(key);
            originSubKeys.add(key);
        }
        DataSet financeMainDataSet = this.queryFinanceMainDataSet(customSource, this.getSelectKeysNoAlias(mainSelectKeys), orgQFilter, dateQFilter, whereQFilter);
        if (financeMainDataSet != null && !financeMainDataSet.isEmpty()) {
            ArrayList<String> sbbids = new ArrayList<String>();
            for (Row row : financeMainDataSet.copy()) {
                sbbids.add(row.getString("id"));
            }
            QFilter filter = new QFilter("sbbid", "in", sbbids);
            if (whereQFilter != null) {
                filter = filter.and(whereQFilter);
            }
            SelectKey mainSbbid = new SelectKey("id", "sbbid", "Cast($ as String)");
            mainSelectKeys.add(mainSbbid);
            financeMainDataSet = financeMainDataSet.select(this.getSelectKeysWithAlias(mainSelectKeys));
            SelectKey subSbbid = new SelectKey("sbbid");
            subSelectKeys.add(subSbbid);
            DataSet subDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)customSource.getSubname(), (String)this.getSelectKeysNoAlias(subSelectKeys), (QFilter[])new QFilter[]{filter}, null);
            String[] arraymain = this.getKeysArray(this.getSelectKeysWithAlias(originMainKeys));
            String[] arraysub = this.getKeysArray(this.getSelectKeysWithAlias(originSubKeys));
            financeMainDataSet = financeMainDataSet.join(subDataSet).on("sbbid", "sbbid").select(arraymain, arraysub).finish();
            return financeMainDataSet;
        }
        return null;
    }

    @Override
    public BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        DynamicObjectCollection financeMainConList = this.queryFinanceMain(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter);
        if (financeMainConList.size() > 0) {
            ArrayList<String> sbbids = new ArrayList<String>();
            for (DynamicObject dynamicObject : financeMainConList) {
                sbbids.add(dynamicObject.getString("id"));
            }
            QFilter filter = new QFilter("sbbid", "in", sbbids);
            if (whereQFilter != null) {
                filter = filter.and(whereQFilter);
            }
            return this.callOrmAggreGate(customSource.getSubname(), selectKey, new QFilter[]{filter});
        }
        return BigDecimal.ZERO;
    }

    private DynamicObjectCollection queryFinanceMain(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter maintableQ = new QFilter("maintable", "=", (Object)"tdm_finance_main");
        QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
        DynamicObjectCollection templateTypeCol = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid, maintableQ});
        QFilter typeQFilter = new QFilter("1", "=", (Object)1);
        if (ObjectUtils.isNotEmpty((Object)templateTypeCol)) {
            typeQFilter = new QFilter("type", "=", ((DynamicObject)templateTypeCol.get(0)).get("id"));
        }
        return QueryServiceHelper.query((String)customSource.getEntityname(), (String)"id", (QFilter[])new QFilter[]{orgQFilter, dateQFilter, typeQFilter});
    }

    private DataSet queryFinanceMainDataSet(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter maintableQ = new QFilter("maintable", "=", (Object)"tdm_finance_main");
        QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
        DynamicObjectCollection templateTypeCol = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid, maintableQ});
        QFilter typeQFilter = new QFilter("1", "=", (Object)1);
        if (ObjectUtils.isNotEmpty((Object)templateTypeCol)) {
            typeQFilter = new QFilter("type", "=", ((DynamicObject)templateTypeCol.get(0)).get("id"));
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)customSource.getEntityname(), (String)selectKey, (QFilter[])new QFilter[]{orgQFilter, dateQFilter, typeQFilter}, null);
    }

    private String[] getKeysArray(String selectKey) {
        String[] array = selectKey == null || selectKey.length() == 0 ? new String[]{} : (selectKey.contains(",") ? selectKey.split(",") : new String[]{selectKey});
        return array;
    }

    private String getSelectKeysNoAlias(List<SelectKey> list) {
        return this.getSelectKeys(list, true, false, false);
    }

    private String getSelectKeysWithAlias(List<SelectKey> list) {
        return this.getSelectKeys(list, true, true, false);
    }

    private String getSelectKeys(List<SelectKey> list, boolean expressionFlag, boolean aliasFlag, boolean tableFlag) {
        StringBuilder sb = new StringBuilder();
        for (SelectKey item : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            String key = item.getKey();
            if (tableFlag && item.getTable() != null && item.getTable().length() > 0) {
                key = item.getTable() + "." + key;
            }
            if (expressionFlag) {
                String expression = item.getExpression();
                if (expression != null && expression.length() > 0) {
                    sb.append(item.getExpression().replace("$", item.getKey()));
                } else {
                    sb.append(key);
                }
            } else {
                sb.append(key);
            }
            if (!aliasFlag || item.getAlias() == null || item.getAlias().length() <= 0) continue;
            sb.append(" as ").append(item.getAlias());
        }
        return sb.toString();
    }
}

