/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.impl.AbstractDataQueryService;
import kd.taxc.bdtaxr.common.dto.BdAccountDto;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.json.JsonUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GlbalanceDataQueryServiceImpl
extends AbstractDataQueryService {
    private static final String EQUEAL = "67";
    private static final String NOT_EQUEAL = "83";
    private static final String IN = "17";
    private static final String NOT_IN = "34";
    private static final String START_WITH = "60";
    private static final String END_WITH = "211";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    private static final String PERCENT = "%";
    private static final Set<String> compareTypes_need_merge = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(GlbalanceDataQueryServiceImpl.EQUEAL);
            this.add(GlbalanceDataQueryServiceImpl.NOT_EQUEAL);
            this.add(GlbalanceDataQueryServiceImpl.CONTAIN);
            this.add(GlbalanceDataQueryServiceImpl.NOT_CONTAIN);
            this.add(GlbalanceDataQueryServiceImpl.START_WITH);
            this.add(GlbalanceDataQueryServiceImpl.END_WITH);
        }
    };
    private static final Set<String> compareTypes_stay_same = new HashSet<String>(){
        private static final long serialVersionUID = -8920696713364271813L;
        {
            this.add(GlbalanceDataQueryServiceImpl.IN);
            this.add(GlbalanceDataQueryServiceImpl.NOT_IN);
        }
    };
    private static final Map<String, String> beginToEndMap = new HashMap<String, String>();

    private String queryAssgrp(String conditionjson) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        List filterRow = filterCondition.getFilterRow();
        filterRow.forEach(e -> {
            if (null != e.getFieldName() && e.getFieldName().equals("assgrp")) {
                this.packageFilter((SimpleFilterRow)e, (List<String>)new ArrayList<String>(1));
            }
        });
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser1 = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap1 = ser1.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap1);
    }

    private void packageFilter(SimpleFilterRow filterRow, List<String> errors) {
        String compareType = filterRow.getCompareType();
        if (!compareTypes_need_merge.contains(compareType) && !compareTypes_stay_same.contains(compareType)) {
            return;
        }
        List content = filterRow.getValue();
        ArrayList<FilterValue> cache = new ArrayList<FilterValue>();
        HashSet<String> oldCaptionSet = new HashSet<String>();
        StringBuilder values = new StringBuilder();
        for (FilterValue filter : content) {
            String inputValue = (String)filter.getValue();
            String[] subAssgrp = inputValue.split(";");
            for (int index = 0; index < subAssgrp.length; ++index) {
                String valusSource;
                String[] assgrpAndDetail;
                values.append(subAssgrp[index]).append(";");
                if (!subAssgrp[index].contains(":") || (assgrpAndDetail = subAssgrp[index].split(":")).length != 2) continue;
                String assgrpName = assgrpAndDetail[0];
                String detailName = assgrpAndDetail[1];
                DynamicObject assgrp = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource,disprops,valuetype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)assgrpName)});
                if (null == assgrp) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"GlbalanceDataQueryServiceImpl_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection detail = null;
                String string = valusSource = assgrp.getString("valuetype").equals("2") ? "bos_assistantdata_detail" : assgrp.getString("valuesource");
                if (!StringUtils.isEmpty((CharSequence)valusSource)) {
                    QFilter qFilter = this.getFilterByDisplayproperty(assgrp.getString("disprops"), detailName);
                    try {
                        detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (null == detail || detail.size() == 0) {
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else if (qFilter.getProperty().equals("longnumber")) {
                                String[] subs = detailName.split(",");
                                if (subs.length == 2) {
                                    qFilter = new QFilter("number", "=", (Object)subs[0]);
                                    detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                } else {
                                    qFilter = new QFilter("number", "=", (Object)detailName);
                                    detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (qFilter.getProperty().equals("fullname")) {
                            qFilter = new QFilter("name", "=", (Object)detailName);
                            detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                        if (qFilter.getProperty().equals("longnumber")) {
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else {
                                qFilter = new QFilter("number", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                        }
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"GlbalanceDataQueryServiceImpl_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                        return;
                    }
                    if (null == detail || detail.size() == 0) {
                        return;
                    }
                }
                this.upDateCacheByAssgrpIds(detail, assgrp, CONTAIN, filterRow, detailName, oldCaptionSet, cache, index);
            }
        }
        if (oldCaptionSet.size() != 0) {
            for (String id : oldCaptionSet) {
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)id);
                cache.add(filterValue);
            }
            filterRow.setValue(cache);
            this.getQcp(filterRow, compareType);
        }
    }

    private QFilter getFilterByDisplayproperty(String displayproperty, String value) {
        String disprop;
        QFilter qFilter = new QFilter("fullname", "=", (Object)value);
        if (StringUtils.isEmpty((CharSequence)displayproperty)) {
            return qFilter;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)displayproperty, Map.class);
        if (null == map || null == map.get("disp") || null == ((Map)map.get("disp")).get("dispprop")) {
            return qFilter;
        }
        switch (disprop = (String)((Map)map.get("disp")).get("dispprop")) {
            case "1": {
                qFilter = new QFilter("longnumber", "=", (Object)value);
                break;
            }
            case "2": {
                qFilter = new QFilter("fullname", "=", (Object)value);
                break;
            }
            case "3": {
                String[] subs = value.split(",");
                if (subs.length != 2) break;
                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
            }
        }
        return qFilter;
    }

    private void upDateCacheByAssgrpIds(DynamicObjectCollection detail, DynamicObject assgrp, String compareType, SimpleFilterRow filterRow, String detailName, Set<String> oldCaptionSet, List<FilterValue> cache, int index) {
        DynamicObjectCollection assgrpAssists;
        String Qcp = this.getQcp(filterRow, compareType);
        switch (assgrp.getString("valuetype")) {
            case "1": 
            case "2": {
                LinkedHashMap<String, Long> queryJson = new LinkedHashMap<String, Long>();
                QFilter qFilter = null;
                if (null == detail) {
                    return;
                }
                for (DynamicObject dynamicObject : detail) {
                    queryJson.put(assgrp.getString("flexfield"), dynamicObject.getLong("id"));
                    String tempJson = this.packageQueryJson(queryJson, compareType);
                    if (null == qFilter) {
                        qFilter = new QFilter("assvals", Qcp, (Object)tempJson);
                    } else {
                        qFilter.or(new QFilter("assvals", Qcp, (Object)tempJson));
                    }
                    queryJson.clear();
                }
                String propertyName = "id,assvals";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist", (String)propertyName, (QFilter[])new QFilter[]{qFilter});
                List idList = detail.stream().map(d -> d.getString("id")).collect(Collectors.toList());
                assgrpAssists = assgrpAssists.parallelStream().filter(a -> {
                    String assvals = a.getString("assvals");
                    String[] kvArray = assvals.substring(1, assvals.length() - 1).split(",");
                    for (int i = 0; i < kvArray.length; ++i) {
                        String s = kvArray[i].split(":")[1];
                        if (!idList.contains(s)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toCollection(DynamicObjectCollection::new));
                break;
            }
            case "3": {
                QFilter nameFilter = new QFilter("asstype", Qcp, (Object)assgrp.getString("flexfield"));
                QFilter valFilter = new QFilter("assval", Qcp, (Object)detailName);
                String propertyName = "hg as id";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist_txt", (String)propertyName, (QFilter[])new QFilter[]{nameFilter, valFilter});
                break;
            }
            default: {
                return;
            }
        }
        if (null != assgrpAssists && assgrpAssists.size() != 0) {
            HashSet<String> currentIds = new HashSet<String>();
            for (DynamicObject dynamicObject : assgrpAssists) {
                currentIds.add(String.valueOf(dynamicObject.getLong("id")));
            }
            if (index > 0) {
                oldCaptionSet.retainAll(currentIds);
            } else {
                oldCaptionSet.addAll(currentIds);
            }
        }
    }

    private String getQcp(SimpleFilterRow filterRow, String compareType) {
        switch (compareType) {
            case "17": {
                return "=";
            }
            case "34": {
                return "=";
            }
            case "67": {
                return "=";
            }
            case "83": {
                return "=";
            }
            case "58": {
                filterRow.setCompareType(NOT_IN);
                return "not like";
            }
            case "59": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "60": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "211": {
                filterRow.setCompareType(IN);
                return "like";
            }
        }
        return null;
    }

    private String packageQueryJson(Map<String, Long> map, String compareType) {
        String json = JsonUtil.toJson(map);
        if (START_WITH.equals(compareType)) {
            json = json.substring(0, json.length() - 1);
            return json + PERCENT;
        }
        if (END_WITH.equals(compareType)) {
            json = json.substring(1);
            return PERCENT + json;
        }
        if (CONTAIN.equals(compareType) || NOT_CONTAIN.equals(compareType)) {
            json = json.substring(1, json.length() - 1);
            return PERCENT + json + PERCENT;
        }
        return JsonUtil.toJson(map);
    }

    @Override
    public QFilter buildWhereQfilter(CustomSource customSource, String whereFilter, Map<String, QFilter> customFilter) {
        if (StringUtils.isEmpty((CharSequence)whereFilter)) {
            return new QFilter("1", "=", (Object)1);
        }
        Object orgObject = customSource.getOrgstate().getValue();
        HashMap<String, BdAccountDto> fiBdAccounts = new HashMap<String, BdAccountDto>();
        if (orgObject instanceof List) {
            List orgList = (List)orgObject;
            orgList.forEach(row -> fiBdAccounts.putAll(GlbalanceDataQueryServiceImpl.createBdAccountDto((Long)row)));
        } else if (orgObject instanceof Long) {
            fiBdAccounts.putAll(GlbalanceDataQueryServiceImpl.createBdAccountDto((Long)orgObject));
        }
        QFilter qFilters = whereFilter.contains("assgrp") ? this.buildFilter(this.queryAssgrp(whereFilter), customSource.getEntityname()) : this.buildFilter(whereFilter, customSource.getEntityname());
        qFilters = this.parseQFilter(qFilters, fiBdAccounts);
        return qFilters;
    }

    @Override
    public DataSet queryBizData(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        Date[] dates = (Date[])customSource.getDatastate().getValue();
        String selectField = customSource.getSelectKey();
        if (selectKey.contains("begin")) {
            return this.getBeginAccountingDataSetByDate(customSource.getEntityname(), selectKey, selectField, dates[0], orgQFilter, dateQFilter, whereQFilter);
        }
        if (selectKey.contains("end")) {
            return this.getEndAccountingDataSetByDate(customSource.getEntityname(), selectKey, selectField, dates[1], orgQFilter, dateQFilter, whereQFilter);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)customSource.getEntityname(), (String)selectKey, (QFilter[])new QFilter[]{orgQFilter, dateQFilter, whereQFilter}, null);
    }

    @Override
    protected BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        customSource.getDatastate().getValue();
        Date[] dates = (Date[])customSource.getDatastate().getValue();
        String selectField = customSource.getSelectKey();
        BigDecimal fetchAmount = BigDecimal.ZERO;
        if (selectKey.contains("begin")) {
            DynamicObjectCollection col = this.getBeginAccountingByDate(customSource.getEntityname(), selectField, selectField, dates[0], orgQFilter, dateQFilter, whereQFilter);
            if (ObjectUtils.isNotEmpty((Object)col)) {
                for (DynamicObject row : col) {
                    fetchAmount = fetchAmount.add(row.getBigDecimal(selectField));
                }
            }
            return fetchAmount;
        }
        if (selectKey.contains("end")) {
            DynamicObjectCollection col = GlbalanceDataQueryServiceImpl.getEndAccountingByDate(customSource.getEntityname(), selectField, selectField, dates[1], orgQFilter, dateQFilter, whereQFilter);
            if (ObjectUtils.isNotEmpty((Object)col)) {
                for (DynamicObject row : col) {
                    fetchAmount = fetchAmount.add(row.getBigDecimal(selectField));
                }
            }
            return fetchAmount;
        }
        return super.queryBizDataSum(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter, customFilter);
    }

    private DynamicObjectCollection getBeginAccountingByDate(String entryName, String selectFieldwithid, String amountField, Date queryDate, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter[] qFilters = dateQFilter.recombine();
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        resultFilter.add(orgQFilter);
        if (ObjectUtils.isNotEmpty((Object)whereQFilter)) {
            resultFilter.add(whereQFilter);
        }
        if (null != qFilters) {
            Arrays.stream(qFilters).forEach(row -> resultFilter.add((QFilter)row));
        }
        for (QFilter qFilter : resultFilter) {
            if ("period.begindate".equals(qFilter.getProperty()) && "<=".equals(qFilter.getCP())) {
                qFilter.__setProperty("endperiod.begindate");
                qFilter.__setCP(">");
                qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
                qFilter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(qFilter.getProperty()) || !">=".equals(qFilter.getCP())) continue;
            qFilter.__setProperty("period.enddate");
            qFilter.__setCP("=");
            qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        DynamicObjectCollection currentAccountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        for (QFilter filter : resultFilter) {
            if (!"period.enddate".equals(filter.getProperty()) || !"=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setCP("<");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        selectFieldwithid = this.transformKey(amountField);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        currentAccountingList.addAll((Collection)dynamicObjectCollection);
        return currentAccountingList;
    }

    private static DynamicObjectCollection getEndAccountingByDate(String entryName, String selectFieldwithid, String amountField, Date queryDate, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter[] qFilters = dateQFilter.recombine();
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        resultFilter.add(orgQFilter);
        if (ObjectUtils.isNotEmpty((Object)whereQFilter)) {
            resultFilter.add(whereQFilter);
        }
        if (null != qFilters) {
            Arrays.stream(qFilters).forEach(row -> resultFilter.add((QFilter)row));
        }
        for (QFilter filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod.begindate");
                filter.__setCP(">");
                filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        DynamicObjectCollection accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        if (accountingList.size() > 0) {
            return accountingList;
        }
        return new DynamicObjectCollection();
    }

    private DataSet getEndAccountingDataSetByDate(String entryName, String selectFieldwithid, String amountField, Date queryDate, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter[] qFilters = dateQFilter.recombine();
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        resultFilter.add(orgQFilter);
        if (ObjectUtils.isNotEmpty((Object)whereQFilter)) {
            resultFilter.add(whereQFilter);
        }
        if (null != qFilters) {
            Arrays.stream(qFilters).forEach(row -> resultFilter.add((QFilter)row));
        }
        for (QFilter filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod.begindate");
                filter.__setCP(">");
                filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        DataSet accountingDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]), null);
        if (!accountingDataSet.isEmpty()) {
            return accountingDataSet;
        }
        return null;
    }

    private DataSet getBeginAccountingDataSetByDate(String entryName, String selectFieldwithid, String amountField, Date queryDate, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter[] qFilters = dateQFilter.recombine();
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        resultFilter.add(orgQFilter);
        if (ObjectUtils.isNotEmpty((Object)whereQFilter)) {
            resultFilter.add(whereQFilter);
        }
        if (null != qFilters) {
            Arrays.stream(qFilters).forEach(row -> resultFilter.add((QFilter)row));
        }
        for (QFilter qFilter : resultFilter) {
            if ("period.begindate".equals(qFilter.getProperty()) && "<=".equals(qFilter.getCP())) {
                qFilter.__setProperty("endperiod.begindate");
                qFilter.__setCP(">");
                qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
                qFilter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(qFilter.getProperty()) || !">=".equals(qFilter.getCP())) continue;
            qFilter.__setProperty("period.enddate");
            qFilter.__setCP("=");
            qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        DataSet currentAccountingList = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]), null);
        for (QFilter filter : resultFilter) {
            if (!"period.enddate".equals(filter.getProperty()) || !"=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setCP("<");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(queryDate));
        }
        selectFieldwithid = this.transformKey(amountField);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]), null);
        if (currentAccountingList.isEmpty()) {
            return dataSet;
        }
        return currentAccountingList.union(dataSet);
    }

    public static Map<String, BdAccountDto> createBdAccountDto(Long orgid) {
        QFilter dataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid);
        QFilter[] filters = new QFilter[]{dataFilter};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,number,longnumber,parent", (QFilter[])filters, (String)"number asc");
        List list = Arrays.stream(load).map(s -> {
            BdAccountDto vo = new BdAccountDto();
            vo.setId(s.getLong("id"));
            vo.setNumber(s.getString("number"));
            vo.setLongNumber(s.getString("longnumber"));
            vo.setParentId(Optional.ofNullable(s.getDynamicObject("parent")).map(p -> p.getLong("id")).orElseGet(() -> 0L));
            return vo;
        }).collect(Collectors.toList());
        return list.stream().map(s -> s.addChildNodes((BdAccountDto)s, list)).collect(Collectors.toMap(s -> s.getNumber(), s -> s, (k1, k2) -> k2));
    }

    private QFilter parseQFilter(QFilter filter, Map<String, BdAccountDto> fiBdAccountMaps) {
        if (filter == null) {
            return null;
        }
        QFilter result = filter;
        result = this.reBuildQFilter(result, "account.number", fiBdAccountMaps);
        return result;
    }

    private QFilter reBuildQFilter(QFilter result, String columnNumber, Map<String, BdAccountDto> fiBdAccountMaps) {
        ArrayList cps = Lists.newArrayList((Object[])new String[]{"=", "in", "IN"});
        QFilter[] recombine = result.recombine();
        ArrayList<String> booktypeNumberList = new ArrayList<String>();
        ArrayList<String> booktypeNameList = new ArrayList<String>();
        QFilter newResult = null;
        for (QFilter qFilter : recombine) {
            String property = qFilter.getProperty();
            String cp = qFilter.getCP();
            if ("booktype.number".equals(property) && cps.contains(cp)) {
                booktypeNumberList.addAll(this.getValue(qFilter.getValue()));
                continue;
            }
            if ("booktype.name".equalsIgnoreCase(property) && cps.contains(cp)) {
                booktypeNameList.addAll(this.getValue(qFilter.getValue()));
                continue;
            }
            newResult = newResult == null ? qFilter : newResult.and(qFilter);
        }
        newResult = newResult == null ? new QFilter("booktype.id", "in", this.getBookType(booktypeNumberList, booktypeNameList)) : newResult.and(new QFilter("booktype.id", "in", this.getBookType(booktypeNumberList, booktypeNameList)));
        List targetFilters = Arrays.stream(newResult.recombine()).filter(s -> cps.contains(s.getCP()) && columnNumber.equals(s.getProperty())).collect(Collectors.toList());
        for (QFilter qFilter : targetFilters) {
            ArrayList newNumbers = new ArrayList();
            for (String number : this.getValue(qFilter.getValue())) {
                Optional.ofNullable(fiBdAccountMaps.get(number)).map(s -> s.getChildNodes()).orElseGet(() -> new HashSet()).forEach(s -> newNumbers.add(s.getNumber()));
            }
            if (newNumbers.size() <= 0) continue;
            newResult = newResult.or(new QFilter(columnNumber, "in", newNumbers));
        }
        return newResult;
    }

    private List<String> getValue(Object value) {
        List<String> numbers = new ArrayList<String>();
        if (value instanceof String) {
            numbers.add(value.toString());
        } else if (value instanceof List) {
            numbers = (List)value;
        }
        return numbers;
    }

    private List<Long> getBookType(List<String> numbers, List<String> names) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (ObjectUtils.isNotEmpty(numbers)) {
            list.add(new QFilter("number", "in", numbers));
        }
        if (ObjectUtils.isNotEmpty(names)) {
            list.add(new QFilter("name", "in", names));
        }
        if (ObjectUtils.isEmpty(list)) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", (QFilter[])list.toArray(new QFilter[list.size()]));
        if (query != null && query.size() > 0) {
            return query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private String transformKey(String fieldKey) {
        String[] fieldKeys = fieldKey.split(",");
        StringBuilder targetKey = new StringBuilder();
        for (String k : fieldKeys) {
            if (targetKey.length() > 0) {
                targetKey.append(",");
            }
            targetKey.append(this.StringtransformSinglKey(k));
        }
        return targetKey.toString();
    }

    private String StringtransformSinglKey(String fieldKey) {
        String alias = null;
        String realKey = fieldKey;
        String[] arrays = fieldKey.split("as");
        if (arrays.length > 1) {
            alias = arrays[1].trim();
            realKey = arrays[0].trim();
        }
        if (!beginToEndMap.containsKey(realKey)) {
            return fieldKey;
        }
        String targetKey = beginToEndMap.get(realKey);
        String[] targetArrays = targetKey.split("as");
        if (alias != null) {
            targetKey = targetArrays[0] + " as " + alias;
        }
        return targetKey;
    }

    static {
        beginToEndMap.put("beginlocal", "endlocal as beginlocal");
        beginToEndMap.put("beginqty", "endqty as beginqty");
        beginToEndMap.put("endlocal", "endlocal");
        beginToEndMap.put("endqty", "endqty");
    }
}

