/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.impl.AbstractDataQueryService;
import kd.taxc.bdtaxr.common.enums.TableTypeMappingTemplateTypeEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.MultiQueryDataSourceServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class MultiDataQueryServiceImpl
extends AbstractDataQueryService {
    private static final String DRAFT_ENTITY = "tpo_declare_main_tsd";
    private static final String DECLARE_ENTITY = "tpo_declare_main_tsc";

    @Override
    public QFilter buildWhereQfilter(CustomSource customSource, String whereFilter, Map<String, QFilter> customFilter) {
        return this.buildFilter(whereFilter, customSource.getEntityname());
    }

    @Override
    public DataSet queryBizData(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter[] qFilterArray;
        QFilter templateTypeFilter = new QFilter("templatetype", "=", (Object)this.getTemplateType(customSource));
        Long cllumnId = 0L;
        cllumnId = customSource.getIfUseKeyId() != false ? customSource.getSelectKeyIds().get(0) : this.getColumnId(selectKey.replaceAll("\\(", "").replaceAll("\\)", ""));
        QFilter columnQFilter = new QFilter("column", "=", (Object)cllumnId);
        if (whereQFilter != null) {
            QFilter[] qFilterArray2 = new QFilter[5];
            qFilterArray2[0] = orgQFilter;
            qFilterArray2[1] = dateQFilter;
            qFilterArray2[2] = templateTypeFilter;
            qFilterArray2[3] = columnQFilter;
            qFilterArray = qFilterArray2;
            qFilterArray2[4] = whereQFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[4];
            qFilterArray3[0] = orgQFilter;
            qFilterArray3[1] = dateQFilter;
            qFilterArray3[2] = columnQFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[3] = templateTypeFilter;
        }
        QFilter[] filters = qFilterArray;
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)customSource.getEntityname(), (String)selectKey, (QFilter[])filters, null);
    }

    @Override
    protected BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        String entityName = customSource.getEntityname();
        CustomSource.EntityField orgState = customSource.getOrgstate();
        Object value = orgState.getValue();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (value instanceof Long) {
            orgIds.add((Long)value);
        } else if (value instanceof Collection) {
            orgIds.addAll((Collection)value);
        }
        CustomSource.EntityField datastate = customSource.getDatastate();
        if (datastate == null || datastate.getValue() == null || ((Date[])datastate.getValue()).length != 2) {
            return BigDecimal.ZERO;
        }
        HashMap<String, Object> requestParams = new HashMap<String, Object>(16);
        requestParams.put("orgId", orgIds);
        requestParams.put("skssqq", ((Date[])customSource.getDatastate().getValue())[0]);
        requestParams.put("skssqz", ((Date[])customSource.getDatastate().getValue())[1]);
        requestParams.put("templatetype", customSource.getBblx());
        if (StringUtil.isNumeric(selectKey)) {
            requestParams.put("selectColumnId", selectKey);
        } else {
            requestParams.put("cellNumber", selectKey);
        }
        requestParams.put("whereQFilter", whereQFilter != null ? whereQFilter.toSerializedString() : "");
        HashMap serializedDataMap = new HashMap(16);
        if (customFilter != null) {
            customFilter.forEach((k, v) -> serializedDataMap.put(k, v.toSerializedString()));
        }
        requestParams.put("customFilter", serializedDataMap);
        String requestJson = SerializationUtils.toJsonString(requestParams);
        if (DRAFT_ENTITY.equals(entityName)) {
            return MultiQueryDataSourceServiceHelper.queryDataSourceWithDraftSum(requestJson).getData();
        }
        if (DECLARE_ENTITY.equals(entityName)) {
            return MultiQueryDataSourceServiceHelper.queryDataSourceWithDeclareSum(requestJson).getData();
        }
        return super.queryBizDataSum(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter, customFilter);
    }

    private Long getColumnId(String number) {
        DynamicObject column = QueryServiceHelper.queryOne((String)"tpo_col_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return column != null ? column.getLong("id") : 0L;
    }

    private String getTemplateType(CustomSource customSource) {
        TableTypeMappingTemplateTypeEnum typeEnum = TableTypeMappingTemplateTypeEnum.getEnumByTableType(customSource.getType());
        if (null != typeEnum) {
            return typeEnum.getTemplateType();
        }
        QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
        DynamicObjectCollection typeCollection = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
        if (null == typeCollection) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u4e0d\u5b58\u5728", (String)"MultiDataQueryServiceImpl_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
        }
        if (typeCollection.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u5b58\u5728\u591a\u6761\u8bb0\u5f55", (String)"MultiDataQueryServiceImpl_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
        }
        return (String)((DynamicObject)typeCollection.get(0)).get(0);
    }
}

