/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.impl.AbstractDataQueryService;
import kd.taxc.bdtaxr.common.enums.TableTypeMappingTemplateTypeEnum;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;

public class NsrxxDataQueryServiceImpl
extends AbstractDataQueryService {
    private static final List<String> SPECAIL_LIST = Collections.singletonList("bdtaxr_pay_record");

    @Override
    public QFilter buildWhereQfilter(CustomSource customSource, String whereFilter, Map<String, QFilter> customFilter) {
        return this.buildFilter(whereFilter, customSource.getSubname());
    }

    @Override
    public DataSet queryBizData(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter) {
        QFilter nrxtype;
        boolean isCCXWS = false;
        boolean isSepcail = false;
        QFilter filter = null;
        if (null != customSource.getSubname() && "".equals(customSource.getSubname())) {
            TableTypeMappingTemplateTypeEnum typeEnum = TableTypeMappingTemplateTypeEnum.getEnumByTableType(customSource.getType());
            if (null != typeEnum) {
                isCCXWS = TableTypeMappingTemplateTypeEnum.CCXWS == typeEnum;
                isSepcail = SPECAIL_LIST.contains(customSource.getSubname().toLowerCase());
                if ("tcret_ccxws_info".equalsIgnoreCase(customSource.getSubname())) {
                    isCCXWS = false;
                }
                nrxtype = new QFilter("type", "=", (Object)typeEnum.getTemplateType());
            } else {
                QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
                DynamicObjectCollection typeCollection = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
                if (null == typeCollection) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u4e0d\u5b58\u5728", (String)"NsrxxDataQueryServiceImpl_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
                }
                if (typeCollection.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u5b58\u5728\u591a\u6761\u8bb0\u5f55", (String)"NsrxxDataQueryServiceImpl_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
                }
                nrxtype = new QFilter("type", "=", ((DynamicObject)typeCollection.get(0)).get(0));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)customSource.getBblx())) {
            nrxtype = new QFilter("type", "=", (Object)customSource.getBblx());
        } else {
            QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
            DynamicObjectCollection type = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
            nrxtype = new QFilter("type", "=", ((DynamicObject)type.get(0)).get(0));
        }
        DynamicObjectCollection fidCollection = isCCXWS || isSepcail ? QueryServiceHelper.query((String)customSource.getEntityname(), (String)"id", (QFilter[])new QFilter[]{orgQFilter, nrxtype}) : QueryServiceHelper.query((String)customSource.getEntityname(), (String)"id", (QFilter[])new QFilter[]{orgQFilter, dateQFilter, nrxtype});
        if (EmptyCheckUtils.isNotEmpty(fidCollection)) {
            ArrayList<String> sbbids = new ArrayList<String>();
            for (DynamicObject dynamicObject : fidCollection) {
                sbbids.add(dynamicObject.getString("id"));
            }
            filter = new QFilter("sbbid", "in", sbbids);
            if (isCCXWS || isSepcail) {
                filter.and(dateQFilter);
            }
            if (whereQFilter != null) {
                filter = filter.and(whereQFilter);
            }
        }
        if (filter != null) {
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)customSource.getSubname(), (String)selectKey, (QFilter[])new QFilter[]{filter}, null);
        }
        return null;
    }

    @Override
    public BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        QFilter nrxtype;
        boolean isCCXWS = false;
        boolean isSepcail = false;
        if (null != customSource.getSubname() && "".equals(customSource.getSubname())) {
            TableTypeMappingTemplateTypeEnum typeEnum = TableTypeMappingTemplateTypeEnum.getEnumByTableType(customSource.getType());
            if (null != typeEnum) {
                isCCXWS = TableTypeMappingTemplateTypeEnum.CCXWS == typeEnum;
                isSepcail = SPECAIL_LIST.contains(customSource.getSubname().toLowerCase());
                if ("tcret_ccxws_info".equalsIgnoreCase(customSource.getSubname())) {
                    isCCXWS = false;
                }
                nrxtype = new QFilter("type", "=", (Object)typeEnum.getTemplateType());
            } else {
                QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
                DynamicObjectCollection typeCollection = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
                if (null == typeCollection) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u4e0d\u5b58\u5728", (String)"NsrxxDataQueryServiceImpl_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
                }
                if (typeCollection.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e entryentity.entityid = %1$s,\u67e5\u8be2 tctb_template_type \u5b58\u5728\u591a\u6761\u8bb0\u5f55", (String)"NsrxxDataQueryServiceImpl_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), customSource.getSubname()));
                }
                nrxtype = new QFilter("type", "=", ((DynamicObject)typeCollection.get(0)).get(0));
            }
        } else if (StringUtils.isNotEmpty((CharSequence)customSource.getBblx())) {
            nrxtype = new QFilter("type", "=", (Object)customSource.getBblx());
        } else {
            QFilter entryid = new QFilter("entryentity.entityid", "=", (Object)customSource.getSubname());
            DynamicObjectCollection type = QueryServiceHelper.query((String)"tctb_template_type", (String)"id", (QFilter[])new QFilter[]{entryid});
            nrxtype = new QFilter("type", "=", ((DynamicObject)type.get(0)).get(0));
        }
        DynamicObjectCollection fidCollection = isCCXWS || isSepcail ? QueryServiceHelper.query((String)customSource.getEntityname(), (String)"id", (QFilter[])new QFilter[]{orgQFilter, nrxtype}) : QueryServiceHelper.query((String)customSource.getEntityname(), (String)"id", (QFilter[])new QFilter[]{orgQFilter, dateQFilter, nrxtype});
        if (EmptyCheckUtils.isNotEmpty(fidCollection)) {
            ArrayList<String> sbbids = new ArrayList<String>();
            for (DynamicObject dynamicObject : fidCollection) {
                sbbids.add(dynamicObject.getString("id"));
            }
            QFilter filter = new QFilter("sbbid", "in", sbbids);
            if (isCCXWS || isSepcail) {
                filter.and(dateQFilter);
            }
            if (whereQFilter != null) {
                filter = filter.and(whereQFilter);
            }
            return this.callOrmAggreGate(customSource.getSubname(), selectKey, new QFilter[]{filter});
        }
        return BigDecimal.ZERO;
    }
}

