/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.taxc.bdtaxr.business.executor.ThreadPoolEnum;

public class ThreadPoolJdkBusiness {
    private static Log logger = LogFactory.getLog(ThreadPoolJdkBusiness.class);
    private static volatile Map<String, ExecutorService> EXECUTOR_MAP = new HashMap<String, ExecutorService>(32);

    private static synchronized ExecutorService getService(String poolName) {
        if (EXECUTOR_MAP.size() == 0) {
            ThreadPoolJdkBusiness.init();
        }
        return EXECUTOR_MAP.get(poolName);
    }

    private static void init() {
        for (ThreadPoolEnum poolEnum : ThreadPoolEnum.values()) {
            if (EXECUTOR_MAP.containsKey(poolEnum.getCode())) continue;
            EXECUTOR_MAP.put(poolEnum.getCode(), ThreadPools.newCachedExecutorService((String)poolEnum.getCode(), (int)poolEnum.getCoreThread(), (int)poolEnum.getMaxThread()));
        }
    }

    public static Future<Object> submit(Callable call, String poolName) {
        ExecutorService service = ThreadPoolJdkBusiness.getService(poolName);
        if (service == null) {
            throw new KDBizException("threadpool with name " + poolName + " is not exist,check if already regist");
        }
        return service.submit(call);
    }
}

