/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.executor;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;
import kd.taxc.bdtaxr.business.executor.ThreadPoolEnum;

public class ThreadPoolV6Business {
    private static Log logger = LogFactory.getLog(ThreadPoolV6Business.class);
    private static volatile ThreadExecutorService threadExecutorService;

    private static synchronized ThreadExecutorService getService() {
        if (threadExecutorService == null) {
            threadExecutorService = ThreadPoolV6Business.create();
        }
        return threadExecutorService;
    }

    private static ThreadExecutorService create() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        strategy.setMinThreadNum(20).setMaxThreadNum(40).setOverflowThreadNum(10).setThreadIdeMinutes(1L);
        ArrayList<TaskType> taskTypeList = new ArrayList<TaskType>(ThreadPoolEnum.values().length);
        for (ThreadPoolEnum poolEnum : ThreadPoolEnum.values()) {
            taskTypeList.add(new TaskType(poolEnum.getCode(), Priority.getByLevel((int)poolEnum.getPriority()), ThreadLimitedModel.NUMBER, (Object)10, 20000));
        }
        strategy.register(taskTypeList);
        ThreadExecutorService threadExecutorService = ThreadPoolFactory.create((String)"taxc", (String)"taxc-threadpool", (ThreadPoolStrategy)strategy);
        return threadExecutorService;
    }

    public static Future<Object> submit(Callable call, String poolName, RequestContext context, OperationContext oc) {
        return ThreadPoolV6Business.getService().submit(call, poolName, context, oc);
    }
}

