/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.prescripted.service.impl;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedFileBusiness;
import kd.taxc.bdtaxr.business.prescripted.service.ScriptedExecuteService;
import kd.taxc.bdtaxr.common.dto.ScriptedExecuteParamsDto;
import kd.taxc.bdtaxr.common.dto.ScriptedExecuteResultDto;

public class SqlScriptedExecuteServiceImpl
implements ScriptedExecuteService {
    private static final Log logger = LogFactory.getLog(SqlScriptedExecuteServiceImpl.class);

    @Override
    public ScriptedExecuteResultDto scriptedExecute(ScriptedExecuteParamsDto params) {
        logger.info("\u90e8\u7f72\u6587\u4ef6\uff1a{}\uff0c\u5f00\u59cb\u6267\u884c\u3002", (Object)params.getFilename());
        long start = System.currentTimeMillis();
        DynamicObject obj = PreScriptedFileBusiness.queryPreScriptedFileContent(params.getPrescriptedid(), params.getPrescriptedentryid());
        if (obj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"SqlScriptedExecuteServiceImpl_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), params.getFilename()));
        }
        String fileContent = obj.getString("content_tag");
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"SqlScriptedExecuteServiceImpl_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), params.getFilename()));
        }
        ByteArrayInputStream inputStream = null;
        BufferedReader br = null;
        try {
            String line;
            Base64Encoder encoder = new Base64Encoder();
            byte[] bytes = encoder.decode(fileContent);
            inputStream = new ByteArrayInputStream(bytes);
            br = new BufferedReader(new InputStreamReader(inputStream));
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)params.getBizobjNumber());
            String dbRouteKey = entityType.getDBRouteKey();
            while ((line = br.readLine()) != null) {
                this.executeSql(dbRouteKey, line);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002", (String)"SqlScriptedExecuteServiceImpl_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), params.getFilename());
            throw new KDBizException(msg);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        ScriptedExecuteResultDto resultDto = new ScriptedExecuteResultDto();
        resultDto.setPrescriptedid(params.getPrescriptedid());
        resultDto.setPrescriptedentryid(params.getPrescriptedentryid());
        resultDto.setFilename(params.getFilename());
        resultDto.setScriptedplugin(params.getScriptedplugin());
        resultDto.setExecuteTime(System.currentTimeMillis() - start);
        logger.info("\u90e8\u7f72\u6587\u4ef6\uff1a{}\uff0c\u8017\u65f6 {}", (Object)params.getFilename(), (Object)(System.currentTimeMillis() - start));
        return resultDto;
    }

    private void executeSql(String routeKey, String sqlContent) {
        String ksqlStrs = this.oneCompleteSql(sqlContent);
        if (!StringUtils.isEmpty((CharSequence)ksqlStrs)) {
            logger.info("\u6267\u884cSQL\uff1a{}", (Object)ksqlStrs);
            DB.execute((DBRoute)new DBRoute(routeKey), (String)ksqlStrs);
        }
    }

    private String oneCompleteSql(String oriSQL) {
        if (!(oriSQL = oriSQL.trim()).toLowerCase(Locale.ENGLISH).startsWith("/*specialchar*/select") && !oriSQL.toLowerCase(Locale.ENGLISH).startsWith("/*specialchar*//*no_sharding*/select")) {
            StringBuilder sb = new StringBuilder();
            boolean isStart = false;
            String[] tempSqls = oriSQL.split("\\n");
            for (int j = 0; j < tempSqls.length; ++j) {
                String tmpResult = tempSqls[j].trim();
                if (tmpResult != null) {
                    if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("*/") != -1) {
                        tmpResult = tmpResult.replaceAll("\\/\\*.*?\\*\\/", "");
                    } else if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("*/") == -1 && tmpResult.indexOf("--") == -1) {
                        isStart = true;
                    } else if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("--") != -1 && tmpResult.indexOf("--") < tmpResult.indexOf("/*")) {
                        tmpResult = tmpResult.replaceAll("--.*", "");
                    }
                    if (isStart && tmpResult.indexOf("*/") != -1) {
                        isStart = false;
                        continue;
                    }
                    tmpResult = tmpResult.replaceAll("--.*", "").trim();
                }
                if (isStart || tmpResult == null || tmpResult.length() <= 0) continue;
                sb.append(tmpResult).append(" ");
            }
            return sb.toString().trim();
        }
        oriSQL = oriSQL.split("/\\*specialchar\\*/")[1];
        return oriSQL;
    }
}

