/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.ruletemplate;

import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleCodeEnum;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleConfigEnum;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleTypeEnum;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleTemplateBusiness {
    public static void setRuleConfig(BeforeF7SelectEvent evt, IDataModel dataModel, IFormView formView) {
        String fieldName = evt.getProperty().getName();
        int rowIndex = dataModel.getEntryCurrentRowIndex("entryentity");
        if (fieldName.equals("amountfield")) {
            DynamicObject tabletype = (DynamicObject)dataModel.getValue("table", rowIndex);
            if (tabletype == null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateBusiness_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String entityname = tabletype.getString("entityname");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (!EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                DynamicObject taxation;
                QFilter id = new QFilter("tableid", "=", tabletype.get("id")).and("state", "=", (Object)"1").and("isamount", "=", (Object)"1");
                formShowParameter.getListFilterParameter().setFilter(id);
                String entityName = ((BasedataEdit)evt.getSource()).getView().getFormShowParameter().getFormId();
                if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
                if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && null != (taxation = (DynamicObject)dataModel.getValue("taxation")) && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u9009\u62e9", (String)"RuleTemplateBusiness_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            }
        }
        if (fieldName.equals("table")) {
            String formId;
            String ruleType;
            DynamicObject org;
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            IDataEntityProperty property = dataModel.getProperty("org");
            if (property != null && (org = (DynamicObject)dataModel.getValue("org")) != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType(formId = formView.getFormShowParameter().getFormId())))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
    }

    public static void operationConfigClick(IDataModel dataModel, IFormView formView, AdvanceConfDto advanceConfDto, BeforeDoOperationEventArgs args, EntryGrid entryentity, IFormPlugin plugin) {
        int focusRow = entryentity.getEntryState().getFocusRow();
        DynamicObject tabletype = (DynamicObject)dataModel.getValue("table", focusRow);
        DynamicObject amountfield = (DynamicObject)dataModel.getValue("amountfield", focusRow);
        String entitySuffix = ((Donothing)args.getSource()).getOperateKey();
        entitySuffix = entitySuffix.replace("setadvancedconf", "");
        if (amountfield == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u6570\u5b57\u6bb5\u3002", (String)"RuleTemplateBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long fieldEntityId = null;
        if (EntityV3Constant.ENTITY_V3.containsKey(tabletype.getString("entityname"))) {
            Optional<DynamicObject> first = tabletype.getDynamicObjectCollection("entryentity").stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
            if (first.isPresent()) {
                fieldEntityId = first.get().getLong("id");
            }
        } else {
            fieldEntityId = amountfield.getLong("id");
        }
        if (fieldEntityId != null) {
            QFilter tableFilter = new QFilter("id", "=", (Object)tabletype.getLong("id"));
            QFilter fieldFilter = new QFilter("entryentity.id", "=", (Object)fieldEntityId);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.accesslogic", (QFilter[])new QFilter[]{tableFilter, fieldFilter});
            RuleTemplateBusiness.openAdvancedConfPage(advanceConfDto, formView, focusRow, tabletype.getLong("id"), "setadvancedconf" + entitySuffix, plugin, obj.getString("entryentity.accesslogic"));
        }
    }

    private static void openAdvancedConfPage(AdvanceConfDto advanceConfDto, IFormView formView, int rowIndex, long entityId, String actionId, IFormPlugin plugin, String accesslogic) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_advancedconf");
        CloseCallBack closeCallBack = new CloseCallBack(plugin, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("advancedConfData", accesslogic);
        formshowParameter.getCustomParams().put("advancedConfValue", advanceConfDto.getAdvancedconfjson());
        formshowParameter.getCustomParams().put("datatype", advanceConfDto.getDatatype());
        formshowParameter.getCustomParams().put("vatrate", advanceConfDto.getVatrate());
        formshowParameter.getCustomParams().put("yzvatrate", advanceConfDto.getYzvatrate());
        formshowParameter.getCustomParams().put("jsbl", advanceConfDto.getJsbl());
        formshowParameter.getCustomParams().put("advanceconfKey", advanceConfDto.getAdvanceconfKey());
        formshowParameter.getCustomParams().put("convert_rate_json", advanceConfDto.getConvertExrateJson());
        formshowParameter.getCustomParams().put("onlyRead", advanceConfDto.getOnlyRead());
        formView.showForm(formshowParameter);
    }

    public static void setAdvanceConfDefaultValue(IDataModel dataModel, int rowIndex, DynamicObject tabletype, DynamicObject amountfield, String advancedconf, String advancedconfjson) {
        RuleTemplateBusiness.setAdvanceConfDefaultValue(dataModel, rowIndex, tabletype, amountfield, advancedconf, advancedconfjson, null);
    }

    public static void setAdvanceConfDefaultValue(IDataModel dataModel, int rowIndex, DynamicObject tabletype, DynamicObject amountfield, String advancedconf, String advancedconfjson, String defaultValue) {
        IDataEntityProperty property;
        Object value;
        if (null == amountfield) {
            return;
        }
        Long datasourceId = tabletype.getLong("id");
        String tableName = tabletype.getString("name");
        String amountfieldName = amountfield.getString("fieldname");
        if (StringUtil.isEmpty((CharSequence)amountfieldName)) {
            return;
        }
        String subName = tabletype.getString("subname");
        if ("true".equals(tabletype.getString("ischild")) && StringUtil.isNotBlank((CharSequence)subName)) {
            CustomSource customSource = new CustomSource();
            customSource.setEntityname(tabletype.getString("entityname"));
            customSource.setSubname(subName);
            customSource.setSelectKeyEntity(amountfield.getString("fieldsubname"));
            if (RuleTemplateBusiness.isSubEntityField(customSource, amountfieldName)) {
                tableName = tabletype.getString("subname");
            }
        } else {
            tableName = amountfield.getString("fieldsubname");
        }
        DynamicObject dataEntity = dataModel.getDataEntity();
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        String entityName = dataEntityType.getName();
        String number = "";
        if (dataEntityType.getProperties().containsKey((Object)"item") && (value = dataModel.getValue("item")) != null) {
            DynamicObject item = (DynamicObject)value;
            number = item.getString("number");
        }
        if ((property = dataModel.getProperty(advancedconf)) != null) {
            String advancedconfjsonvalue = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DefaultAdvanceConfService", (String)"getValue", (Object[])new Object[]{entityName, number, tableName, amountfieldName, datasourceId, defaultValue});
            if (StringUtil.isEmpty((CharSequence)advancedconf)) {
                return;
            }
            String advancedconfvalue = RuleConfigEnum.getRuleConfigName(advancedconfjsonvalue);
            dataModel.setValue(advancedconf, (Object)advancedconfvalue);
            dataModel.setValue(advancedconfjson, (Object)advancedconfjsonvalue);
        }
    }

    private static boolean isSubEntityField(CustomSource customSource, String selectKey) {
        String[] key = RuleTemplateBusiness.splitSelectKey(selectKey);
        String mainEntity = customSource.getEntityname();
        String subEntity = customSource.getSubname();
        String selectKeyEntity = customSource.getSelectKeyEntity();
        String selectField = key[0];
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        if (null != mainEntityType.findProperty(selectField)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)mainEntity)) {
                return false;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)subEntity)) {
                if (mainEntityType.findProperty(selectKeyEntity) instanceof EntryProp) {
                    return true;
                }
                return mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp;
            }
            return mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp && StringUtils.equalsIgnoreCase((CharSequence)mainEntityType.findProperty(selectKeyEntity).getParent().getName(), (CharSequence)subEntity);
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)selectKeyEntity);
        if (null == entityType || null == entityType.findProperty(selectField)) {
            return false;
        }
        return false;
    }

    private static String[] splitSelectKey(String selectKey) {
        String[] key = selectKey.split(",");
        return key;
    }
}

