/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taskmonitor;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmonitor.TaxcTaskMonitorDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractTaskMonitor
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AbstractTaskMonitor.class);
    private static final String YES = "YES";
    public static final String TASK_CLASS_NAME = "taskClassName";
    public static final String TASK_NAME = "taskName";
    public static final String TASKDEFINE_ID = "taskdefineId";
    public static final String APPID = "appid";
    public static final String CLASSNAME = "classname";
    public static final String DISPATCHFLAG = "dispatchflag";
    public static final String ID = "id";
    public static final String TASK_ID = "taskId";
    public static final String EXECUTE_DETAIL = "executeDetail";
    public static final String SUCCESS = "success";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isCompleted;
        String msg;
        List subIds;
        block9: {
            try {
                Map<String, Object> paramsMap = this.buildTaskParams(requestContext, map);
                this.dealTaskParam(paramsMap, map);
                if (paramsMap != null && StringUtils.equals((CharSequence)String.valueOf(map.get("isSync")), (CharSequence)"1")) {
                    this.feedbackProgress(0);
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"branchCreateTask", (Object[])new Object[]{paramsMap});
                    if (result != null && StringUtils.equals((CharSequence)String.valueOf(result.get(SUCCESS)), (CharSequence)"true")) {
                        if (result.get("subIds") == null) {
                            this.feedbackProgress(100);
                            return;
                        }
                        subIds = (List)result.get("subIds");
                        TaxResult<List<String>> taxResult = TaxcTaskMonitorDataServiceHelper.submitSubJob(subIds);
                        if (taxResult == null || EmptyCheckUtils.isEmpty(taxResult.getData())) {
                            this.feedbackProgress(100);
                            return;
                        }
                        msg = this.buildNotification();
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)msg)) {
                            msg = ResManager.loadKDString((String)"\u5df2\u6267\u884c\u5b8c\u6210\u6570\u91cf\uff1a", (String)"AbstractTaskMonitor_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                        }
                        break block9;
                    }
                    this.feedbackProgress(100);
                    Map<String, Object> params = AbstractTaskMonitor.buildParams(Boolean.FALSE, this.taskId, ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (String)"AbstractTaskMonitor_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    TaxcTaskMonitorDataServiceHelper.updateTaskMonitor(params);
                    return;
                }
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"branchCreateTask", (Object[])new Object[]{paramsMap});
                return;
            }
            catch (Exception e) {
                logger.error("AbstarctTaskMonitor error", (Throwable)e);
                Map<String, Object> params = AbstractTaskMonitor.buildParams(Boolean.FALSE, this.taskId, e.getMessage());
                TaxcTaskMonitorDataServiceHelper.updateTaskMonitor(params);
            }
            return;
        }
        do {
            this.checkIsStop();
            boolean stop = this.isStop();
            if (!stop) {
                DynamicObject[] subTaskList = BusinessDataServiceHelper.load((Object[])subIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_task_monitor_detail"));
                List<String> subTaskIds = Arrays.stream(subTaskList).map(o -> o.getString("taskid")).collect(Collectors.toList());
                int progress = this.handleTaskProcess(subIds, subTaskIds);
                int completeNums = this.handleEndTaskProcess(subIds, subTaskIds);
                this.feedbackProgress(progress, msg + completeNums + "/" + subIds.size(), null);
                boolean bl = isCompleted = progress == 100;
                if (!isCompleted) continue;
                logger.info("\u6267\u884c\u5b8c\u6210+", (Object)this.taskId);
                Map<String, Object> params = AbstractTaskMonitor.buildParams(Boolean.TRUE, this.taskId, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"AbstractTaskMonitor_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                TaxcTaskMonitorDataServiceHelper.updateTaskMonitor(params);
                continue;
            }
            isCompleted = true;
            Map<String, Object> params = AbstractTaskMonitor.buildParams(Boolean.FALSE, this.taskId, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"AbstractTaskMonitor_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            params.put("isstop", true);
            TaxcTaskMonitorDataServiceHelper.updateTaskMonitor(params);
        } while (!isCompleted);
    }

    public abstract Map<String, Object> buildTaskParams(RequestContext var1, Map<String, Object> var2);

    public abstract String buildNotification();

    private static Map<String, Object> buildParams(Boolean success, String taskId, String message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SUCCESS, success.toString());
        params.put(TASK_ID, taskId);
        params.put(EXECUTE_DETAIL, message);
        return params;
    }

    private void dealTaskParam(Map<String, Object> paramsMap, Map<String, Object> map) {
        if (paramsMap != null && paramsMap.get("subTasks") != null) {
            List taskdefineIds = ((List)paramsMap.get("subTasks")).stream().map(o -> String.valueOf(o.get(TASKDEFINE_ID))).collect(Collectors.toList());
            taskdefineIds.add(String.valueOf(paramsMap.get(TASKDEFINE_ID)));
            QFilter idFilter = new QFilter(ID, "in", taskdefineIds);
            Map taskdefineData = BusinessDataServiceHelper.loadFromCache((String)"sch_taskdefine", (String)"id,number,appid,name,classname", (QFilter[])new QFilter[]{idFilter});
            if (taskdefineData != null) {
                Map<String, DynamicObject> taskdefineMap = taskdefineData.values().stream().collect(Collectors.toMap(d -> d.getString(ID), v -> v));
                paramsMap.put(APPID, taskdefineMap.get(paramsMap.get(TASKDEFINE_ID)).getString(APPID));
                String className = taskdefineMap.get(paramsMap.get(TASKDEFINE_ID)).getString(CLASSNAME);
                paramsMap.put(TASK_CLASS_NAME, className);
                paramsMap.put(TASK_NAME, className.substring(className.lastIndexOf(46) + 1));
                List subTasks = (List)paramsMap.get("subTasks");
                subTasks.stream().forEach(o -> {
                    o.put(APPID, ((DynamicObject)taskdefineMap.get(o.get(TASKDEFINE_ID))).getString(APPID));
                    String subClassName = ((DynamicObject)taskdefineMap.get(o.get(TASKDEFINE_ID))).getString(CLASSNAME);
                    o.put(TASK_CLASS_NAME, subClassName);
                    o.put(TASK_NAME, subClassName.substring(subClassName.lastIndexOf(46) + 1));
                    if (StringUtils.equals((CharSequence)String.valueOf(map.get("isSync")), (CharSequence)"1")) {
                        o.put(DISPATCHFLAG, YES);
                    }
                });
            }
        }
    }

    private int handleTaskProcess(List<Long> subIds, List<String> subTaskIds) {
        if (CollectionUtils.isNotEmpty(subTaskIds)) {
            List subTaskDbList = ScheduleServiceHelper.queryTask(subTaskIds);
            long totalCount = subTaskDbList.size();
            List runingList = subTaskDbList.stream().filter(x -> x.getStatus().equals("SCHEDULED") || x.getStatus().equals("BEGIN") || x.getStatus().equals("RUNNING")).collect(Collectors.toList());
            List completeList = subTaskDbList.stream().filter(x -> x.getStatus().equals("COMPLETED") || x.getStatus().equals("FAILED") || x.getStatus().equals("ABORTED")).collect(Collectors.toList());
            return BigDecimalUtil.divideObject(runingList.size() + completeList.size(), totalCount, 2).multiply(new BigDecimal(100)).intValue();
        }
        return 100;
    }

    private int handleEndTaskProcess(List<Long> subIds, List<String> subTaskIds) {
        if (CollectionUtils.isNotEmpty(subTaskIds)) {
            List subTaskDbList = ScheduleServiceHelper.queryTask(subTaskIds);
            List completeList = subTaskDbList.stream().filter(x -> x.getStatus().equals("COMPLETED") || x.getStatus().equals("FAILED") || x.getStatus().equals("ABORTED")).collect(Collectors.toList());
            return completeList.isEmpty() ? 0 : completeList.size();
        }
        return 0;
    }
}

