/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcmain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.BillStatusConstant;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bos.param.SystemParamDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.FilterBuilderUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxcMainBusiness {
    public static final Log logger = LogFactory.getLog(TaxcMainBusiness.class);

    public static String queryTaxcMainCategoryFieldForHws(DynamicObject obj, Long categoryId, String selectField) {
        return TaxcMainBusiness.queryCategoryFieldForHws(obj, categoryId, selectField);
    }

    public static List<String> queryTaxcMainCategoryFieldForHws(DynamicObject obj, Long categoryId, Long taxAreaId, String selectField, boolean isIncludeDisable) {
        return TaxcMainBusiness.queryCategoryFieldForHws(obj, categoryId, taxAreaId, selectField, isIncludeDisable);
    }

    public static List<DynamicObject> queryTaxcMainCategoryForHws(List<DynamicObject> objs, List<Long> categoryIds, List<Long> taxAreaIds) {
        for (DynamicObject obj : objs) {
            TaxcMainBusiness.filterCategoryForHws(obj, categoryIds, taxAreaIds);
        }
        return objs;
    }

    public static void queryTaxcMainCategory(List<DynamicObject> objs, String taxType) {
        if (CollectionUtils.isNotEmpty(objs)) {
            objs.stream().forEach(o -> TaxcMainBusiness.filterTaxtype(o, taxType));
        }
    }

    public static void queryCategoryForHws(DynamicObject obj, Long categoryId, boolean isIncludedisable) {
        TaxcMainBusiness.filterTaxtypeForHws(obj, categoryId, isIncludedisable);
    }

    public static DynamicObjectCollection queryTaxcMainByIdAndWhereJson(Long id, String selectFields, String whereJson) {
        if (id != null && id != 0L) {
            QFilter qFilter = new QFilter(TaxcMainConstant.ID, "=", (Object)id);
            if (StringUtils.isNotBlank((CharSequence)whereJson)) {
                QFilter jsonQfilter = FilterBuilderUtils.buildFilter(whereJson, TaxcMainConstant.ENTITYNAME);
                qFilter = qFilter.and(jsonQfilter);
            }
            return QueryServiceHelper.query((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        }
        return new DynamicObjectCollection();
    }

    public static List<Long> queryTaxcMainByIsYbnsr(List<DynamicObject> objs) {
        return objs.stream().filter(o -> TaxcMainBusiness.isYbnsr(o)).map(o -> o.getLong("taxorg.org.id")).collect(Collectors.toList());
    }

    private static Boolean isYbnsr(DynamicObject doc) {
        Optional<DynamicObject> first;
        DynamicObjectCollection categoryentryentity;
        Boolean isYbnsr = Boolean.FALSE;
        if (null != doc && CollectionUtils.isNotEmpty((Collection)(categoryentryentity = doc.getDynamicObjectCollection("categoryentryentity"))) && (first = categoryentryentity.stream().filter(s -> TaxcMainConstant.TAXTYPE_ZZS.equals(s.getString("taxtype"))).findFirst()).isPresent() && first.get().getString("taxpayertype").equals("ybnsr")) {
            isYbnsr = Boolean.TRUE;
        }
        return isYbnsr;
    }

    private static String queryCategoryFieldForHws(DynamicObject doc, Long categoryId, String selectField) {
        DynamicObjectCollection entryentity;
        DynamicObjectCollection entryObjs;
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("hwsentryentity")) && CollectionUtils.isNotEmpty((Collection)(entryObjs = (entryentity = doc.getDynamicObjectCollection("hwsentryentity")).stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new))))) {
            return ((DynamicObject)entryObjs.get(0)).getString(selectField);
        }
        return null;
    }

    private static List<String> queryCategoryFieldForHws(DynamicObject doc, Long categoryId, Long taxAreaId, String selectField, boolean isIncludeDisable) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("hwsentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("hwsentryentity");
            DynamicObjectCollection entryObjs = taxAreaId != null ? (!isIncludeDisable ? entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue() && o.getDynamicObject("hwstaxarea") != null && o.getDynamicObject("hwstaxarea").getLong("id") == taxAreaId.longValue() && o.getBoolean("hwsenable")).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue() && o.getDynamicObject("hwstaxarea") != null && o.getDynamicObject("hwstaxarea").getLong("id") == taxAreaId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new))) : (!isIncludeDisable ? entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue() && o.getBoolean("hwsenable")).collect(Collectors.toCollection(DynamicObjectCollection::new)));
            if (CollectionUtils.isNotEmpty((Collection)entryObjs)) {
                return entryObjs.stream().map(o -> o.getString(selectField)).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    private static void filterCategoryForHws(DynamicObject doc, List<Long> categoryIds, List<Long> taxAreaIds) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("hwsentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("hwsentryentity");
            DynamicObjectCollection entryObjs = CollectionUtils.isNotEmpty(taxAreaIds) ? entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && categoryIds.contains(o.getDynamicObject("hwstaxtype").getLong("id")) && o.getDynamicObject("hwstaxarea") != null && taxAreaIds.contains(o.getDynamicObject("hwstaxarea").getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && categoryIds.contains(o.getDynamicObject("hwstaxtype").getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("hwsentryentity", (Object)entryObjs);
        }
    }

    private static void filterTaxtype(DynamicObject doc, String type) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("categoryentryentity");
            DynamicObjectCollection entryObjs = entryentity.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("taxtype"), (CharSequence)type)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("categoryentryentity", (Object)entryObjs);
        }
    }

    private static void filterTaxtypeForHws(DynamicObject doc, Long categoryId, boolean isIncludedisable) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("hwsentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("hwsentryentity");
            DynamicObjectCollection entryObjs = null;
            if (categoryId != null) {
                entryObjs = !isIncludedisable ? entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue() && o.getBoolean("hwsenable")).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
            } else if (!isIncludedisable) {
                entryObjs = entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getBoolean("hwsenable")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            }
            doc.set("hwsentryentity", entryObjs);
        }
    }

    public static DynamicObjectCollection queryTaxcMainByCustomFilter(List<Long> orgIds, Long taxationsysId, String selectFields, QFilter[] qFilters, String orderBy) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (orgIds != null && orgIds.size() > 0) {
            filterList.add(TaxcMainConstant.taxOrgQFilter(orgIds));
        }
        if (TaxcMainBusiness.isOverseasTaxOrg()) {
            if (taxationsysId != null) {
                filterList.add(new QFilter("taxationsys", "=", (Object)taxationsysId));
            }
        } else {
            filterList.add(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId()));
        }
        if (qFilters != null) {
            filterList.addAll(Arrays.asList(qFilters));
        }
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = TaxcMainConstant.BASE_FILEDS;
        }
        if (filterList.size() > 0) {
            return QueryServiceHelper.query((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)orderBy);
        }
        return new DynamicObjectCollection();
    }

    public static boolean isOverseasTaxOrg() {
        boolean isEnable = false;
        TaxResult<Object> appParameter = SystemParamDataServiceHelper.getAppParameter("tctb", "enableoverseastax", OrgUnitServiceHelper.getRootOrgId());
        if (appParameter != null && appParameter.getData() != null) {
            isEnable = (Boolean)appParameter.getData();
        }
        return isEnable;
    }

    public static List<Long> getTaxationsysIds(List<DynamicObject> docs) {
        HashSet<Long> taxationsysIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(docs)) {
            for (DynamicObject doc : docs) {
                if (doc == null || !TaxcMainBusiness.filterBillStatusAndStatus(doc).booleanValue() || !TaxcMainBusiness.filterTaxPayer(doc).booleanValue()) continue;
                taxationsysIds.add(doc.getLong("taxationsys.id"));
            }
        }
        return taxationsysIds.stream().collect(Collectors.toList());
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc) {
        if (null != doc && doc.getDynamicObject("taxorg") != null && BillStatusConstant.isBillStatus(doc) && doc.getDynamicObject("taxorg") != null) {
            Long taxationsysId = doc.getLong("taxationsys.id");
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            if (taxationsysId != null) {
                Optional<DynamicObject> entryObj = entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst();
                return entryObj.isPresent();
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean filterTaxPayer(DynamicObject doc) {
        if (null != doc && doc.getDynamicObject("taxorg") != null) {
            Long taxationsysId = doc.getLong("taxationsys.id");
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            if (taxationsysId != null) {
                Optional<DynamicObject> entryObj = entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst();
                return entryObj.isPresent();
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean filterCommon(DynamicObject taxmain, Boolean isAudit, Boolean isEnable, Boolean isTaxpayer, Long taxationsysId) {
        if (null != taxmain) {
            if (isAudit != null && BillStatusConstant.isBillStatus(taxmain) != isAudit) {
                return false;
            }
            Long dynTaxationsysId = taxmain.getLong("taxationsys.id");
            if (taxationsysId != null && taxationsysId.compareTo(dynTaxationsysId) != 0) {
                return false;
            }
            DynamicObject org = taxmain.getDynamicObject("taxorg");
            if (org == null) {
                logger.error("taxmain_org data is null,org-" + taxmain.get("orgid.id") + taxmain.getString("orgid.name"));
                return false;
            }
            if (isEnable != null && isEnable != TaxcMainBusiness.orgTaxMainIsEnable(org, dynTaxationsysId)) {
                return false;
            }
            if (isTaxpayer != null && isTaxpayer != TaxcMainBusiness.orgTaxMainIsTaxpayer(org, dynTaxationsysId)) {
                return false;
            }
        }
        return Boolean.TRUE;
    }

    public static boolean filterIsRegisterPlace(DynamicObject taxmain, Boolean isRegisterPlace) {
        return taxmain.getBoolean("registerplace") == isRegisterPlace.booleanValue();
    }

    private static Boolean orgTaxMainIsEnable(DynamicObject org, Long taxationsysId) {
        DynamicObjectCollection taxMainEntrys = org.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : taxMainEntrys) {
            Long dynTaxationsysId = dyn.getLong("entry_taxationsys.id");
            if (taxationsysId.compareTo(dynTaxationsysId) != 0) continue;
            return "1".equals(dyn.getString("entry_status"));
        }
        return false;
    }

    private static Boolean orgTaxMainIsTaxpayer(DynamicObject org, Long taxationsysId) {
        DynamicObjectCollection taxMainEntrys = org.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : taxMainEntrys) {
            Long dynTaxationsysId = dyn.getLong("entry_taxationsys.id");
            if (taxationsysId.compareTo(dynTaxationsysId) != 0) continue;
            return true == dyn.getBoolean("entry_istaxpayer");
        }
        return false;
    }

    public static List<DynamicObject> filterCommonBatch(List<DynamicObject> taxmainDyns, Boolean isAudit, Boolean isEnable, Boolean isTaxpayer, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyn : taxmainDyns) {
            if (!TaxcMainBusiness.filterCommon(dyn, isAudit, isEnable, isTaxpayer, taxationsysId).booleanValue()) continue;
            list.add(dyn);
        }
        return list;
    }

    public static List<DynamicObject> filterIsRegisterPlaceBatch(List<DynamicObject> taxmainDyns, Boolean isRegistPlace) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyn : taxmainDyns) {
            if (!TaxcMainBusiness.filterIsRegisterPlace(dyn, isRegistPlace)) continue;
            list.add(dyn);
        }
        return list;
    }
}

