/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.tctb.provision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionSharePlanService {
    public static DynamicObjectCollection filter(List<DynamicObject> docs, List<Long> orgIds, Long categoryId, Long taxationsysId, Date startDate, Date endDate) {
        if (docs == null || docs.size() == 0) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection objs = new DynamicObjectCollection();
        DynamicObject rule = null;
        DynamicObject org = null;
        DynamicObjectCollection ruleEntries = null;
        DynamicObjectCollection orgEntries = null;
        for (DynamicObject doc : docs) {
            ruleEntries = new DynamicObjectCollection();
            orgEntries = new DynamicObjectCollection();
            for (DynamicObject ruleEntry : doc.getDynamicObjectCollection("ruleentity")) {
                rule = ruleEntry.getDynamicObject("rule");
                if (!ObjectUtils.isNotEmpty((Object)rule) || !ProvisionSharePlanService.filterCategory(rule, categoryId) || !ProvisionSharePlanService.filterTaxationsys(rule, taxationsysId) || !ProvisionSharePlanService.filterEffective(rule, startDate, endDate)) continue;
                ruleEntries.add((Object)ruleEntry);
            }
            for (DynamicObject orgEntry : doc.getDynamicObjectCollection("orgentity")) {
                org = orgEntry.getDynamicObject("org");
                if (!ObjectUtils.isNotEmpty((Object)org) || !ProvisionSharePlanService.filterOrg(org, orgIds)) continue;
                orgEntries.add((Object)orgEntry);
            }
            if (ruleEntries.size() <= 0 || orgEntries.size() <= 0) continue;
            doc.set("ruleentity", (Object)ruleEntries);
            doc.set("orgentity", (Object)orgEntries);
            objs.add((Object)doc);
        }
        return objs;
    }

    public static boolean filterEffective(DynamicObject entry, Date startDate, Date endDate) {
        Date beginTime = DateUtils.trunc(entry.getDate("startdate"), "yyyy-MM-dd");
        Date endTime = DateUtils.trunc(entry.getDate("enddate"), "yyyy-MM-dd");
        Date planStart = ProvisionSharePlanService.fomartDayTime(beginTime);
        Date planEnd = ProvisionSharePlanService.fomartDayTime(endTime);
        Date reqStart = ProvisionSharePlanService.fomartDayTime(startDate);
        Date reqEnd = ProvisionSharePlanService.fomartDayTime(endDate);
        if (planStart != null) {
            if (reqStart == null) {
                return false;
            }
            if (planStart.after(reqStart)) {
                return false;
            }
        }
        if (planEnd != null) {
            if (reqEnd == null) {
                return false;
            }
            if (planEnd.before(reqEnd)) {
                return false;
            }
        }
        return true;
    }

    private static Date fomartDayTime(Date d) {
        if (d == null) {
            return null;
        }
        String str = DateUtils.format(d, "yyyy-MM-dd");
        return DateUtils.stringToDate(str);
    }

    public static boolean filterCategory(DynamicObject entry, Long categoryId) {
        return entry.getLong("taxtype.id") == categoryId.longValue();
    }

    public static boolean filterTaxationsys(DynamicObject entry, Long taxationsysId) {
        return entry.getLong("taxsystem.id") == taxationsysId.longValue();
    }

    public static boolean filterOrg(DynamicObject entry, List<Long> orgIds) {
        return orgIds.contains(entry.getLong("id"));
    }

    public static DynamicObject filterPlanUse(DynamicObject shareDyn, Boolean jt, Boolean js) {
        DynamicObject[] dyns = ProvisionSharePlanService.filterPlanUse(new DynamicObject[]{shareDyn}, jt, js);
        if (dyns.length > 0) {
            return dyns[0];
        }
        return null;
    }

    public static DynamicObject[] filterPlanUse(DynamicObject[] shareDyns, Boolean jt, Boolean js) {
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(10);
        for (DynamicObject item : shareDyns) {
            dyns.add(item);
        }
        ProvisionSharePlanService.filterPlanUseCollection(dyns, jt, js);
        return dyns.toArray(new DynamicObject[0]);
    }

    public static void filterPlanUseCollection(Collection<DynamicObject> shareDyns, Boolean jt, Boolean js) {
        DynamicObjectCollection dyns;
        if (shareDyns instanceof DynamicObjectCollection && shareDyns.size() > 0 && (dyns = (DynamicObjectCollection)shareDyns).getDynamicObjectType().getName().equals("PlainObject")) {
            ProvisionSharePlanService.filterPlanUseCollectionByQuery(dyns, jt, js);
            return;
        }
        ProvisionSharePlanService.filterPlanUseCollectionByLoad(shareDyns, jt, js);
    }

    public static void filterPlanUseCollectionByQuery(DynamicObjectCollection shareDyns, Boolean jt, Boolean js) {
        List notMatchPlanUseDyns = shareDyns.stream().filter(item -> {
            String planUse = item.getString("ruleentity.rule.planuse");
            return !ProvisionSharePlanService.checkPlanUseMulti(planUse, jt, js);
        }).collect(Collectors.toList());
        shareDyns.removeAll(notMatchPlanUseDyns);
    }

    public static void filterEnableCollectionByQuery(DynamicObjectCollection shareDyns, Boolean enable) {
        if (enable == null) {
            return;
        }
        List notMatchPlanUseDyns = shareDyns.stream().filter(item -> {
            String ruleEnable = item.getString("ruleentity.rule.enable");
            boolean match = enable != false ? "1".equals(ruleEnable) : "0".equals(ruleEnable);
            return !match;
        }).collect(Collectors.toList());
        shareDyns.removeAll(notMatchPlanUseDyns);
    }

    public static void filterPlanUseCollectionByLoad(Collection<DynamicObject> shareDyns, Boolean jt, Boolean js) {
        for (DynamicObject dyn : shareDyns) {
            DynamicObjectCollection rules = dyn.getDynamicObjectCollection("ruleentity");
            for (int i = 0; i < rules.size(); ++i) {
                DynamicObject rule = (DynamicObject)rules.get(i);
                if (ProvisionSharePlanService.checkPlanUseMulti(rule.getDynamicObject("rule"), jt, js)) continue;
                rules.remove(i);
                --i;
            }
        }
        ArrayList<DynamicObject> needRemove = new ArrayList<DynamicObject>();
        for (DynamicObject share : shareDyns) {
            DynamicObjectCollection rules = share.getDynamicObjectCollection("ruleentity");
            if (rules.size() != 0) continue;
            needRemove.add(share);
        }
        for (DynamicObject removeItem : needRemove) {
            shareDyns.remove(removeItem);
        }
    }

    public static void filterEnableCollectionByLoad(Collection<DynamicObject> shareDyns, Boolean enable) {
        if (enable == null) {
            return;
        }
        for (DynamicObject dyn : shareDyns) {
            DynamicObjectCollection rules = dyn.getDynamicObjectCollection("ruleentity");
            for (int i = 0; i < rules.size(); ++i) {
                boolean match;
                DynamicObject plan = ((DynamicObject)rules.get(i)).getDynamicObject("rule");
                String ruleEnable = plan.getString("enable");
                boolean bl = match = enable != false ? "1".equals(ruleEnable) : "0".equals(ruleEnable);
                if (match) continue;
                rules.remove(i);
                --i;
            }
        }
        ArrayList<DynamicObject> needRemove = new ArrayList<DynamicObject>();
        for (DynamicObject share : shareDyns) {
            DynamicObjectCollection rules = share.getDynamicObjectCollection("ruleentity");
            if (rules.size() != 0) continue;
            needRemove.add(share);
        }
        for (DynamicObject removeItem : needRemove) {
            shareDyns.remove(removeItem);
        }
    }

    public static boolean checkPlanUseMulti(DynamicObject dyn, Boolean jt, Boolean js) {
        if (dyn == null) {
            return false;
        }
        String planUse = dyn.getString("planuse");
        return ProvisionSharePlanService.checkPlanUseMulti(planUse, jt, js);
    }

    public static boolean checkPlanUseMulti(String planUse, Boolean jt, Boolean js) {
        if (planUse == null) {
            return false;
        }
        boolean b1 = true;
        boolean b2 = true;
        if (jt != null) {
            boolean bl = jt != false ? planUse.contains("1") : (b1 = !planUse.contains("1"));
        }
        if (js != null) {
            b2 = js != false ? planUse.contains("2") : !planUse.contains("2");
        }
        return b1 & b2;
    }
}

