/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import kd.taxc.bdtaxr.common.utils.EnumUtils;

public enum TaxationsysMappingEnum {
    CHN(1L, "001"),
    USA(1636078644810086400L, "USA"),
    JAP(1639891185130547200L, "JAP"),
    AUS(1641472332713202688L, "AUS"),
    SGP(1641472878945800192L, "SGP"),
    GBR(1641473561812045824L, "GBR"),
    HKG(1682720296203064320L, "HKG"),
    DEU(1641474108371800064L, "DEU");

    private Long id;
    private String number;

    private TaxationsysMappingEnum(Long id, String number) {
        this.id = id;
        this.number = number;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public static TaxationsysMappingEnum getEnumByNumber(String number) {
        return EnumUtils.getEnumByPredicate(e -> e.getNumber().equalsIgnoreCase(number), TaxationsysMappingEnum::values);
    }

    public static TaxationsysMappingEnum getEnumById(Long id) {
        return EnumUtils.getEnumByPredicate(e -> e.getId().longValue() == id.longValue(), TaxationsysMappingEnum::values);
    }
}

