/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.business.TaxcCombineBusinessDataBusiness;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorgan.TaxcOrganDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxcCombineBusinessDataServiceHelper {
    public static TaxResult<List<DynamicObject>> loadExtentByTaxcCodeNumbers(List<String> numbers) {
        return TaxcCombineBusinessDataBusiness.loadExtentByTaxcCodeNumbers(numbers);
    }

    public static TaxResult<Map<String, List<TaxcodeDetailDto>>> loadExtentByTaxcCodeNumbersGroupByTaxCode(List<String> numbers) {
        return TaxcCombineBusinessDataBusiness.loadExtentByTaxcCodeNumbersGroupByTaxCode(numbers);
    }

    public static TaxResult<Long> queryTopTaxauthorityByOrgId(Long orgId) {
        TaxResult<DynamicObject> taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId(orgId);
        if (taxResult != null && taxResult.getData() != null) {
            long taxoffice = taxResult.getData().getLong("taxoffice.id");
            return TaxcOrganDataServiceHelper.getOneLevelTaxcOrganIdById(taxoffice);
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, 0L);
    }

    public static TaxResult<List<Long>> queryTaxcMaintaxationsysIdsByOrgIds(List<Long> orgIds) {
        TaxResult<List<DynamicObject>> taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayer(orgIds, null);
        if (taxResult != null && CollectionUtils.isNotEmpty((Collection)taxResult.getData())) {
            return ServiceInvokeUtils.buildTaxResult(Long.class, TaxcMainBusiness.getTaxationsysIds(taxResult.getData()));
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, null);
    }

    public static TaxResult<OperationResult> taxMainOperation(List<Long> ids, String operationKey, Map<String, String> params) {
        OperateOption operateOption = OperateOption.create();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                operateOption.setVariableValue(entry.getKey(), entry.getValue());
            }
        }
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)TaxcMainConstant.ENTITYNAME, (Object[])ids.toArray(), (OperateOption)operateOption);
        if (result.isSuccess()) {
            return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.TRUE, TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), result.getMessage(), result);
        }
        return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.FALSE, TaxcErrorCode.TAXC_FAILED_CODE.getCode(), result.getMessage(), result);
    }

    public static TaxResult<OperationResult> taxOrgMappingOperation(List<Long> ids, String operationKey, Map<String, String> params) {
        OperateOption operateOption = OperateOption.create();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                operateOption.setVariableValue(entry.getKey(), entry.getValue());
            }
        }
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)"tctb_orgmaprelation", (Object[])ids.toArray(), (OperateOption)operateOption);
        if (result.isSuccess()) {
            return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.TRUE, TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), result.getMessage(), result);
        }
        return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.FALSE, TaxcErrorCode.TAXC_FAILED_CODE.getCode(), result.getMessage(), result);
    }

    public static TaxResult<OperationResult> taxcParamApplyOperation(List<Long> ids, String operationKey, Map<String, String> params) {
        OperateOption operateOption = OperateOption.create();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                operateOption.setVariableValue(entry.getKey(), entry.getValue());
            }
        }
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)"tctb_param_apply", (Object[])ids.toArray(), (OperateOption)operateOption);
        if (result.isSuccess()) {
            return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.TRUE, TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), result.getMessage(), result);
        }
        return ServiceInvokeUtils.buildTaxResult(OperationResult.class, Boolean.FALSE, TaxcErrorCode.TAXC_FAILED_CODE.getCode(), result.getMessage(), result);
    }
}

